/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.inbound.endpoint.common.InboundOneTimeTriggerRequestProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQConnectionConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQTask;

public class RabbitMQListener
extends InboundOneTimeTriggerRequestProcessor {
    private static final String ENDPOINT_POSTFIX = "RABBITMQ--SYNAPSE_INBOUND_ENDPOINT";
    private static final Log log = LogFactory.getLog(RabbitMQListener.class);
    private String injectingSeq;
    private String onErrorSeq;
    private Properties rabbitmqProperties;
    private boolean sequential;
    private RabbitMQConnectionFactory rabbitMQConnectionFactory;
    private RabbitMQConnectionConsumer connectionConsumer;
    private RabbitMQInjectHandler injectHandler;
    private InboundProcessorParams params;

    public RabbitMQListener(InboundProcessorParams params) {
        this.name = params.getName();
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
        this.rabbitmqProperties = params.getProperties();
        this.params = params;
        this.sequential = true;
        if (this.rabbitmqProperties.getProperty("sequential") != null) {
            this.sequential = Boolean.parseBoolean(this.rabbitmqProperties.getProperty("sequential"));
        }
        this.coordination = true;
        if (this.rabbitmqProperties.getProperty("coordination") != null) {
            this.coordination = Boolean.parseBoolean(this.rabbitmqProperties.getProperty("coordination"));
        }
        this.rabbitMQConnectionFactory = new RabbitMQConnectionFactory(this.rabbitmqProperties);
        this.injectHandler = new RabbitMQInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment);
    }

    @Override
    public void destroy() {
        this.connectionConsumer.requestShutdown();
        super.destroy();
    }

    public void init() {
        log.info((Object)("RABBITMQ inbound endpoint " + this.name + " initializing ..."));
        this.connectionConsumer = new RabbitMQConnectionConsumer(this.rabbitMQConnectionFactory, this.rabbitmqProperties, this.injectHandler);
        this.connectionConsumer.setInboundName(this.name);
        this.start();
    }

    public void start() {
        RabbitMQTask rabbitMQTask = new RabbitMQTask(this.connectionConsumer);
        this.start(rabbitMQTask, ENDPOINT_POSTFIX);
    }
}

