/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQMessage;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;

public class RabbitMQInjectHandler {
    private static final Log log = LogFactory.getLog(RabbitMQInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;

    public RabbitMQInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
    }

    public boolean invoke(RabbitMQMessage message, String inboundName) {
        SequenceMediator seq;
        int index;
        boolean success = true;
        org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
        log.debug((Object)"Processed RabbitMQ Message ");
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        String amqpCorrelationID = message.getCorrelationId();
        if (amqpCorrelationID != null && amqpCorrelationID.length() > 0) {
            msgCtx.setProperty("rabbitmq.message.correlation.id", (Object)amqpCorrelationID);
        } else {
            msgCtx.setProperty("rabbitmq.message.correlation.id", (Object)message.getMessageId());
        }
        axis2MsgCtx.setProperty("TRANSPORT_HEADERS", (Object)RabbitMQUtils.getTransportHeaders(message));
        String contentType = message.getContentType();
        Builder builder = null;
        if (contentType == null) {
            log.warn((Object)("Unable to determine content type for message " + msgCtx.getMessageID() + " setting to text/plain"));
            contentType = "text/plain";
            message.setContentType(contentType);
        }
        String type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType;
        try {
            builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()));
        }
        if (builder == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
            }
            builder = new SOAPBuilder();
        }
        OMElement documentElement = null;
        ByteArrayInputStream in = new ByteArrayInputStream(message.getBody());
        try {
            documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while processing message :: " + axisFault.getMessage()));
        }
        try {
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while setting message payload to the message context :: " + axisFault.getMessage()));
        }
        if (this.injectingSeq == null || this.injectingSeq.equals("")) {
            log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
            success = false;
        }
        if ((seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
            }
            if (!seq.isInitialized()) {
                seq.init(this.synapseEnvironment);
            }
            seq.setErrorHandler(this.onErrorSeq);
            msgCtx.setProperty("isInbound", (Object)true);
            msgCtx.setProperty("inbound.endpoint.name", (Object)inboundName);
            this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential);
        } else {
            log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
        }
        Object rollbackProperty = msgCtx.getProperty("SET_ROLLBACK_ONLY");
        if (rollbackProperty != null && rollbackProperty instanceof Boolean && ((Boolean)rollbackProperty).booleanValue() || rollbackProperty instanceof String && Boolean.valueOf((String)rollbackProperty).booleanValue()) {
            success = false;
        }
        return success;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        return msgCtx;
    }
}

