/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQException;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;

public class RabbitMQConnectionFactory {
    private static final Log log = LogFactory.getLog(RabbitMQConnectionFactory.class);
    private ConnectionFactory connectionFactory;
    private String name;
    private Hashtable<String, String> parameters = new Hashtable();
    private int retryInterval = 30000;
    private int retryCount = 3;
    private Address[] addresses;

    public RabbitMQConnectionFactory(Properties properties) {
        this.name = properties.getProperty("rabbitmq.connection.factory");
        for (String name : properties.stringPropertyNames()) {
            this.parameters.put(name, properties.getProperty(name));
        }
        this.initConnectionFactory();
    }

    public RabbitMQConnectionFactory(String name, Hashtable<String, String> parameters) {
        this.name = name;
        this.parameters = parameters;
        this.initConnectionFactory();
        log.info((Object)("RabbitMQ ConnectionFactory : " + name + " initialized"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.parameters.get("rabbitmq.message.content.type");
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RabbitMQException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new RabbitMQException(msg);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void initConnectionFactory() {
        this.connectionFactory = new ConnectionFactory();
        String hostName = this.parameters.get("rabbitmq.server.host.name");
        String portValue = this.parameters.get("rabbitmq.server.port");
        String serverRetryIntervalS = this.parameters.get("rabbitmq.server.retry.interval");
        String retryIntervalS = this.parameters.get("rabbitmq.connection.retry.interval");
        String retryCountS = this.parameters.get("rabbitmq.connection.retry.count");
        String heartbeat = this.parameters.get("rabbitmq.factory.heartbeat");
        String connectionTimeout = this.parameters.get("rabbitmq.factory.connection.timeout");
        String sslEnabledS = this.parameters.get("rabbitmq.connection.ssl.enabled");
        String userName = this.parameters.get("rabbitmq.server.user.name");
        String password = this.parameters.get("rabbitmq.server.password");
        String virtualHost = this.parameters.get("rabbitmq.server.virtual.host");
        if (!StringUtils.isEmpty((String)heartbeat)) {
            try {
                int heartbeatValue = Integer.parseInt(heartbeat);
                this.connectionFactory.setRequestedHeartbeat(heartbeatValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Number format error in reading heartbeat value. Proceeding with default");
            }
        }
        if (!StringUtils.isEmpty((String)connectionTimeout)) {
            try {
                int connectionTimeoutValue = Integer.parseInt(connectionTimeout);
                this.connectionFactory.setConnectionTimeout(connectionTimeoutValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Number format error in reading connection timeout value. Proceeding with default");
            }
        }
        if (!StringUtils.isEmpty((String)sslEnabledS)) {
            try {
                boolean sslEnabled = Boolean.parseBoolean(sslEnabledS);
                if (sslEnabled) {
                    String keyStoreLocation = this.parameters.get("rabbitmq.connection.ssl.keystore.location");
                    String keyStoreType = this.parameters.get("rabbitmq.connection.ssl.keystore.type");
                    String keyStorePassword = this.parameters.get("rabbitmq.connection.ssl.keystore.password");
                    String trustStoreLocation = this.parameters.get("rabbitmq.connection.ssl.truststore.location");
                    String trustStoreType = this.parameters.get("rabbitmq.connection.ssl.truststore.type");
                    String trustStorePassword = this.parameters.get("rabbitmq.connection.ssl.truststore.password");
                    String sslVersion = this.parameters.get("rabbitmq.connection.ssl.version");
                    if (StringUtils.isEmpty((String)keyStoreLocation) || StringUtils.isEmpty((String)keyStoreType) || StringUtils.isEmpty((String)keyStorePassword) || StringUtils.isEmpty((String)trustStoreLocation) || StringUtils.isEmpty((String)trustStoreType) || StringUtils.isEmpty((String)trustStorePassword)) {
                        log.warn((Object)"Truststore and keystore information is not provided correctly. Proceeding with default SSL configuration");
                        this.connectionFactory.useSslProtocol();
                    } else {
                        char[] keyPassphrase = keyStorePassword.toCharArray();
                        KeyStore ks = KeyStore.getInstance(keyStoreType);
                        ks.load(new FileInputStream(keyStoreLocation), keyPassphrase);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(ks, keyPassphrase);
                        char[] trustPassphrase = trustStorePassword.toCharArray();
                        KeyStore tks = KeyStore.getInstance(trustStoreType);
                        tks.load(new FileInputStream(trustStoreLocation), trustPassphrase);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        tmf.init(tks);
                        SSLContext c = SSLContext.getInstance(sslVersion);
                        c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                        this.connectionFactory.useSslProtocol(c);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Format error in SSL enabled value. Proceeding without enabling SSL", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)retryCountS)) {
            try {
                this.retryCount = Integer.parseInt(retryCountS);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Number format error in reading retry count value. Proceeding with default value (3)", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)hostName) && !StringUtils.isEmpty((String)portValue)) {
            String[] portValues;
            String[] hostNames = hostName.split(",");
            if (hostNames.length == (portValues = portValue.split(",")).length) {
                this.addresses = new Address[hostNames.length];
                for (int i = 0; i < hostNames.length; ++i) {
                    if (hostNames[i].isEmpty() || portValues[i].isEmpty()) continue;
                    try {
                        this.addresses[i] = new Address(hostNames[i].trim(), Integer.parseInt(portValues[i].trim()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.handleException("Number format error in port number", e);
                    }
                }
            }
        } else {
            this.handleException("Host name(s) and port(s) are not correctly defined");
        }
        if (!StringUtils.isEmpty((String)userName)) {
            this.connectionFactory.setUsername(userName);
        }
        if (!StringUtils.isEmpty((String)password)) {
            this.connectionFactory.setPassword(password);
        }
        if (!StringUtils.isEmpty((String)virtualHost)) {
            this.connectionFactory.setVirtualHost(virtualHost);
        }
        if (!StringUtils.isEmpty((String)retryIntervalS)) {
            try {
                this.retryInterval = Integer.parseInt(retryIntervalS);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Number format error in reading retry interval value. Proceeding with default value (30000ms)", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)serverRetryIntervalS)) {
            try {
                int serverRetryInterval = Integer.parseInt(serverRetryIntervalS);
                this.connectionFactory.setNetworkRecoveryInterval(serverRetryInterval);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Number format error in reading server retry interval value. Proceeding with default value", (Throwable)e);
            }
        }
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setTopologyRecoveryEnabled(false);
    }

    public Connection createConnection() throws IOException {
        Connection connection;
        block6: {
            connection = null;
            try {
                connection = RabbitMQUtils.createConnection(this.connectionFactory, this.addresses);
                log.info((Object)("[" + this.name + "] Successfully connected to RabbitMQ Broker"));
            }
            catch (IOException e) {
                log.error((Object)("[" + this.name + "] Error creating connection to RabbitMQ Broker. Reattempting to connect."), (Throwable)e);
                int retryC = 0;
                while (connection == null && (this.retryCount == -1 || retryC < this.retryCount)) {
                    ++retryC;
                    log.info((Object)("[" + this.name + "] Attempting to create connection to RabbitMQ Broker in " + this.retryInterval + " ms"));
                    try {
                        Thread.sleep(this.retryInterval);
                        connection = RabbitMQUtils.createConnection(this.connectionFactory, this.addresses);
                        log.info((Object)("[" + this.name + "] Successfully connected to RabbitMQ Broker"));
                    }
                    catch (InterruptedException e1) {
                        log.error((Object)("[" + this.name + "] Error while trying to reconnect to RabbitMQ Broker"), (Throwable)e1);
                    }
                    catch (IOException e2) {
                        log.error((Object)("[" + this.name + "] Error while trying to reconnect to RabbitMQ Broker"), (Throwable)e2);
                    }
                }
                if (connection != null) break block6;
                this.handleException("[" + this.name + "] Could not connect to RabbitMQ Broker. Error while creating connection", e);
            }
        }
        return connection;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

