/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.OneTimeTriggerAbstractCallback;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttClientManager;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionListener;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttListener;

public class MqttAsyncCallback
extends OneTimeTriggerAbstractCallback
implements MqttCallback {
    private static final Log log = LogFactory.getLog(MqttAsyncCallback.class);
    private String name;
    private MqttListener asycClient;
    private MqttInjectHandler injectHandler;
    private MqttConnectionFactory confac;
    private MqttAsyncClient mqttAsyncClient;
    private Properties mqttProperties;
    private MqttConnectOptions connectOptions;
    private MqttConnectionConsumer connectionConsumer;
    private MqttConnectionListener connectionListener;

    public MqttAsyncCallback(MqttAsyncClient mqttAsyncClient, MqttInjectHandler injectHandler, MqttConnectionFactory confac, MqttConnectOptions connectOptions, Properties mqttProperties) {
        this.injectHandler = injectHandler;
        this.mqttAsyncClient = mqttAsyncClient;
        this.confac = confac;
        this.connectOptions = connectOptions;
        this.mqttProperties = mqttProperties;
    }

    public void connectionLost(Throwable throwable) {
        log.info((Object)"Connection lost occurred to the remote server.");
        try {
            super.handleReconnection();
        }
        catch (InterruptedException ex) {
            log.error((Object)"Unable to suspend the callback reconnection", (Throwable)ex);
        }
    }

    @Override
    protected void reConnect() {
        if (this.mqttAsyncClient != null) {
            try {
                this.connectionListener = new MqttConnectionListener(this.connectionConsumer);
                IMqttToken token = this.mqttAsyncClient.connect(this.connectOptions);
                token.waitForCompletion();
                if (!this.mqttAsyncClient.isConnected()) {
                    this.connectionListener.onFailure();
                }
                if (this.mqttAsyncClient.isConnected()) {
                    int qosLevel = Integer.parseInt(this.mqttProperties.getProperty("mqtt.subscription.qos"));
                    if (this.confac.getTopic() != null) {
                        this.mqttAsyncClient.subscribe(this.confac.getTopic(), qosLevel);
                    }
                    log.info((Object)("MQTT inbound endpoint " + this.name + " re-connected to the broker"));
                }
            }
            catch (MqttException ex) {
                log.error((Object)"Error while trying to subscribe to the remote.", (Throwable)ex);
                this.connectionListener.onFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String topic, MqttMessage mqttMessage) throws MqttException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received Message: Topic:" + topic + "  Message: " + mqttMessage));
        }
        MqttClientManager clientManager = MqttClientManager.getInstance();
        String inboundIdentifier = clientManager.buildIdentifier(this.mqttAsyncClient.getClientId(), this.confac.getServerHost(), this.confac.getServerPort());
        if (super.isInboundRunnerMode()) {
            clientManager.registerInboundTenantLoadingFlag(inboundIdentifier);
            super.startInboundTenantLoading(inboundIdentifier);
            clientManager.unRegisterInboundTenantLoadingFlag(inboundIdentifier);
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                privilegedCarbonContext.setTenantDomain(this.tenantDomain, true);
                this.injectHandler.invoke(mqttMessage, this.name, topic);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            this.injectHandler.invoke(mqttMessage, this.name, topic);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void setMqttConnectionConsumer(MqttConnectionConsumer connectionConsumer) {
        this.connectionConsumer = connectionConsumer;
    }

    public MqttConnectionConsumer getMqttConnectionConsumer() {
        return this.connectionConsumer;
    }

    public MqttConnectOptions getMqttConnectionOptions() {
        return this.connectOptions;
    }

    public void updateInjectHandler(MqttInjectHandler injectHandler) {
        this.injectHandler = injectHandler;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.connectionListener != null) {
            this.connectionListener.shutdown();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

