/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.kafka;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.AbstractKafkaMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.InjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.KAFKAMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.SimpleKafkaMessageListener;

public class KAFKAPollingConsumer {
    private static final Log log = LogFactory.getLog((String)KAFKAPollingConsumer.class.getName());
    private InjectHandler injectHandler;
    private Properties kafkaProperties;
    private int threadCount;
    private List<String> topics;
    protected AbstractKafkaMessageListener messageListener;
    private long scanInterval;
    private Long lastRanTime;
    private String name;

    public KAFKAPollingConsumer(Properties kafkaProperties, long interval, String name) throws Exception {
        this.kafkaProperties = kafkaProperties;
        this.scanInterval = interval;
        this.name = name;
        try {
            this.threadCount = kafkaProperties.getProperty("thread.count") == null || kafkaProperties.getProperty("thread.count").equals("") || Integer.parseInt(kafkaProperties.getProperty("thread.count")) <= 0 ? 1 : Integer.parseInt(kafkaProperties.getProperty("thread.count"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Invalid numeric value for thread count." + nfe.getMessage()), (Throwable)nfe);
            throw new SynapseException("Invalid numeric value for thread count.", (Throwable)nfe);
        }
        if (kafkaProperties.getProperty("topics") != null) {
            this.topics = Arrays.asList(kafkaProperties.getProperty("topics").split(","));
        }
    }

    public void startsMessageListener() throws Exception {
        log.debug((Object)"Create the Kafka message listener");
        if (this.messageListener == null) {
            try {
                if (this.kafkaProperties.getProperty("consumer.type") == null || this.kafkaProperties.getProperty("consumer.type").isEmpty() || this.kafkaProperties.getProperty("consumer.type").equalsIgnoreCase(AbstractKafkaMessageListener.CONSUMER_TYPE.HIGHLEVEL.getName())) {
                    this.messageListener = new KAFKAMessageListener(this.threadCount, this.topics, this.kafkaProperties, this.injectHandler);
                } else if (this.kafkaProperties.getProperty("consumer.type").equalsIgnoreCase(AbstractKafkaMessageListener.CONSUMER_TYPE.SIMPLE.getName())) {
                    this.messageListener = new SimpleKafkaMessageListener(this.kafkaProperties, this.injectHandler);
                }
            }
            catch (Exception e) {
                log.error((Object)("The consumer type should be high level or simple." + e.getMessage()), (Throwable)e);
                throw new SynapseException("The consumer type should be high level or simple", (Throwable)e);
            }
        }
    }

    public void execute() {
        try {
            log.debug((Object)"Executing : KAFKA Inbound EP : ");
            long currentTime = new Date().getTime();
            if (this.lastRanTime == null || this.lastRanTime + this.scanInterval <= currentTime) {
                this.lastRanTime = currentTime;
                this.poll();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Skip cycle since concurrent rate is higher than the scan interval : KAFKA Inbound EP ");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End : KAFKA Inbound EP : ");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while retrieving or injecting KAFKA message." + e.getMessage()), (Throwable)e);
        }
    }

    public void registerHandler(InjectHandler processingHandler) {
        this.injectHandler = processingHandler;
    }

    public Object poll() {
        block8: {
            log.debug((Object)"Run to poll messages and inject to the sequence");
            try {
                if (!this.messageListener.createKafkaConsumerConnector()) {
                    return null;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                return null;
            }
            try {
                if (this.messageListener.hasMultipleTopicsToConsume()) {
                    if (this.injectHandler != null) {
                        this.messageListener.consumeMultipleTopics(this.name);
                        break block8;
                    }
                    return null;
                }
                if (this.injectHandler != null && this.messageListener.hasNext()) {
                    this.messageListener.injectMessageToESB(this.name);
                    break block8;
                }
                return null;
            }
            catch (Exception e) {
                log.error((Object)("Error while receiving KAFKA message." + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public Properties getInboundProperties() {
        return this.kafkaProperties;
    }
}

