/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.apache.synapse.transport.passthru.api.PassThroughInboundEndpointHandler;
import org.wso2.carbon.inbound.endpoint.protocol.http.management.HTTPEndpointManager;

public class InboundHttpListener
implements InboundRequestProcessor {
    private static final Log log = LogFactory.getLog(InboundHttpListener.class);
    private String name;
    private int port;
    private InboundProcessorParams processorParams;

    public InboundHttpListener(InboundProcessorParams params) {
        this.processorParams = params;
        String portParam = params.getProperties().getProperty("inbound.http.port");
        try {
            this.port = Integer.parseInt(portParam);
        }
        catch (NumberFormatException e) {
            this.handleException("Please provide port number as integer  instead of  port  " + portParam, e);
        }
        this.name = params.getName();
    }

    public void init() {
        if (this.isPortUsedByAnotherApplication(this.port)) {
            log.warn((Object)("Port " + this.port + " used by inbound endpoint " + this.name + " is already used by another application hence undeploying inbound endpoint"));
            throw new SynapseException("Port " + this.port + " used by inbound endpoint " + this.name + " is already used by another application.");
        }
        HTTPEndpointManager.getInstance().startEndpoint(this.port, this.name, this.processorParams);
    }

    public void destroy() {
        HTTPEndpointManager.getInstance().closeEndpoint(this.port);
    }

    protected void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    protected boolean isPortUsedByAnotherApplication(int port) {
        if (PassThroughInboundEndpointHandler.isEndpointRunning((int)port)) {
            return false;
        }
        try {
            ServerSocket srv = new ServerSocket(port);
            srv.close();
            srv = null;
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    protected void destoryInbound() {
        if (this.processorParams.getSynapseEnvironment() != null) {
            Collection inboundEndpoints = this.processorParams.getSynapseEnvironment().getSynapseConfiguration().getInboundEndpoints();
            for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
                if (!inboundEndpoint.getName().equals(this.name)) continue;
                this.processorParams.getSynapseEnvironment().getSynapseConfiguration().removeInboundEndpoint(this.name);
                break;
            }
        }
    }
}

