/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.HL7Processor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MultiIOHandler;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7Configuration;

public class InboundHL7IOReactor {
    private static final Log log = LogFactory.getLog(InboundHL7IOReactor.class);
    private static ListeningIOReactor reactor;
    private static ConcurrentHashMap<Integer, ListenerEndpoint> endpointMap;
    private static ConcurrentHashMap<Integer, HL7Processor> processorMap;
    private static MultiIOHandler multiIOHandler;
    private static volatile boolean isStarted;

    public static void start() throws IOException {
        if (reactor != null && reactor.getStatus().equals((Object)IOReactorStatus.ACTIVE)) {
            return;
        }
        IOReactorConfig config = InboundHL7IOReactor.getDefaultReactorConfig();
        reactor = new DefaultListeningIOReactor(config);
        Thread reactorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    isStarted = true;
                    multiIOHandler = new MultiIOHandler(processorMap);
                    log.info((Object)"MLLP Transport IO Reactor Started");
                    reactor.execute((IOEventDispatch)multiIOHandler);
                }
                catch (IOException e) {
                    isStarted = false;
                    log.error((Object)"Error while starting the MLLP Transport IO Reactor.", (Throwable)e);
                }
            }
        });
        reactorThread.start();
    }

    public static void stop() {
        try {
            reactor.shutdown();
            endpointMap.clear();
            isStarted = false;
        }
        catch (IOException e) {
            log.error((Object)"Error while shutting down MLLP Transport IO Reactor. ", (Throwable)e);
        }
    }

    public static void pause() {
        try {
            reactor.pause();
        }
        catch (IOException e) {
            log.error((Object)"Error while pausing MLLP Transport IO Reactor. ", (Throwable)e);
        }
    }

    public static boolean isStarted() {
        return isStarted;
    }

    public static boolean bind(int port, HL7Processor processor) {
        InboundHL7IOReactor.checkReactor();
        if (!InboundHL7IOReactor.isPortAvailable(port)) {
            log.error((Object)("A service is already listening on port " + port + ". Please select a different port for this endpoint."));
            return false;
        }
        ListenerEndpoint ep = reactor.listen(InboundHL7IOReactor.getSocketAddress(port));
        try {
            ep.waitFor();
            endpointMap.put(port, ep);
            processorMap.put(port, processor);
            return true;
        }
        catch (InterruptedException e) {
            log.error((Object)("Error while starting a new MLLP Listener on port " + port + ". "), (Throwable)e);
            return false;
        }
    }

    private static boolean isPortAvailable(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean unbind(int port) {
        ListenerEndpoint ep = endpointMap.get(port);
        endpointMap.remove(port);
        processorMap.remove(port);
        multiIOHandler.disconnectSessions(port);
        if (ep == null) {
            return false;
        }
        ep.close();
        return true;
    }

    protected static void checkReactor() {
        if (reactor == null) {
            try {
                InboundHL7IOReactor.start();
            }
            catch (IOException e) {
                log.error((Object)"Reactor failed to start.");
            }
        }
    }

    public static boolean isEndpointRunning(int port) {
        return endpointMap.get(port) != null;
    }

    private static SocketAddress getSocketAddress(int port) {
        InetSocketAddress isa = new InetSocketAddress(port);
        return isa;
    }

    private static IOReactorConfig getDefaultReactorConfig() {
        IOReactorConfig.Builder builder = IOReactorConfig.custom();
        return builder.setSelectInterval((long)HL7Configuration.getInstance().getIntProperty("select_interval", 1000).intValue()).setShutdownGracePeriod((long)HL7Configuration.getInstance().getIntProperty("shutdown_grace_period", 500).intValue()).setIoThreadCount(HL7Configuration.getInstance().getIntProperty("io_thread_count", Runtime.getRuntime().availableProcessors()).intValue()).setSoTimeout(HL7Configuration.getInstance().getIntProperty("so_timeout", 0).intValue()).setSoKeepAlive(HL7Configuration.getInstance().getBooleanProperty("so_keep_alive", true).booleanValue()).setTcpNoDelay(HL7Configuration.getInstance().getBooleanProperty("tcp_no_delay", true).booleanValue()).setConnectTimeout(HL7Configuration.getInstance().getIntProperty("connect_timeout", 0).intValue()).setRcvBufSize(HL7Configuration.getInstance().getIntProperty("so_rcvbuf", 0).intValue()).setSndBufSize(HL7Configuration.getInstance().getIntProperty("so_sndbuf", 0).intValue()).setInterestOpQueued(false).setSoReuseAddress(true).setSoLinger(-1).build();
    }

    static {
        endpointMap = new ConcurrentHashMap();
        processorMap = new ConcurrentHashMap();
        isStarted = false;
    }
}

