/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.file;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundTaskProcessor;
import org.apache.synapse.task.TaskStartupObserver;
import org.wso2.carbon.inbound.endpoint.common.InboundRequestProcessorImpl;
import org.wso2.carbon.inbound.endpoint.protocol.file.FileInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.file.FilePollingConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.file.FileTask;

public class VFSProcessor
extends InboundRequestProcessorImpl
implements TaskStartupObserver,
InboundTaskProcessor {
    private static final String ENDPOINT_POSTFIX = "FILE--SYNAPSE_INBOUND_ENDPOINT";
    private static final Log log = LogFactory.getLog(VFSProcessor.class);
    private FilePollingConsumer fileScanner;
    private Properties vfsProperties;
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;

    public VFSProcessor(InboundProcessorParams params) {
        this.name = params.getName();
        this.vfsProperties = params.getProperties();
        try {
            this.interval = Long.parseLong(this.vfsProperties.getProperty("interval"));
        }
        catch (NumberFormatException nfe) {
            throw new SynapseException("Invalid numeric value for interval.", (Throwable)nfe);
        }
        catch (Exception e) {
            throw new SynapseException("Invalid value for interval.", (Throwable)e);
        }
        this.sequential = true;
        if (this.vfsProperties.getProperty("sequential") != null) {
            this.sequential = Boolean.parseBoolean(this.vfsProperties.getProperty("sequential"));
        }
        this.coordination = true;
        if (this.vfsProperties.getProperty("coordination") != null) {
            this.coordination = Boolean.parseBoolean(this.vfsProperties.getProperty("coordination"));
        }
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
    }

    public void init() {
        log.info((Object)("Inbound file listener " + this.name + " starting ..."));
        this.fileScanner = new FilePollingConsumer(this.vfsProperties, this.name, this.synapseEnvironment, this.interval);
        this.fileScanner.registerHandler(new FileInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment, this.vfsProperties));
        this.start();
    }

    public void start() {
        FileTask task = new FileTask(this.fileScanner, this.interval);
        this.start(task, ENDPOINT_POSTFIX);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void update() {
    }

    public void destroy(boolean removeTask) {
        if (removeTask) {
            this.destroy();
        }
    }
}

