/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.file;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.vfs.VFSParamDTO;
import org.apache.synapse.commons.vfs.VFSUtils;
import org.apache.synapse.core.SynapseEnvironment;
import org.wso2.carbon.inbound.endpoint.protocol.file.FileInjectHandler;
import org.wso2.carbon.mediation.clustering.ClusteringServiceUtil;

public class FilePollingConsumer {
    private static final Log log = LogFactory.getLog(FilePollingConsumer.class);
    private Properties vfsProperties;
    private boolean fileLock = true;
    private DefaultFileSystemManager fsManager = null;
    private String name;
    private SynapseEnvironment synapseEnvironment;
    private long scanInterval;
    private Long lastRanTime;
    private int lastCycle;
    private FileInjectHandler injectHandler;
    private Long waitTimeBeforeRead;
    private String fileURI;
    private FileObject fileObject;
    private Integer iFileProcessingInterval = null;
    private Integer iFileProcessingCount = null;
    private int maxRetryCount;
    private long reconnectionTimeout;
    private String strFilePattern;
    private boolean autoLockRelease;
    private Boolean autoLockReleaseSameNode;
    private Long autoLockReleaseInterval;
    private boolean distributedLock;
    private Long distributedLockTimeout;
    private FileSystemOptions fso;

    public FilePollingConsumer(Properties vfsProperties, String name, SynapseEnvironment synapseEnvironment, long scanInterval) {
        this.vfsProperties = vfsProperties;
        this.name = name;
        this.synapseEnvironment = synapseEnvironment;
        this.scanInterval = scanInterval;
        this.lastRanTime = null;
        this.setupParams();
        try {
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(this.getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        try {
            this.fso = VFSUtils.attachFileSystemOptions((Map)VFSUtils.parseSchemeFileOptions((String)this.fileURI, (Properties)vfsProperties), (FileSystemManager)this.fsManager);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to set the sftp Options", (Throwable)e);
            this.fso = null;
        }
    }

    public void registerHandler(FileInjectHandler injectHandler) {
        this.injectHandler = injectHandler;
    }

    public void execute() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start : File Inbound EP : " + this.name));
            }
            long currentTime = new Date().getTime();
            if (this.lastRanTime == null || this.lastRanTime + this.scanInterval <= currentTime) {
                this.lastRanTime = currentTime;
                this.poll();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Skip cycle since cuncurrent rate is higher than the scan interval : VFS Inbound EP : " + this.name));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End : File Inbound EP : " + this.name));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while reading file. " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject poll() {
        block40: {
            if (this.fileURI == null || this.fileURI.trim().equals("")) {
                log.error((Object)("Invalid file url. Check the inbound endpoint configuration. Endpoint Name : " + this.name + ", File URL : " + VFSUtils.maskURLPassword((String)this.fileURI)));
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start : Scanning directory or file : " + VFSUtils.maskURLPassword((String)this.fileURI)));
            }
            if (!this.initFileCheck()) {
                return null;
            }
            try {
                this.lastCycle = 0;
                if (this.fileObject.exists() && this.fileObject.isReadable()) {
                    FileObject[] children = null;
                    try {
                        children = this.fileObject.getChildren();
                    }
                    catch (FileNotFolderException ignored) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No Folder found. Only file found on : " + VFSUtils.maskURLPassword((String)this.fileURI)));
                        }
                    }
                    catch (FileSystemException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    if (children == null || children.length == 0) {
                        boolean isFailedRecord = VFSUtils.isFailRecord((FileSystemManager)this.fsManager, (FileObject)this.fileObject, (FileSystemOptions)this.fso);
                        if (!isFailedRecord) {
                            this.fileHandler();
                            if (this.injectHandler == null) {
                                FileObject fileObject = this.fileObject;
                                return fileObject;
                            }
                            break block40;
                        }
                        try {
                            this.lastCycle = 2;
                            this.moveOrDeleteAfterProcessing(this.fileObject);
                        }
                        catch (SynapseException synapseException) {
                            log.error((Object)("File object '" + VFSUtils.maskURLPassword((String)this.fileObject.getURL().toString()) + "' cloud not be moved after first attempt"), (Throwable)synapseException);
                        }
                        if (this.fileLock) {
                            VFSUtils.releaseLock((FileSystemManager)this.fsManager, (FileObject)this.fileObject, (FileSystemOptions)this.fso);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("File '" + VFSUtils.maskURLPassword((String)this.fileObject.getURL().toString()) + "' has been marked as a failed record, it will not process"));
                        }
                        break block40;
                    }
                    FileObject fileObject = this.directoryHandler(children);
                    if (fileObject != null) {
                        FileObject synapseException = fileObject;
                        return synapseException;
                    }
                    break block40;
                }
                log.warn((Object)("Unable to access or read file or directory : " + VFSUtils.maskURLPassword((String)this.fileURI) + ". Reason: " + (this.fileObject.exists() ? (this.fileObject.isReadable() ? "Unknown reason" : "The file can not be read!") : "The file does not exists!")));
                FileObject children = null;
                return children;
            }
            catch (FileSystemException e) {
                log.error((Object)("Error checking for existence and readability : " + VFSUtils.maskURLPassword((String)this.fileURI)), (Throwable)e);
                FileObject fileObject = null;
                return fileObject;
            }
            catch (Exception e) {
                log.error((Object)("Error while processing the file/folder in URL : " + VFSUtils.maskURLPassword((String)this.fileURI)), (Throwable)e);
                FileObject fileObject = null;
                return fileObject;
            }
            finally {
                try {
                    this.fileObject.close();
                }
                catch (Exception e) {
                    log.error((Object)("Unable to close the file system. " + e.getMessage()));
                    log.error((Object)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End : Scanning directory or file : " + VFSUtils.maskURLPassword((String)this.fileURI)));
        }
        return null;
    }

    private void fileHandler() throws FileSystemException {
        if (this.fileObject.getType() == FileType.FILE) {
            if (!this.fileLock || this.fileLock && this.acquireLock((FileSystemManager)this.fsManager, this.fileObject)) {
                boolean runPostProcess = true;
                try {
                    if (this.processFile(this.fileObject) == null) {
                        runPostProcess = false;
                    }
                    this.lastCycle = 1;
                }
                catch (SynapseException e) {
                    this.lastCycle = 2;
                    log.error((Object)("Error processing File URI : " + VFSUtils.maskURLPassword((String)this.fileObject.getName().toString())), (Throwable)e);
                }
                if (runPostProcess) {
                    try {
                        this.moveOrDeleteAfterProcessing(this.fileObject);
                    }
                    catch (SynapseException synapseException) {
                        this.lastCycle = 3;
                        log.error((Object)("File object '" + VFSUtils.maskURLPassword((String)this.fileObject.getURL().toString()) + "' cloud not be moved"), (Throwable)synapseException);
                        VFSUtils.markFailRecord((FileSystemManager)this.fsManager, (FileObject)this.fileObject);
                    }
                }
                if (this.fileLock) {
                    VFSUtils.releaseLock((FileSystemManager)this.fsManager, (FileObject)this.fileObject, (FileSystemOptions)this.fso);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removed the lock file '" + VFSUtils.maskURLPassword((String)this.fileObject.toString()) + ".lock' of the file '" + VFSUtils.maskURLPassword((String)this.fileObject.toString())));
                    }
                }
            } else {
                log.error((Object)("Couldn't get the lock for processing the file : " + VFSUtils.maskURLPassword((String)this.fileObject.getName().toString())));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot find the file or failed file record. File : " + VFSUtils.maskURLPassword((String)this.fileURI)));
        }
    }

    private void setupParams() {
        this.fileURI = this.vfsProperties.getProperty("transport.vfs.FileURI");
        String strFileLock = this.vfsProperties.getProperty("transport.vfs.Locking");
        if (strFileLock != null && strFileLock.toLowerCase().equals("disable")) {
            this.fileLock = false;
        }
        this.strFilePattern = this.vfsProperties.getProperty("transport.vfs.FileNamePattern");
        if (this.vfsProperties.getProperty("transport.vfs.FileProcessInterval") != null) {
            try {
                this.iFileProcessingInterval = Integer.valueOf(this.vfsProperties.getProperty("transport.vfs.FileProcessInterval"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid param value for transport.vfs.FileProcessInterval : " + this.vfsProperties.getProperty("transport.vfs.FileProcessInterval") + ". Expected numeric value."));
            }
        }
        if (this.vfsProperties.getProperty("transport.vfs.FileProcessCount") != null) {
            try {
                this.iFileProcessingCount = Integer.valueOf(this.vfsProperties.getProperty("transport.vfs.FileProcessCount"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid param value for transport.vfs.FileProcessCount : " + this.vfsProperties.getProperty("transport.vfs.FileProcessCount") + ". Expected numeric value."));
            }
        }
        this.maxRetryCount = 0;
        if (this.vfsProperties.getProperty("transport.vfs.MaxRetryCount") != null) {
            try {
                this.maxRetryCount = Integer.valueOf(this.vfsProperties.getProperty("transport.vfs.MaxRetryCount"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Invalid values for Max Retry Count");
                this.maxRetryCount = 0;
            }
        }
        this.reconnectionTimeout = 1L;
        if (this.vfsProperties.getProperty("transport.vfs.ReconnectTimeout") != null) {
            try {
                this.reconnectionTimeout = Long.valueOf(this.vfsProperties.getProperty("transport.vfs.ReconnectTimeout"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Invalid values for Reconnection Timeout");
                this.reconnectionTimeout = 1L;
            }
        }
        String strAutoLock = this.vfsProperties.getProperty("transport.vfs.AutoLockRelease");
        this.autoLockRelease = false;
        this.autoLockReleaseSameNode = true;
        this.autoLockReleaseInterval = null;
        if (strAutoLock != null) {
            try {
                this.autoLockRelease = Boolean.parseBoolean(strAutoLock);
            }
            catch (Exception e) {
                this.autoLockRelease = false;
                log.warn((Object)("VFS Auto lock removal not set properly. Current value is : " + strAutoLock), (Throwable)e);
            }
            if (this.autoLockRelease) {
                String strAutoLockReleaseSameNode;
                String strAutoLockInterval = this.vfsProperties.getProperty("transport.vfs.AutoLockReleaseInterval");
                if (strAutoLockInterval != null) {
                    try {
                        this.autoLockReleaseInterval = Long.parseLong(strAutoLockInterval);
                    }
                    catch (Exception e) {
                        this.autoLockReleaseInterval = null;
                        log.warn((Object)("VFS Auto lock removal property not set properly. Current value is : " + strAutoLockInterval), (Throwable)e);
                    }
                }
                if ((strAutoLockReleaseSameNode = this.vfsProperties.getProperty("transport.vfs.LockReleaseSameNode")) != null) {
                    try {
                        this.autoLockReleaseSameNode = Boolean.parseBoolean(strAutoLockReleaseSameNode);
                    }
                    catch (Exception e) {
                        this.autoLockReleaseSameNode = true;
                        log.warn((Object)("VFS Auto lock removal property not set properly. Current value is : " + this.autoLockReleaseSameNode), (Throwable)e);
                    }
                }
            }
        }
        this.distributedLock = false;
        this.distributedLockTimeout = null;
        String strDistributedLock = this.vfsProperties.getProperty("transport.vfs.DistributedLock");
        if (strDistributedLock != null) {
            String strDistributedLockTimeout;
            try {
                this.distributedLock = Boolean.parseBoolean(strDistributedLock);
            }
            catch (Exception e) {
                this.autoLockRelease = false;
                log.warn((Object)("VFS Distributed lock not set properly. Current value is : " + strDistributedLock), (Throwable)e);
            }
            if (this.distributedLock && (strDistributedLockTimeout = this.vfsProperties.getProperty("transport.vfs.DistributedTimeout")) != null) {
                try {
                    this.distributedLockTimeout = Long.parseLong(strDistributedLockTimeout);
                }
                catch (Exception e) {
                    this.distributedLockTimeout = null;
                    log.warn((Object)("VFS Distributed lock timeout property not set properly. Current value is : " + strDistributedLockTimeout), (Throwable)e);
                }
            }
        }
        this.waitTimeBeforeRead = null;
        String strWaitTimeBeforeRead = this.vfsProperties.getProperty("transport.vfs.waitTimeBeforeRead");
        if (strWaitTimeBeforeRead != null) {
            try {
                this.waitTimeBeforeRead = Long.parseLong(strWaitTimeBeforeRead);
            }
            catch (NumberFormatException e) {
                this.waitTimeBeforeRead = null;
                log.warn((Object)("VFS Wait time before read is not set properly. Current value is: " + strWaitTimeBeforeRead), (Throwable)e);
            }
        }
    }

    private FileObject directoryHandler(FileObject[] children) throws FileSystemException {
        String strSortParam;
        this.lastCycle = 0;
        int failCount = 0;
        int successCount = 0;
        int processCount = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("File name pattern : " + this.vfsProperties.getProperty("transport.vfs.FileNamePattern")));
        }
        if ((strSortParam = this.vfsProperties.getProperty("transport.vfs.FileSortAttribute")) != null && !"NONE".equals(strSortParam)) {
            log.debug((Object)"Start Sorting the files.");
            String strSortOrder = this.vfsProperties.getProperty("transport.vfs.FileSortAscending");
            boolean bSortOrderAsscending = true;
            if (strSortOrder != null && strSortOrder.toLowerCase().equals("false")) {
                bSortOrderAsscending = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sorting the files by : " + strSortOrder + ". (" + bSortOrderAsscending + ")"));
            }
            if (strSortParam.equals("Name") && bSortOrderAsscending) {
                Arrays.sort(children, new FileNameAscComparator());
            } else if (strSortParam.equals("Name") && !bSortOrderAsscending) {
                Arrays.sort(children, new FileNameDesComparator());
            } else if (strSortParam.equals("Size") && bSortOrderAsscending) {
                Arrays.sort(children, new FileSizeAscComparator());
            } else if (strSortParam.equals("Size") && !bSortOrderAsscending) {
                Arrays.sort(children, new FileSizeDesComparator());
            } else if (strSortParam.equals("Lastmodifiedtimestamp") && bSortOrderAsscending) {
                Arrays.sort(children, new FileLastmodifiedtimestampAscComparator());
            } else if (strSortParam.equals("Lastmodifiedtimestamp") && !bSortOrderAsscending) {
                Arrays.sort(children, new FileLastmodifiedtimestampDesComparator());
            }
            log.debug((Object)"End Sorting the files.");
        }
        for (FileObject child : children) {
            if (child.getName().getBaseName().endsWith(".lock") || child.getName().getBaseName().endsWith(".fail")) continue;
            boolean isFailedRecord = VFSUtils.isFailRecord((FileSystemManager)this.fsManager, (FileObject)child, (FileSystemOptions)this.fso);
            boolean isReadyToRead = VFSUtils.isReadyToRead((FileObject)child, (Long)this.waitTimeBeforeRead);
            if ((this.strFilePattern == null || child.getName().getBaseName().matches(this.strFilePattern)) && !isFailedRecord && isReadyToRead) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matching file : " + child.getName().getBaseName()));
                }
                if (!this.fileLock || this.fileLock && this.acquireLock((FileSystemManager)this.fsManager, child)) {
                    boolean runPostProcess = true;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Processing file :" + VFSUtils.maskURLPassword((String)child.toString())));
                        }
                        ++processCount;
                        if (this.processFile(child) == null) {
                            runPostProcess = false;
                        } else {
                            ++successCount;
                        }
                        this.lastCycle = 1;
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof FileNotFoundException) {
                            log.warn((Object)("Error processing File URI : " + VFSUtils.maskURLPassword((String)child.getName().toString()) + ". This can be due to file moved from another process."));
                            runPostProcess = false;
                        }
                        log.error((Object)("Error processing File URI : " + VFSUtils.maskURLPassword((String)child.getName().toString())), (Throwable)e);
                        ++failCount;
                        this.lastCycle = 2;
                    }
                    boolean skipUnlock = false;
                    if (runPostProcess) {
                        try {
                            this.moveOrDeleteAfterProcessing(child);
                        }
                        catch (SynapseException synapseException) {
                            log.error((Object)("File object '" + VFSUtils.maskURLPassword((String)child.getURL().toString()) + "'cloud not be moved, will remain in \"locked\" state"), (Throwable)synapseException);
                            skipUnlock = true;
                            ++failCount;
                            this.lastCycle = 3;
                            VFSUtils.markFailRecord((FileSystemManager)this.fsManager, (FileObject)child);
                        }
                    }
                    if (this.fileLock && !skipUnlock) {
                        VFSUtils.releaseLock((FileSystemManager)this.fsManager, (FileObject)child, (FileSystemOptions)this.fso);
                    }
                    if (this.injectHandler == null) {
                        return child;
                    }
                }
            } else if (log.isDebugEnabled() && this.strFilePattern != null && !child.getName().getBaseName().matches(this.strFilePattern) && !isFailedRecord) {
                log.debug((Object)("Non-Matching file : " + child.getName().getBaseName()));
            } else if (isFailedRecord) {
                try {
                    this.lastCycle = 1;
                    this.moveOrDeleteAfterProcessing(child);
                }
                catch (SynapseException synapseException) {
                    log.error((Object)("File object '" + VFSUtils.maskURLPassword((String)child.getURL().toString()) + "'cloud not be moved, will remain in \"fail\" state"), (Throwable)synapseException);
                }
                if (this.fileLock) {
                    VFSUtils.releaseLock((FileSystemManager)this.fsManager, (FileObject)child, (FileSystemOptions)this.fso);
                    VFSUtils.releaseLock((FileSystemManager)this.fsManager, (FileObject)this.fileObject, (FileSystemOptions)this.fso);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File '" + VFSUtils.maskURLPassword((String)this.fileObject.getURL().toString()) + "' has been marked as a failed record, it will not process"));
                }
            } else if (!isReadyToRead) {
                log.debug((Object)("File cannot be read as it has to wait for some time: " + child.getName().getBaseName()));
            }
            try {
                child.close();
            }
            catch (Exception synapseException) {
                // empty catch block
            }
            if (this.iFileProcessingInterval != null && this.iFileProcessingInterval > 0) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Put the VFS processor to sleep for : " + this.iFileProcessingInterval));
                    }
                    Thread.sleep(this.iFileProcessingInterval.intValue());
                }
                catch (InterruptedException ie) {
                    log.error((Object)("Unable to set the interval between file processors." + ie));
                }
                continue;
            }
            if (this.iFileProcessingCount != null && this.iFileProcessingCount <= processCount) break;
        }
        this.lastCycle = failCount == 0 && successCount > 0 ? 1 : (successCount == 0 && failCount > 0 ? 4 : 5);
        return null;
    }

    private boolean initFileCheck() {
        boolean wasError = true;
        int retryCount = 0;
        this.fileObject = null;
        while (wasError) {
            try {
                ++retryCount;
                this.fileObject = this.fsManager.resolveFile(this.fileURI, this.fso);
                if (this.fileObject == null) {
                    log.error((Object)"fileObject is null");
                    throw new FileSystemException("fileObject is null");
                }
                wasError = false;
            }
            catch (FileSystemException e) {
                if (retryCount >= this.maxRetryCount) {
                    log.error((Object)("Repeatedly failed to resolve the file URI: " + VFSUtils.maskURLPassword((String)this.fileURI)), (Throwable)e);
                    return false;
                }
                log.warn((Object)("Failed to resolve the file URI: " + VFSUtils.maskURLPassword((String)this.fileURI) + ", in attempt " + retryCount + ", " + e.getMessage() + " Retrying in " + this.reconnectionTimeout + " milliseconds."));
            }
            if (!wasError) continue;
            try {
                Thread.sleep(this.reconnectionTimeout);
            }
            catch (InterruptedException e2) {
                log.error((Object)"Thread was interrupted while waiting to reconnect.", (Throwable)e2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLock(FileSystemManager fsManager, FileObject fileObject) {
        String strContext = fileObject.getName().getURI();
        boolean rtnValue = false;
        try {
            FileObject sourceFile;
            String parentURI;
            if (this.distributedLock) {
                if (this.distributedLockTimeout != null) {
                    if (!ClusteringServiceUtil.setLock((String)strContext, (long)this.distributedLockTimeout)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (!ClusteringServiceUtil.setLock((String)strContext)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((parentURI = fileObject.getParent().getName().getURI()).contains("?")) {
                String suffix = parentURI.substring(parentURI.indexOf("?"));
                strContext = strContext + suffix;
            }
            if (!(sourceFile = fsManager.resolveFile(strContext, this.fso)).exists()) {
                boolean bl = false;
                return bl;
            }
            VFSParamDTO vfsParamDTO = new VFSParamDTO();
            vfsParamDTO.setAutoLockRelease(this.autoLockRelease);
            vfsParamDTO.setAutoLockReleaseSameNode(this.autoLockReleaseSameNode.booleanValue());
            vfsParamDTO.setAutoLockReleaseInterval(this.autoLockReleaseInterval);
            rtnValue = VFSUtils.acquireLock((FileSystemManager)fsManager, (FileObject)fileObject, (VFSParamDTO)vfsParamDTO, (FileSystemOptions)this.fso, (boolean)true);
        }
        finally {
            if (this.distributedLock) {
                ClusteringServiceUtil.releaseLock((String)strContext);
            }
        }
        return rtnValue;
    }

    private FileObject processFile(FileObject file) throws SynapseException {
        block5: {
            try {
                FileContent content = file.getContent();
                String fileName = file.getName().getBaseName();
                String filePath = file.getName().getPath();
                String fileURI = file.getName().getURI();
                if (this.injectHandler == null) break block5;
                HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
                transportHeaders.put("FILE_PATH", filePath);
                transportHeaders.put("FILE_NAME", fileName);
                transportHeaders.put("FILE_URI", fileURI);
                try {
                    transportHeaders.put("FILE_LENGTH", content.getSize());
                    transportHeaders.put("LAST_MODIFIED", content.getLastModifiedTime());
                }
                catch (FileSystemException e) {
                    log.warn((Object)"Unable to set file length or last modified date header.", (Throwable)e);
                }
                this.injectHandler.setTransportHeaders(transportHeaders);
                if (!this.injectHandler.invoke(file, this.name)) {
                    return null;
                }
            }
            catch (FileSystemException e) {
                log.error((Object)("Error reading file content or attributes : " + VFSUtils.maskURLPassword((String)file.toString())), (Throwable)e);
            }
        }
        return file;
    }

    private void moveOrDeleteAfterProcessing(FileObject fileObject) throws SynapseException {
        block21: {
            String moveToDirectoryURI = null;
            try {
                switch (this.lastCycle) {
                    case 1: {
                        if (!"MOVE".equals(this.vfsProperties.getProperty("transport.vfs.ActionAfterProcess"))) break;
                        moveToDirectoryURI = this.vfsProperties.getProperty("transport.vfs.MoveAfterProcess");
                        String strSubfoldertimestamp = this.vfsProperties.getProperty("transport.vfs.SubFolderTimestampFormat");
                        if (strSubfoldertimestamp == null) break;
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat(strSubfoldertimestamp);
                            String strDateformat = sdf.format(new Date());
                            int iIndex = moveToDirectoryURI.indexOf("?");
                            if (iIndex > -1) {
                                moveToDirectoryURI = moveToDirectoryURI.substring(0, iIndex) + strDateformat + moveToDirectoryURI.substring(iIndex, moveToDirectoryURI.length());
                                break;
                            }
                            moveToDirectoryURI = moveToDirectoryURI + strDateformat;
                        }
                        catch (Exception e) {
                            log.warn((Object)"Error generating subfolder name with date", (Throwable)e);
                        }
                        break;
                    }
                    case 2: {
                        if (!"MOVE".equals(this.vfsProperties.getProperty("transport.vfs.ActionAfterFailure"))) break;
                        moveToDirectoryURI = this.vfsProperties.getProperty("transport.vfs.MoveAfterFailure");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (moveToDirectoryURI != null) {
                    FileSystemOptions destinationFSO = null;
                    try {
                        destinationFSO = VFSUtils.attachFileSystemOptions((Map)VFSUtils.parseSchemeFileOptions((String)moveToDirectoryURI, (Properties)this.vfsProperties), (FileSystemManager)this.fsManager);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Unable to set the options for processed file location ", (Throwable)e);
                    }
                    FileObject moveToDirectory = this.fsManager.resolveFile(moveToDirectoryURI, destinationFSO);
                    String prefix = this.vfsProperties.getProperty("transport.vfs.MoveTimestampFormat") != null ? new SimpleDateFormat(this.vfsProperties.getProperty("transport.vfs.MoveTimestampFormat")).format(new Date()) : "";
                    String strForceCreateFolder = this.vfsProperties.getProperty("transport.vfs.CreateFolder");
                    if (strForceCreateFolder != null && strForceCreateFolder.toLowerCase().equals("true") && !moveToDirectory.exists()) {
                        moveToDirectory.createFolder();
                    }
                    FileObject dest = moveToDirectory.resolveFile(prefix + fileObject.getName().getBaseName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Moving to file :" + VFSUtils.maskURLPassword((String)dest.getName().getURI())));
                    }
                    try {
                        fileObject.moveTo(dest);
                    }
                    catch (FileSystemException e) {
                        if (!VFSUtils.isFailRecord((FileSystemManager)this.fsManager, (FileObject)fileObject, (FileSystemOptions)this.fso)) {
                            VFSUtils.markFailRecord((FileSystemManager)this.fsManager, (FileObject)fileObject, (FileSystemOptions)this.fso);
                        }
                        log.error((Object)("Error moving file : " + VFSUtils.maskURLPassword((String)fileObject.toString()) + " to " + VFSUtils.maskURLPassword((String)moveToDirectoryURI)), (Throwable)e);
                    }
                    break block21;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleting file :" + VFSUtils.maskURLPassword((String)fileObject.toString())));
                    }
                    fileObject.close();
                    if (!fileObject.delete()) {
                        String msg = "Cannot delete file : " + VFSUtils.maskURLPassword((String)fileObject.toString());
                        log.error((Object)msg);
                        throw new SynapseException(msg);
                    }
                }
                catch (FileSystemException e) {
                    log.error((Object)("Error deleting file : " + VFSUtils.maskURLPassword((String)fileObject.toString())), (Throwable)e);
                }
            }
            catch (FileSystemException e) {
                if (VFSUtils.isFailRecord((FileSystemManager)this.fsManager, (FileObject)fileObject, (FileSystemOptions)this.fso)) break block21;
                VFSUtils.markFailRecord((FileSystemManager)this.fsManager, (FileObject)fileObject, (FileSystemOptions)this.fso);
                log.error((Object)("Error resolving directory to move after processing : " + VFSUtils.maskURLPassword((String)moveToDirectoryURI)), (Throwable)e);
            }
        }
    }

    protected Properties getInboundProperties() {
        return this.vfsProperties;
    }

    void destroy() {
        this.fsManager.close();
    }

    class FileSizeDesComparator
    implements Comparator<FileObject> {
        FileSizeDesComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            Long lDiff = 0L;
            try {
                lDiff = o2.getContent().getSize() - o1.getContent().getSize();
            }
            catch (FileSystemException e) {
                log.warn((Object)"Unable to compare size of the two files.", (Throwable)e);
            }
            return lDiff.intValue();
        }
    }

    class FileLastmodifiedtimestampDesComparator
    implements Comparator<FileObject> {
        FileLastmodifiedtimestampDesComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            Long lDiff = 0L;
            try {
                lDiff = o2.getContent().getLastModifiedTime() - o1.getContent().getLastModifiedTime();
            }
            catch (FileSystemException e) {
                log.warn((Object)"Unable to compare lastmodified timestamp of the two files.", (Throwable)e);
            }
            return lDiff.intValue();
        }
    }

    class FileNameDesComparator
    implements Comparator<FileObject> {
        FileNameDesComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o2.getName().compareTo((Object)o1.getName());
        }
    }

    class FileSizeAscComparator
    implements Comparator<FileObject> {
        FileSizeAscComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            Long lDiff = 0L;
            try {
                lDiff = o1.getContent().getSize() - o2.getContent().getSize();
            }
            catch (FileSystemException e) {
                log.warn((Object)"Unable to compare size of the two files.", (Throwable)e);
            }
            return lDiff.intValue();
        }
    }

    class FileLastmodifiedtimestampAscComparator
    implements Comparator<FileObject> {
        FileLastmodifiedtimestampAscComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            Long lDiff = 0L;
            try {
                lDiff = o1.getContent().getLastModifiedTime() - o2.getContent().getLastModifiedTime();
            }
            catch (FileSystemException e) {
                log.warn((Object)"Unable to compare lastmodified timestamp of the two files.", (Throwable)e);
            }
            return lDiff.intValue();
        }
    }

    class FileNameAscComparator
    implements Comparator<FileObject> {
        FileNameAscComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getName().compareTo((Object)o2.getName());
        }
    }
}

