/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputStreamHandler
implements Runnable {
    private String streamType;
    private InputStream inputStream;
    private StringBuilder stringBuilder;
    private static final String STREAM_TYPE_IN = "inputStream";
    private static final String STREAM_TYPE_ERROR = "errorStream";
    private volatile boolean running = true;
    private static final Log log = LogFactory.getLog(InputStreamHandler.class);

    public InputStreamHandler(String name, InputStream is) {
        this.streamType = name;
        this.inputStream = is;
        this.stringBuilder = new StringBuilder();
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.inputStream, "ISO-8859-1");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (this.running) {
                if (!bufferedReader.ready()) continue;
                String s = bufferedReader.readLine();
                this.stringBuilder.setLength(0);
                if (s == null) {
                    break;
                }
                if (STREAM_TYPE_IN.equals(this.streamType)) {
                    this.stringBuilder.append(s).append("\n");
                    log.info((Object)s);
                    continue;
                }
                if (!STREAM_TYPE_ERROR.equals(this.streamType)) continue;
                this.stringBuilder.append(s).append("\n");
                log.error((Object)s);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Problem reading the [" + this.streamType + "] due to: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while closing the stream: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public String getOutput() {
        return this.stringBuilder.toString();
    }
}

