/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.proxyserver;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import org.wso2.carbon.automation.extensions.servers.proxyserver.Proxy;

public class ProxyConnection
extends Thread {
    Socket fromClient;
    String host;
    int port;
    long timeout;

    ProxyConnection(Socket s, String host, int port, long timeout) {
        this.fromClient = s;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        int r0 = -1;
        int r1 = -1;
        int ch = -1;
        int i = -1;
        long time0 = new Date().getTime();
        long time1 = new Date().getTime();
        try {
            Socket toServer = new Socket(this.host, this.port);
            Proxy.display("open connection to:" + toServer + "(timeout=" + this.timeout + " ms)");
            InputStream clientIn = this.fromClient.getInputStream();
            BufferedOutputStream clientOut = new BufferedOutputStream(this.fromClient.getOutputStream());
            InputStream serverIn = toServer.getInputStream();
            BufferedOutputStream serverOut = new BufferedOutputStream(toServer.getOutputStream());
            while (r0 != 0 || r1 != 0 || time1 - time0 <= this.timeout) {
                while ((r0 = clientIn.available()) > 0) {
                    Proxy.println("");
                    Proxy.println("<<<" + r0 + " bytes from client");
                    Proxy.display("");
                    Proxy.display("<<<" + r0 + " bytes from client");
                    for (i = 0; i < r0; ++i) {
                        ch = clientIn.read();
                        if (ch != -1) {
                            ((OutputStream)serverOut).write(ch);
                            Proxy.print(ch);
                            continue;
                        }
                        Proxy.display("client stream closed");
                    }
                    time0 = new Date().getTime();
                    ((OutputStream)serverOut).flush();
                }
                while ((r1 = serverIn.available()) > 0) {
                    Proxy.println("");
                    Proxy.println(">>>" + r1 + " bytes from server");
                    Proxy.display("");
                    Proxy.display(">>>" + r1 + " bytes from server");
                    for (i = 0; i < r1; ++i) {
                        ch = serverIn.read();
                        if (ch != -1) {
                            ((OutputStream)clientOut).write(ch);
                            Proxy.print(ch);
                            continue;
                        }
                        Proxy.display("server stream closed");
                    }
                    time0 = new Date().getTime();
                    ((OutputStream)clientOut).flush();
                }
                if (r0 != 0 || r1 != 0) continue;
                time1 = new Date().getTime();
                Thread.sleep(100L);
            }
            clientIn.close();
            ((OutputStream)clientOut).close();
            serverIn.close();
            ((OutputStream)serverOut).close();
            this.fromClient.close();
            toServer.close();
            Proxy.quit(time1 - time0);
        }
        catch (Throwable t) {
            Proxy.display("i=" + i + " ch=" + ch);
            t.printStackTrace(System.err);
        }
    }
}

