/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.controller;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSBrokerController {
    private static final Log log = LogFactory.getLog(JMSBrokerController.class);
    private String serverName;
    private List<TransportConnector> transportConnectors;
    private BrokerService broker;
    private static boolean isBrokerStarted = false;

    public JMSBrokerController(String serverName, JMSBrokerConfiguration configuration) {
        this.serverName = serverName;
        this.transportConnectors = new ArrayList<TransportConnector>();
        TransportConnector connector = new TransportConnector();
        connector.setName("tcp");
        try {
            connector.setUri(new URI(configuration.getProviderURL()));
        }
        catch (URISyntaxException e) {
            log.error((Object)"Invalid URI", (Throwable)e);
        }
        this.transportConnectors.add(connector);
    }

    public JMSBrokerController(String serverName, List<TransportConnector> transportConnectors) {
        this.serverName = serverName;
        this.transportConnectors = transportConnectors;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean start() {
        try {
            log.info((Object)("JMSServerController: Preparing to start JMS Broker: " + this.serverName));
            this.broker = new BrokerService();
            this.broker.setBrokerName(this.serverName);
            log.info((Object)this.broker.getBrokerDataDirectory());
            this.broker.setDataDirectory(System.getProperty("carbon.home") + File.separator + this.broker.getBrokerDataDirectory());
            this.broker.setTransportConnectors(this.transportConnectors);
            this.broker.setPersistent(true);
            this.broker.start();
            JMSBrokerController.setBrokerStatus(true);
            log.info((Object)"JMSServerController: Broker is Successfully started. continuing tests");
            return true;
        }
        catch (Exception e) {
            log.error((Object)("JMSServerController: There was an error starting JMS broker: " + this.serverName), (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            log.info((Object)" ************* Stopping **************");
            if (this.broker.isStarted()) {
                this.broker.stop();
                for (TransportConnector transportConnector : this.transportConnectors) {
                    transportConnector.stop();
                }
                JMSBrokerController.setBrokerStatus(false);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error while shutting down the broker", (Throwable)e);
            return false;
        }
    }

    public static boolean isBrokerStarted() {
        return isBrokerStarted;
    }

    private static void setBrokerStatus(boolean status) {
        isBrokerStarted = status;
    }
}

