/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.client;

import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSTopicMessagePublisher {
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicPublisher publisher = null;
    private TopicConnectionFactory connectionFactory = null;

    public JMSTopicMessagePublisher(JMSBrokerConfiguration brokerConfiguration) throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", brokerConfiguration.getInitialNamingFactory());
        if (brokerConfiguration.getProviderURL().startsWith("amqp://")) {
            props.put("connectionfactory.TopicConnectionFactory", brokerConfiguration.getProviderURL());
        } else {
            props.setProperty("java.naming.provider.url", brokerConfiguration.getProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        this.connectionFactory = (TopicConnectionFactory)ctx.lookup("TopicConnectionFactory");
    }

    public void connect(String topicName) throws JMSException, NamingException {
        this.connection = this.connectionFactory.createTopicConnection();
        this.connection.start();
        this.session = this.connection.createTopicSession(false, 1);
        Topic topic = this.session.createTopic(topicName);
        this.publisher = this.session.createPublisher(topic);
        this.publisher.setDeliveryMode(1);
    }

    public void connect(String topicName, boolean persistMessage) throws JMSException {
        this.connection = this.connectionFactory.createTopicConnection();
        this.connection.start();
        this.session = this.connection.createTopicSession(false, 1);
        Topic topic = this.session.createTopic(topicName);
        this.publisher = this.session.createPublisher(topic);
        if (persistMessage) {
            this.publisher.setDeliveryMode(2);
        } else {
            this.publisher.setDeliveryMode(1);
        }
    }

    public void disconnect() {
        if (this.publisher != null) {
            try {
                this.publisher.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void publish(String messageContent) throws AutomationFrameworkException {
        if (this.publisher == null) {
            throw new AutomationFrameworkException("No Connection with topic. Please connect");
        }
        TextMessage message = null;
        try {
            message = this.session.createTextMessage(messageContent);
            this.publisher.publish((Message)message);
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Message creation failed", (Throwable)e);
        }
    }

    public void sendBytesMessage(byte[] payload) throws AutomationFrameworkException {
        BytesMessage bm = null;
        try {
            bm = this.session.createBytesMessage();
            bm.writeBytes(payload);
            this.publisher.publish((Message)bm);
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Byte Message creation failed", (Throwable)e);
        }
    }
}

