/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.httpserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.wso2.carbon.automation.extensions.servers.httpserver.RequestInterceptor;

public class TestRequestHandler
implements HttpRequestHandler {
    private int statusCode = 200;
    private String contentType = "application/xml";
    private String payload = "<test/>";
    private boolean emptyBody = false;
    private RequestInterceptor interceptor = null;

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (this.interceptor != null) {
            this.interceptor.requestReceived(request);
        }
        response.setStatusCode(this.statusCode);
        if (!this.emptyBody) {
            this.writeContent(request, response);
        }
    }

    private void writeContent(HttpRequest request, HttpResponse response) {
        if ("HEAD".equals(request.getRequestLine().getMethod()) || this.statusCode == 204 || this.statusCode == 205 || this.statusCode == 304) {
            return;
        }
        EntityTemplate body = this.createEntity();
        body.setContentType(this.contentType);
        response.setEntity((HttpEntity)body);
    }

    private EntityTemplate createEntity() {
        return new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outputStream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                writer.write(TestRequestHandler.this.payload);
                writer.flush();
            }
        });
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setInterceptor(RequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setEmptyBody(boolean emptyBody) {
        this.emptyBody = emptyBody;
    }
}

