/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.httpserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.wso2.carbon.automation.extensions.servers.httpserver.RequestInterceptor;
import org.wso2.carbon.automation.extensions.servers.httpserver.TestRequestHandler;
import org.wso2.carbon.automation.extensions.servers.utils.BackendServer;

public class SimpleHttpServer
implements BackendServer {
    private static final Log log = LogFactory.getLog(SimpleHttpServer.class);
    private int port;
    private Properties properties;
    private ServerSocket serverSocket;
    private ExecutorService listener;
    private ExecutorService workerPool;
    private HttpParams params;
    private HttpService httpService;
    private boolean shutdown = true;
    private TestRequestHandler requestHandler;

    public SimpleHttpServer() {
        this(8080, new Properties());
    }

    public SimpleHttpServer(int port, Properties properties) {
        this.port = port;
        this.properties = properties;
        this.requestHandler = new TestRequestHandler();
    }

    public TestRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    @Override
    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.timeout", this.getParameter("http.socket.timeout", 60000)).setIntParameter("http.socket.buffer-size", this.getParameter("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", this.getParameter("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", this.getParameter("http.tcp.nodelay", 1) == 1).setParameter("http.origin-server", (Object)"WSO2ESB-Test-Server");
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        HttpRequestHandlerRegistry registry = new HttpRequestHandlerRegistry();
        registry.register("*", (HttpRequestHandler)this.requestHandler);
        this.httpService = new HttpService((HttpProcessor)httpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpRequestHandlerResolver)registry, this.params);
        this.listener = Executors.newSingleThreadExecutor();
        this.workerPool = Executors.newFixedThreadPool(this.getParameter("ThreadCount", 2));
        this.shutdown = false;
        this.listener.submit(new HttpListener());
    }

    @Override
    public void stop() throws IOException {
        log.info((Object)"Shutting down simple HTTP server");
        this.shutdown = true;
        this.listener.shutdownNow();
        this.workerPool.shutdownNow();
        this.serverSocket.close();
        try {
            this.listener.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        try {
            this.workerPool.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isStarted() {
        return !this.shutdown;
    }

    @Override
    public void deployService(Object service) throws IOException {
        this.requestHandler.setInterceptor((RequestInterceptor)service);
    }

    private int getParameter(String name, int def) {
        String val = this.properties.getProperty(name);
        if (val != null && Integer.parseInt(val) > 0) {
            return Integer.parseInt(val);
        }
        return def;
    }

    private class ServerWorker
    implements Runnable {
        private final HttpServerConnection conn;

        public ServerWorker(HttpServerConnection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicHttpContext context = new BasicHttpContext(null);
            context.setAttribute("CURRENT_CONN", (Object)this.conn);
            try {
                while (!Thread.interrupted() && this.conn.isOpen()) {
                    SimpleHttpServer.this.httpService.handleRequest(this.conn, (HttpContext)context);
                }
            }
            catch (ConnectionClosedException ex) {
                log.error((Object)"Client closed connection", (Throwable)ex);
            }
            catch (IOException ex) {
                log.error((Object)"I/O error", (Throwable)ex);
            }
            catch (HttpException ex) {
                log.error((Object)"Unrecoverable HTTP protocol violation", (Throwable)ex);
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private class HttpListener
    implements Runnable {
        private HttpListener() {
        }

        @Override
        public void run() {
            log.info((Object)("Starting HTTP server on port: " + SimpleHttpServer.this.port));
            while (!Thread.interrupted()) {
                try {
                    Socket socket = SimpleHttpServer.this.serverSocket.accept();
                    DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                    conn.bind(socket, SimpleHttpServer.this.params);
                    SimpleHttpServer.this.workerPool.submit(new ServerWorker((HttpServerConnection)conn));
                }
                catch (IOException e) {
                    if (SimpleHttpServer.this.shutdown) break;
                    log.error((Object)"I/O error while accepting a connection", (Throwable)e);
                    break;
                }
            }
        }
    }
}

