/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.selenium;

import com.opera.core.systems.OperaDriver;
import com.saucelabs.selenium.client.factory.SeleniumFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.wso2.carbon.automation.engine.context.AutomationContext;

public class BrowserManager {
    private static final Log log = LogFactory.getLog(BrowserManager.class);
    private static AutomationContext automationContext;
    public static WebDriver driver;

    public static WebDriver getWebDriver() throws MalformedURLException, XPathExpressionException {
        automationContext = new AutomationContext();
        String driverSelection = automationContext.getConfigurationNodeList(String.format("//tools/selenium/browser/browserType", new Object[0])).item(0).getFirstChild().getNodeValue();
        if (automationContext.getConfigurationNode(String.format("//tools/selenium/remoteDriverUrl", new Object[0])).getAttributes().item(0).getNodeValue().equals("false")) {
            if (System.getenv().containsKey("SELENIUM_PLATFORM")) {
                log.info((Object)"Test runs on Sauce Labs environment...");
                log.info((Object)("Operating System : " + System.getenv().get("SELENIUM_PLATFORM") + " On Browser " + System.getenv().get("SELENIUM_BROWSER") + " version " + System.getenv().get("SELENIUM_VERSION")));
                driver = SeleniumFactory.createWebDriver();
                driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
                return driver;
            }
            log.info((Object)("Test runs on " + driverSelection + " browser..."));
            BrowserManager.getDriver(driverSelection);
            driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
            return driver;
        }
        log.info((Object)"Test runs on remote browser");
        if (System.getenv().containsKey("JOB_URL")) {
            log.info((Object)"Test runs on Sauce Labs environment...");
            log.info((Object)("Operating System : " + System.getenv().get("SELENIUM_PLATFORM") + " On Browser " + System.getenv().get("SELENIUM_BROWSER") + " version " + System.getenv().get("SELENIUM_VERSION")));
            driver = SeleniumFactory.createWebDriver();
            driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
            return driver;
        }
        BrowserManager.getRemoteWebDriver();
        driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
        return driver;
    }

    private static void getDriver(String driverSelection) throws XPathExpressionException {
        if (driverSelection.equalsIgnoreCase("firefox")) {
            driver = new FirefoxDriver();
        } else if (driverSelection.equalsIgnoreCase("chrome")) {
            System.setProperty("webdriver.chrome.driver", automationContext.getConfigurationValue(String.format("//tools/selenium/browser/webdriverPath", new Object[0])));
            driver = new ChromeDriver();
        } else {
            driver = driverSelection.equalsIgnoreCase("ie") ? new InternetExplorerDriver() : (driverSelection.equalsIgnoreCase("htmlUnit") ? new HtmlUnitDriver(true) : new OperaDriver());
        }
    }

    private static void getRemoteWebDriver() throws MalformedURLException, XPathExpressionException {
        URL url;
        String browserName = automationContext.getConfigurationNodeList(String.format("//tools/selenium/browser/browserType", new Object[0])).item(0).getFirstChild().getNodeValue();
        String remoteWebDriverURL = automationContext.getConfigurationValue(String.format("//tools/selenium/remoteDriverUrl", new Object[0]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Browser selection " + browserName));
            log.debug((Object)("Remote WebDriverURL " + remoteWebDriverURL));
        }
        try {
            url = new URL(remoteWebDriverURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed URL " + e));
            throw new MalformedURLException("Malformed URL " + e);
        }
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setJavascriptEnabled(true);
        capabilities.setBrowserName(browserName);
        driver = new RemoteWebDriver(url, (Capabilities)capabilities);
    }
}

