/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.jmeter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.jmeter.util.Utils;

public class JMeterInstallationProvider {
    private static final Log log = LogFactory.getLog(JMeterInstallationProvider.class);
    private static File jMeterHome = null;
    private static File reportDir = null;
    private static File binDir = null;
    private static File logDir = null;
    private static File jmeterPropertyFile = null;
    private static File jmeterPropertyFileTemp = null;
    private static JMeterInstallationProvider instance = new JMeterInstallationProvider();

    private JMeterInstallationProvider() {
        log.info((Object)"Creating jmeter installation directory structure");
        File targetDir = new File(JMeterInstallationProvider.getTargetLocation());
        boolean isDeleted = false;
        jMeterHome = new File(targetDir, "jmeter");
        if (!jMeterHome.mkdirs()) {
            log.error((Object)"Unable to create jmeter directory");
            throw new RuntimeException("Unable to create jmeter directory");
        }
        reportDir = new File(jMeterHome, "reports");
        File libDir = new File(jMeterHome + File.separator + "lib");
        this.createLibDirectory(libDir);
        File binDir = new File(jMeterHome + File.separator + "bin");
        if (!binDir.exists() && !binDir.mkdirs()) {
            log.error((Object)"unable to create bin directory");
            throw new RuntimeException("unable to create bin dir for Jmeter");
        }
        File saveServiceProps = new File(binDir, "saveservice.properties");
        File upgradeProps = new File(binDir, "upgrade.properties");
        jmeterPropertyFile = new File(binDir, "jmeter.properties");
        jmeterPropertyFileTemp = new File(binDir, "jmeterTemp.properties");
        try {
            Utils.copyFromClassPath("bin/saveservice.properties", saveServiceProps);
        }
        catch (IOException e) {
            log.error((Object)"Could not create temporary saveservice.properties", (Throwable)e);
            throw new RuntimeException("Could not create temporary saveservice.properties " + e.getMessage(), e);
        }
        System.setProperty("saveservice_properties", File.separator + "bin" + File.separator + "saveservice.properties");
        try {
            Utils.copyFromClassPath("bin/upgrade.properties", upgradeProps);
        }
        catch (IOException e) {
            log.error((Object)"Could not create temporary upgrade.properties", (Throwable)e);
            throw new RuntimeException("Could not create temporary upgrade.properties " + e.getMessage(), e);
        }
        System.setProperty("upgrade_properties", File.separator + "bin" + File.separator + "upgrade.properties");
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new FileOutputStream(jmeterPropertyFile);
            log.info((Object)"Loading default jmeter.properties...");
            Utils.copyFromClassPath("bin/jmeter.properties", jmeterPropertyFileTemp);
            if (jmeterPropertyFileTemp.exists()) {
                in = new FileInputStream(jmeterPropertyFileTemp);
                Properties props = new Properties();
                props.load(in);
                props.setProperty("jmeter.exit.check.pause", "0");
                props.setProperty("jmeterengine.stopfail.system.exit", "true");
                props.store(out, null);
            }
            System.setProperty("jmeter_properties", File.separator + "bin" + File.separator + "jmeter.properties");
            logDir = new File(jMeterHome, "logs");
            if (!logDir.mkdirs()) {
                log.error((Object)"Unable to create log directory");
                throw new RuntimeException("Unable to create log directory");
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not create jmeter.properties " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static JMeterInstallationProvider getInstance() {
        return instance;
    }

    public File getJMeterHome() {
        return jMeterHome;
    }

    public File getReportDir() {
        return reportDir;
    }

    public File getBinDir() {
        return binDir;
    }

    public File getLogDir() {
        return logDir;
    }

    public File getJMeterPropertyFile() {
        return jmeterPropertyFile;
    }

    private void createLibDirectory(File libDir) {
        if (!libDir.exists()) {
            File junitDir;
            File extDir;
            if (!libDir.mkdirs()) {
                log.error((Object)"Unable create lib directory");
            }
            if (!(extDir = new File(jMeterHome + File.separator + "lib" + File.separator + "ext")).exists() && !extDir.mkdirs()) {
                log.error((Object)"Unable create ext directory");
            }
            if (!(junitDir = new File(jMeterHome + File.separator + "lib" + File.separator + "junit")).exists() && !junitDir.mkdirs()) {
                log.error((Object)"Unable create junit directory");
            }
        }
    }

    private static String getTargetLocation() {
        return System.getProperty("basedir", ".") + File.separator + "target";
    }
}

