/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.enums.OperatingSystems;

public class FrameworkExtensionUtils {
    private static final Log log = LogFactory.getLog(FrameworkExtensionUtils.class);

    public static String getSystemResourceLocation() {
        String resourceLocation = System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name()) ? System.getProperty("framework.resource.location").replace("/", "\\") : System.getProperty("framework.resource.location").replace("/", "/");
        return resourceLocation;
    }

    public static String getSystemSettingsLocation() {
        String settingsLocation = System.getProperty("automation.settings.location") != null ? (System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name()) ? System.getProperty("automation.settings.location").replace("/", "\\") : System.getProperty("automation.settings.location").replace("/", "/")) : FrameworkExtensionUtils.getSystemResourceLocation();
        return settingsLocation;
    }

    public static String getReportLocation() {
        return System.getProperty("basedir", ".") + File.separator + "target";
    }

    public static String getCarbonZipLocation() {
        return System.getProperty("carbon.zip");
    }

    public static String getCarbonTempLocation() {
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        return new File(baseDir).getAbsolutePath() + File.separator + extractDir;
    }

    public static String getCarbonServerAxisServiceDirectory() {
        return FrameworkExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "axis2services";
    }

    public static String getCarbonServerLibLocation() {
        return FrameworkExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "components" + File.separator + "lib";
    }

    public static String getCarbonServerConfLocation() {
        return FrameworkExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf";
    }

    public static String getCarbonHome() {
        String carbonHome;
        if (System.getProperty("user.dir") != null) {
            carbonHome = System.getProperty("user.dir");
        } else {
            log.error((Object)"Cannot read carbon.home property");
            carbonHome = null;
        }
        return carbonHome;
    }
}

