/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.parser.service.model;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class MessagingConfig {
    @SerializedName(value="clusterId")
    private String clusterId;
    @SerializedName(value="bootstrapServers")
    private String[] bootstrapServers;

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getBootstrapServerURLs() {
        if (this.bootstrapServers != null && this.bootstrapServers.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String urls : this.bootstrapServers) {
                stringBuilder.append(urls.replace("'", "\\'")).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return "";
    }

    public MessagingConfig(String clusterId, String[] bootstrapServers) {
        this.clusterId = clusterId;
        this.bootstrapServers = Arrays.copyOf(bootstrapServers, bootstrapServers.length);
    }

    public boolean isEmpty() {
        return this.clusterId == null || this.clusterId.isEmpty() || this.bootstrapServers == null || this.bootstrapServers.length == 0 || this.bootstrapServers[0].isEmpty();
    }
}

