/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.permissions.rest.api.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.permissions.PermissionProvider;
import org.wso2.carbon.analytics.permissions.bean.Permission;
import org.wso2.carbon.analytics.permissions.bean.Role;
import org.wso2.carbon.analytics.permissions.exceptions.PermissionException;
import org.wso2.carbon.permissions.rest.api.ApiResponseMessage;
import org.wso2.carbon.permissions.rest.api.NotFoundException;
import org.wso2.carbon.permissions.rest.api.PermissionsApiService;
import org.wso2.carbon.permissions.rest.api.configreader.DataHolder;
import org.wso2.carbon.permissions.rest.api.util.PermissionUtil;

@Component(name="PermissionsApiServiceImpl", service={PermissionsApiServiceImpl.class}, immediate=true)
public class PermissionsApiServiceImpl
extends PermissionsApiService {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionsApiServiceImpl.class);

    @Override
    public Response addPermission(org.wso2.carbon.permissions.rest.api.model.Permission body) throws NotFoundException {
        String permissionID = null;
        PermissionProvider permissionProvider = DataHolder.getInstance().getPermissionProvider();
        try {
            Permission permission = new Permission(body.getAppName(), body.getPermissionString());
            if (!permissionProvider.isPermissionExists(permission)) {
                permissionID = permissionProvider.addPermissionAPI(permission);
            }
            return Response.ok().entity(permissionID).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Failed to add Permission with uuid %s ", permissionID);
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response deletePermission(String permissionID) throws NotFoundException {
        try {
            DataHolder.getInstance().getPermissionProvider().deletePermission(permissionID);
            String successMsg = String.format("Deleted permission with %s ", permissionID);
            LOG.info(successMsg);
            return Response.ok().entity((Object)new ApiResponseMessage(4, "Deleted permission with ID: " + permissionID)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Failed to delete with uuid %s ", permissionID);
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response getGrantedRoles(String permissionID) throws NotFoundException {
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            List roleList = DataHolder.getInstance().getPermissionProvider().getGrantedRoles(permissionID);
            String successMsg = String.format("Retrieving granted roles for %s successful ", permissionID);
            LOG.info(successMsg);
            return Response.ok().entity((Object)gson.toJson((Object)roleList)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Failed to retrieve granted roles for %s", permissionID);
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response getPermissionStrings(String appName) throws NotFoundException {
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            List permissionStrings = DataHolder.getInstance().getPermissionProvider().getPermissionStrings(appName);
            String successMsg = String.format("Getting permissions for app, %s successful", PermissionUtil.removeCRLFCharacters(appName));
            LOG.info(successMsg);
            return Response.ok().entity((Object)gson.toJson((Object)permissionStrings)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Failed to retrieve permissions for app name: %s ", PermissionUtil.removeCRLFCharacters(appName));
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response hasPermission(String permissionID, String roleName) throws NotFoundException {
        try {
            Boolean hasPermission = DataHolder.getInstance().getPermissionProvider().hasPermission(roleName, permissionID);
            String successMsg = String.format("Checking permission for app:%s role: %s successful", permissionID, PermissionUtil.removeCRLFCharacters(roleName));
            LOG.info(successMsg);
            return Response.ok().entity((Object)new ApiResponseMessage(4, successMsg)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Checking permission for app:%s role: %s failed", permissionID, PermissionUtil.removeCRLFCharacters(roleName));
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response manipulateRolePermission(org.wso2.carbon.permissions.rest.api.model.Permission body, String roleID, String action) throws NotFoundException {
        String revokeAction = "revoke";
        String grantAction = "grant";
        Permission permission = PermissionUtil.mapPermissionModel(body);
        try {
            switch (action.toLowerCase()) {
                case "revoke": {
                    DataHolder.getInstance().getPermissionProvider().revokePermission(permission, roleID);
                    break;
                }
                case "grant": {
                    Role role = new Role();
                    role.setId(roleID);
                    DataHolder.getInstance().getPermissionProvider().grantPermission(permission, role);
                    break;
                }
                default: {
                    String errorMsg = String.format("Invalid input. Action should be grant/revoke. But found %s", PermissionUtil.removeCRLFCharacters(action));
                    LOG.error(errorMsg);
                    return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
                }
            }
            String successMsg = String.format("Action, %s for permission, %s successful.", PermissionUtil.removeCRLFCharacters(action), PermissionUtil.removeCRLFCharacters(permission.toString()));
            LOG.info(successMsg);
            return Response.ok().entity((Object)new ApiResponseMessage(4, successMsg)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Failed to perform action, %s on permission %s", PermissionUtil.removeCRLFCharacters(action), PermissionUtil.removeCRLFCharacters(permission.toString()));
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }

    @Override
    public Response revokePermission(String permissionID) throws NotFoundException {
        try {
            DataHolder.getInstance().getPermissionProvider().revokePermission(permissionID);
            String successMsg = String.format("Permission revoke for permissionID %s success.", permissionID);
            LOG.info(successMsg);
            return Response.ok().entity((Object)new ApiResponseMessage(4, successMsg)).build();
        }
        catch (PermissionException e) {
            String errorMsg = String.format("Permission revoke for permissionID %s failed.", permissionID);
            LOG.error(errorMsg, (Throwable)e);
            return Response.serverError().entity((Object)new ApiResponseMessage(1, errorMsg)).build();
        }
    }
}

