/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.permissions.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.permissions.rest.api.NotFoundException;
import org.wso2.carbon.permissions.rest.api.PermissionsApiService;
import org.wso2.carbon.permissions.rest.api.factories.PermissionsApiServiceFactory;
import org.wso2.carbon.permissions.rest.api.model.Permission;
import org.wso2.msf4j.Microservice;

@Path(value="/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/xml"})
@ApplicationPath(value="/permissions")
@Api(description="the permissions API")
@Component(name="PermissionsAPI", service={Microservice.class}, immediate=true)
public class PermissionsApi
implements Microservice {
    private static final Logger log = LoggerFactory.getLogger(PermissionsApi.class);
    private final PermissionsApiService delegate = PermissionsApiServiceFactory.getPermissionsApi();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Add a new permission and returns its PermissionID", response=String.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Permission was added successfully", response=String.class), @ApiResponse(code=500, message="Adding Permission failed", response=String.class)})
    public Response addPermission(@ApiParam(value="Permission json object", required=true) Permission body) throws NotFoundException {
        return this.delegate.addPermission(body);
    }

    @DELETE
    @Path(value="/{permissionID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Deleting an existing permission", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Permission deleted successfully", response=void.class), @ApiResponse(code=404, message="Deleting permission unsuccessful", response=void.class)})
    public Response deletePermission(@ApiParam(value="", required=true) @PathParam(value="permissionID") String permissionID) throws NotFoundException {
        return this.delegate.deletePermission(permissionID);
    }

    @GET
    @Path(value="/{permissionID}/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Get granted roles for PermissionID.", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Roles listing successful", response=void.class), @ApiResponse(code=404, message="Role listing unsuccessful", response=void.class)})
    public Response getGrantedRoles(@ApiParam(value="", required=true) @PathParam(value="permissionID") String permissionID) throws NotFoundException {
        return this.delegate.getGrantedRoles(permissionID);
    }

    @GET
    @Path(value="/app/{appName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Get app permissions", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Permission deleted successfully", response=void.class), @ApiResponse(code=404, message="Deleting permission unsuccessful", response=void.class)})
    public Response getPermissionStrings(@ApiParam(value="AppName", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.getPermissionStrings(appName);
    }

    @GET
    @Path(value="auth/{permissionID}/{roleName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Check permission for a specific role.", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Check permission for a specific role successful", response=void.class), @ApiResponse(code=404, message="Check permission for a specific role unsuccessful", response=void.class)})
    public Response hasPermission(@ApiParam(value="", required=true) @PathParam(value="permissionID") String permissionID, @ApiParam(value="", required=true) @PathParam(value="roleName") String roleName) throws NotFoundException {
        return this.delegate.hasPermission(permissionID, roleName);
    }

    @POST
    @Path(value="/roles/{roleName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Grant/Revoke permission from a specific role.", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Permission revoked successfully", response=void.class), @ApiResponse(code=404, message="Revoking permission unsuccessful", response=void.class)})
    public Response manipulateRolePermission(@ApiParam(value="Permission json object", required=true) Permission body, @ApiParam(value="", required=true) @PathParam(value="roleName") String roleName, @ApiParam(value="", required=true) @QueryParam(value="action") String action) throws NotFoundException {
        return this.delegate.manipulateRolePermission(body, roleName, action);
    }

    @POST
    @Path(value="revoke/{permissionID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Revoke permission for all the roles.", response=void.class, tags={"permission"})
    @ApiResponses(value={@ApiResponse(code=200, message="Permission for all roles revoke successful", response=void.class), @ApiResponse(code=404, message="Deleting permission unsuccessful", response=void.class)})
    public Response revokePermission(@ApiParam(value="", required=true) @PathParam(value="permissionID") String permissionID) throws NotFoundException {
        return this.delegate.revokePermission(permissionID);
    }
}

