/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.ProviderConfig;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.exception.DataProviderException;
import org.wso2.carbon.data.provider.websocket.bean.WebSocketChannel;
import org.wso2.carbon.data.provider.websocket.endpoint.WebSocketProviderEndPoint;

@Component(service={DataProvider.class}, immediate=true)
public class WebSocketProvider
implements DataProvider {
    private static final Logger log = LoggerFactory.getLogger(WebSocketProvider.class);
    private WebSocketChannel webSocketChannel;

    @Override
    public DataProvider init(String topic, String sessionId, JsonElement jsonElement) throws DataProviderException {
        this.webSocketChannel = (WebSocketChannel)new Gson().fromJson(jsonElement, WebSocketChannel.class);
        this.webSocketChannel.setSessionId(sessionId);
        this.webSocketChannel.setSubscriberTopic(topic);
        return this;
    }

    @Override
    public void start() {
        WebSocketProviderEndPoint.subscribeToTopic(this.webSocketChannel.getTopic(), this.webSocketChannel);
    }

    @Override
    public void stop() {
        WebSocketProviderEndPoint.unsubscribeFromTopic(this.webSocketChannel.getTopic(), this.webSocketChannel.getSessionId());
    }

    @Override
    public boolean configValidator(ProviderConfig providerConfig) throws DataProviderException {
        return false;
    }

    @Override
    public String providerName() {
        return "WebSocketProvider";
    }

    @Override
    public DataSetMetadata dataSetMetadata() {
        return null;
    }

    @Override
    public String providerConfig() {
        HashMap<String, String> renderingTypes = new HashMap<String, String>();
        String providerDescription = "Websocket provider can be used retrieve data to the widgets using a websocket sink, provider supports mappings of json, xml and text";
        renderingTypes.put("topic", "TEXT_FIELD");
        renderingTypes.put("mapType", "TEXT_FIELD");
        return new Gson().toJson((Object)new Object[]{renderingTypes, new WebSocketChannel(), null, providerDescription});
    }
}

