/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.utils;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.DataProviderAuthorizer;
import org.wso2.carbon.datasource.core.api.DataSourceService;

public class DataProviderValueHolder {
    private static DataProviderValueHolder dataProviderHelper = new DataProviderValueHolder();
    private DataSourceService dataSourceService = null;
    private ConfigProvider configProvider = null;
    private Map<String, Map<String, DataProvider>> sessionDataProviderMap = new ConcurrentHashMap<String, Map<String, DataProvider>>();
    private Map<String, Class> dataProviderClassMap = new ConcurrentHashMap<String, Class>();
    private Map<String, DataProviderAuthorizer> dataProviderAuthorizerClassMap = new ConcurrentHashMap<String, DataProviderAuthorizer>();
    private IdPClient idpClient = null;

    public static DataProviderValueHolder getDataProviderHelper() {
        return dataProviderHelper;
    }

    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    public void setDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public DataProviderAuthorizer getDataProviderAuthorizer(String dataProviderAuthorizerClassName) {
        return this.dataProviderAuthorizerClassMap.get(dataProviderAuthorizerClassName);
    }

    public void setDataProviderAuthorizer(String dataProviderAuthorizerClassName, DataProviderAuthorizer dataProviderAuthorizer) {
        this.dataProviderAuthorizerClassMap.put(dataProviderAuthorizerClassName, dataProviderAuthorizer);
    }

    public void setDataProvider(String providerName, DataProvider dataProvider) {
        this.dataProviderClassMap.put(providerName, dataProvider.getClass());
    }

    public DataProvider getDataProvider(String providerName) throws IllegalAccessException, InstantiationException {
        return (DataProvider)this.dataProviderClassMap.get(providerName).newInstance();
    }

    public Set<String> getDataProviderNameSet() {
        return this.dataProviderClassMap.keySet();
    }

    public Map<String, DataProvider> getTopicDataProviderMap(String sessionId) {
        return this.sessionDataProviderMap.get(sessionId);
    }

    public void removeDataProviderClass(String providerName) {
        this.dataProviderClassMap.remove(providerName);
    }

    public void removeDataProviderAuthorizerClass(String dataProviderAuthorizerClassName) {
        this.dataProviderAuthorizerClassMap.remove(dataProviderAuthorizerClassName);
    }

    public void removeSessionData(String sessionId) {
        this.sessionDataProviderMap.remove(sessionId);
    }

    public boolean removeTopicIfExist(String sessionId, String topic) {
        if (this.sessionDataProviderMap.containsKey(sessionId) && this.sessionDataProviderMap.get(sessionId).containsKey(topic)) {
            DataProvider dataProvider = this.sessionDataProviderMap.get(sessionId).remove(topic);
            if (dataProvider != null) {
                dataProvider.stop();
            }
            return true;
        }
        return false;
    }

    public void addDataProviderToSessionMap(String sessionId, String topic, DataProvider dataProvider) {
        if (this.sessionDataProviderMap.containsKey(sessionId)) {
            this.sessionDataProviderMap.get(sessionId).put(topic, dataProvider);
        } else {
            this.sessionDataProviderMap.put(sessionId, new ConcurrentHashMap());
            this.sessionDataProviderMap.get(sessionId).put(topic, dataProvider);
        }
    }

    public IdPClient getIdpClient() {
        return this.idpClient;
    }

    public void setIdpClient(IdPClient idpClient) {
        this.idpClient = idpClient;
    }
}

