/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.siddhi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.event.Event;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.execution.query.OnDemandQuery;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.data.provider.AbstractDataProvider;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.ProviderConfig;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.exception.DataProviderException;
import org.wso2.carbon.data.provider.siddhi.SiddhiAppRuntimeHolder;
import org.wso2.carbon.data.provider.siddhi.config.SiddhiDataProviderConfig;

@Component(service={DataProvider.class}, immediate=true)
public class SiddhiProvider
extends AbstractDataProvider {
    private static final String PROVIDER_NAME = "SiddhiStoreDataProvider";
    private static final String SIDDHI_APP = "siddhiApp";
    private static final String STORE_QUERY = "queryData";
    private static final String PULISHING_INTERVAL = "publishingInterval";
    private static final String TIME_COLUMNS = "timeColumns";
    private static final String QUERY = "query";
    private static final Pattern LIMIT_FILTER_REGEX = Pattern.compile("(?<=limit )([0-9]*)");
    private static final Pattern OFFSET_AND_VALUE_REGEX = Pattern.compile("(offset )(?<=offset )([0-9]*)");
    private static SiddhiManager siddhiManager = null;
    private SiddhiDataProviderConfig siddhiDataProviderConfig;
    private DataSetMetadata metadata;
    private SiddhiAppRuntime siddhiAppRuntime;
    private String[] linearTypes = new String[]{"INT", "LONG", "FLOAT", "DOUBLE"};
    private String[] ordinalTypes = new String[]{"STRING", "BOOL"};
    private List<String> timeColumns;

    @Override
    public DataProvider init(String topic, String sessionId, JsonElement jsonElement) throws DataProviderException {
        this.siddhiDataProviderConfig = (SiddhiDataProviderConfig)new Gson().fromJson(jsonElement, SiddhiDataProviderConfig.class);
        this.siddhiDataProviderConfig.setQueryData(((JsonObject)jsonElement).get(STORE_QUERY));
        this.siddhiDataProviderConfig.setSiddhiAppContext(((JsonObject)jsonElement).get(SIDDHI_APP).getAsString());
        this.timeColumns = Arrays.asList(this.siddhiDataProviderConfig.getTimeColumns().toUpperCase(Locale.ENGLISH).split(","));
        super.init(topic, sessionId, this.siddhiDataProviderConfig);
        this.siddhiAppRuntime = SiddhiAppRuntimeHolder.getSiddhiAppRuntime(this.siddhiDataProviderConfig.getSiddhiAppContext());
        OnDemandQuery onDemandQuery = SiddhiCompiler.parseOnDemandQuery((String)this.siddhiDataProviderConfig.getQueryData().getAsJsonObject().get(QUERY).getAsString());
        Attribute[] outputAttributeList = this.siddhiAppRuntime.getOnDemandQueryOutputAttributes(onDemandQuery);
        this.metadata = new DataSetMetadata(outputAttributeList.length);
        for (int i = 0; i < outputAttributeList.length; ++i) {
            Attribute outputAttribute = outputAttributeList[i];
            this.metadata.put(i, outputAttribute.getName(), this.getMetadataTypes(outputAttribute.getName(), outputAttribute.getType().toString()));
        }
        return this;
    }

    @Override
    public boolean configValidator(ProviderConfig providerConfig) throws DataProviderException {
        SiddhiDataProviderConfig siddhiDataProviderConfig = (SiddhiDataProviderConfig)providerConfig;
        return siddhiDataProviderConfig.getSiddhiAppContext() != null && siddhiDataProviderConfig.getQueryData().getAsJsonObject().get(QUERY).getAsString() != null;
    }

    @Override
    public String providerName() {
        return PROVIDER_NAME;
    }

    @Override
    public DataSetMetadata dataSetMetadata() {
        return this.metadata;
    }

    @Override
    public String providerConfig() {
        HashMap<String, String> renderingTypes = new HashMap<String, String>();
        HashMap<String, String> renderingHints = new HashMap<String, String>();
        String providerDescription = "Siddhi app provider will allow the user to retrieve data from siddhi by writing using a siddhi app";
        renderingTypes.put(SIDDHI_APP, "SIDDHI_CODE");
        renderingHints.put(SIDDHI_APP, "Siddhi app which is used to retrieve the data");
        renderingTypes.put(STORE_QUERY, "DYNAMIC_SIDDHI_CODE");
        renderingTypes.put(PULISHING_INTERVAL, "NUMBER");
        renderingHints.put(PULISHING_INTERVAL, "Rate at which data should be sent to the widget");
        renderingTypes.put(TIME_COLUMNS, "TEXT_FIELD");
        renderingHints.put(TIME_COLUMNS, "Comma separated columns of the table that contain timestamps");
        return new Gson().toJson((Object)new Object[]{renderingTypes, new SiddhiDataProviderConfig(), renderingHints, providerDescription});
    }

    @Override
    public void publish(String topic, String sessionId) {
        Event[] events = this.siddhiAppRuntime.query(this.siddhiDataProviderConfig.getQueryData().getAsJsonObject().get(QUERY).getAsString());
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        if (events != null) {
            for (Event event : events) {
                data.add(event.getData());
            }
        }
        this.publishToEndPoint(data, sessionId, topic);
    }

    public void publishWithPagination(JsonElement jsonElement, String topic, String sessionId) {
        int newLimit;
        this.siddhiDataProviderConfig = (SiddhiDataProviderConfig)new Gson().fromJson(jsonElement, SiddhiDataProviderConfig.class);
        int currentPage = this.siddhiDataProviderConfig.getCurrentPage();
        int pageSize = this.siddhiDataProviderConfig.getPageSize();
        this.siddhiDataProviderConfig = (SiddhiDataProviderConfig)new Gson().fromJson(jsonElement, SiddhiDataProviderConfig.class);
        String query = this.siddhiDataProviderConfig.getQueryData().getAsJsonObject().get(QUERY).getAsString();
        Matcher limitMatcher = LIMIT_FILTER_REGEX.matcher(query);
        Matcher offsetAndValueMatcher = OFFSET_AND_VALUE_REGEX.matcher(query);
        boolean limitMatcherFound = false;
        boolean offsetAndValueMatcherFound = false;
        int limit = 0;
        int offset = 0;
        if (limitMatcher.find()) {
            limitMatcherFound = true;
            int n = limit = limitMatcher.group().isEmpty() ? 0 : Integer.parseInt(limitMatcher.group());
        }
        if (offsetAndValueMatcher.find()) {
            offsetAndValueMatcherFound = true;
            offset = offsetAndValueMatcher.group(2).isEmpty() ? 0 : Integer.parseInt(offsetAndValueMatcher.group(2));
        }
        int newOffset = offset + currentPage * pageSize;
        int n = newLimit = limitMatcherFound && limit < pageSize ? limit : pageSize;
        if (limitMatcherFound && newLimit + newOffset > limit + offset) {
            int limitDiff = limit + offset - newOffset;
            newLimit = limitDiff <= 0 ? 0 : limitDiff;
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        if (newLimit == 0) {
            this.publishToEndPoint(data, sessionId, topic);
        } else {
            if (!limitMatcherFound && offsetAndValueMatcherFound) {
                query = offsetAndValueMatcher.replaceFirst("limit " + newLimit + " offset " + newOffset);
            } else if (limitMatcherFound && offsetAndValueMatcherFound) {
                query = limitMatcher.replaceFirst(String.valueOf(newLimit));
                offsetAndValueMatcher = OFFSET_AND_VALUE_REGEX.matcher(query);
                query = offsetAndValueMatcher.replaceFirst("offset " + newOffset);
            } else {
                query = limitMatcherFound ? limitMatcher.replaceFirst(newLimit + " offset " + newOffset) : query + " limit " + newLimit + " offset " + newOffset;
            }
            Event[] events = this.siddhiAppRuntime.query(query);
            if (events != null) {
                for (Event event : events) {
                    data.add(event.getData());
                }
            }
            this.publishToEndPoint(data, sessionId, topic);
        }
    }

    @Override
    public void purging() {
    }

    @Override
    public void setProviderConfig(ProviderConfig providerConfig) {
        this.siddhiDataProviderConfig = (SiddhiDataProviderConfig)providerConfig;
    }

    @Override
    public DataSetMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void stop() {
        super.stop();
    }

    private DataSetMetadata.Types getMetadataTypes(String columnName, String dataType) {
        if (this.timeColumns.contains(columnName.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.TIME;
        }
        if (Arrays.asList(this.linearTypes).contains(dataType.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.LINEAR;
        }
        if (Arrays.asList(this.ordinalTypes).contains(dataType.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.ORDINAL;
        }
        return DataSetMetadata.Types.OBJECT;
    }

    public SiddhiDataProviderConfig getSiddhiDataProviderConfig() {
        return this.siddhiDataProviderConfig;
    }
}

