/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.siddhi;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.query.compiler.exception.SiddhiParserException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.exception.DataProviderException;

public class SiddhiAppRuntimeHolder {
    private static final Logger logger = LoggerFactory.getLogger(SiddhiAppRuntimeHolder.class);
    static Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap = new HashMap<String, SiddhiAppRuntime>();
    static SiddhiManager siddhiManager;

    public static SiddhiAppRuntime getSiddhiAppRuntime(String siddhiApp) throws DataProviderException {
        MessageDigest digest;
        logger.debug("Siddhi App Runtime Map key set size :" + siddhiAppRuntimeMap.size());
        logger.debug("Siddhi App Runtime Map key set :" + Arrays.toString(siddhiAppRuntimeMap.keySet().toArray()));
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataProviderException("Invalid Encoding type SHA-256 ", e);
        }
        byte[] hash = digest.digest(siddhiApp.getBytes(StandardCharsets.UTF_8));
        String md5OfSiddhiApp = Base64.getEncoder().encodeToString(hash);
        if (siddhiAppRuntimeMap.containsKey(md5OfSiddhiApp)) {
            return siddhiAppRuntimeMap.get(md5OfSiddhiApp);
        }
        try {
            SiddhiAppRuntime siddhiAppRuntime = SiddhiAppRuntimeHolder.getSiddhiManager().createSiddhiAppRuntime(siddhiApp);
            siddhiAppRuntime.setPurgingEnabled(false);
            siddhiAppRuntime.start();
            siddhiAppRuntimeMap.put(md5OfSiddhiApp, siddhiAppRuntime);
            return siddhiAppRuntime;
        }
        catch (SiddhiParserException e) {
            throw new DataProviderException("Invalid Siddhi App Context", e);
        }
    }

    private static SiddhiManager getSiddhiManager() {
        if (siddhiManager == null) {
            siddhiManager = new SiddhiManager();
        }
        return siddhiManager;
    }
}

