/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.rdbms;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.data.provider.AbstractDataProvider;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.ProviderConfig;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.exception.DataProviderException;
import org.wso2.carbon.data.provider.rdbms.bean.RDBMSDataProviderConfBean;
import org.wso2.carbon.data.provider.rdbms.config.RDBMSDataProviderConf;
import org.wso2.carbon.data.provider.rdbms.utils.RDBMSQueryManager;
import org.wso2.carbon.data.provider.utils.DataProviderValueHolder;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class AbstractRDBMSDataProvider
extends AbstractDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRDBMSDataProvider.class);
    private static final String DB2_DB_TYPE = "DB2";
    private String recordLimitQuery;
    private String purgingQuery;
    private String totalRecordCountQuery;
    private String greaterThanWhereSQLQuery;
    private DataSetMetadata metadata;
    private int columnCount;
    private RDBMSDataProviderConf rdbmsProviderConfig;
    private RDBMSDataProviderConfBean rdbmsDataProviderConfBean;

    @Override
    public DataProvider init(String topic, String sessionId, JsonElement jsonElement) throws DataProviderException {
        block18: {
            try {
                this.rdbmsDataProviderConfBean = (RDBMSDataProviderConfBean)DataProviderValueHolder.getDataProviderHelper().getConfigProvider().getConfigurationObject(RDBMSDataProviderConfBean.class);
            }
            catch (ConfigurationException e) {
                throw new DataProviderException("unable to load database query configuration: " + e.getMessage(), e);
            }
            ProviderConfig providerConfig = (ProviderConfig)new Gson().fromJson(jsonElement, RDBMSDataProviderConf.class);
            super.init(topic, sessionId, providerConfig);
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                connection = AbstractRDBMSDataProvider.getConnection(this.rdbmsProviderConfig.getDatasourceName());
                String databaseName = connection.getMetaData().getDatabaseProductName();
                String databaseVersion = connection.getMetaData().getDatabaseProductVersion();
                if (databaseName.toLowerCase(Locale.ENGLISH).contains(DB2_DB_TYPE.toLowerCase(Locale.ENGLISH))) {
                    databaseName = DB2_DB_TYPE;
                }
                RDBMSQueryManager rdbmsQueryManager = new RDBMSQueryManager(databaseName, databaseVersion);
                this.totalRecordCountQuery = rdbmsQueryManager.getQuery("total_record_count");
                if (this.totalRecordCountQuery != null) {
                    this.totalRecordCountQuery = this.totalRecordCountQuery.replace("{{TABLE_NAME}}", this.rdbmsProviderConfig.getTableName());
                }
                this.purgingQuery = rdbmsQueryManager.getQuery("record_delete");
                if (this.purgingQuery != null) {
                    this.purgingQuery = this.purgingQuery.replace("{{TABLE_NAME}}", this.rdbmsProviderConfig.getTableName()).replace("{{INCREMENTAL_COLUMN}}", this.rdbmsProviderConfig.getIncrementalColumn());
                }
                this.greaterThanWhereSQLQuery = rdbmsQueryManager.getQuery("record_greater_than");
                if (this.greaterThanWhereSQLQuery != null) {
                    this.greaterThanWhereSQLQuery = this.greaterThanWhereSQLQuery.replace("{{INCREMENTAL_COLUMN}}", this.getRdbmsProviderConfig().getIncrementalColumn()).replace("{{LIMIT_VALUE}}", Long.toString(this.rdbmsProviderConfig.getPublishingLimit())).replace("{{CUSTOM_QUERY}}", this.rdbmsProviderConfig.getQuery().getAsJsonObject().get("query").getAsString());
                }
                this.recordLimitQuery = rdbmsQueryManager.getQuery("record_limit");
                if (this.recordLimitQuery == null) break block18;
                this.recordLimitQuery = this.recordLimitQuery.replace("{{INCREMENTAL_COLUMN}}", this.rdbmsProviderConfig.getIncrementalColumn()).replace("{{LIMIT_VALUE}}", Long.toString(this.rdbmsProviderConfig.getPublishingLimit())).replace("{{CUSTOM_QUERY}}", this.rdbmsProviderConfig.getQuery().getAsJsonObject().get("query").getAsString());
                try {
                    statement = connection.prepareStatement(this.recordLimitQuery);
                    resultSet = statement.executeQuery();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    this.metadata = new DataSetMetadata(resultSetMetaData.getColumnCount());
                    this.columnCount = this.metadata.getColumnCount();
                    List<String> timeColumns = null;
                    if (this.rdbmsProviderConfig.getTimeColumns() != null && !this.rdbmsProviderConfig.getTimeColumns().isEmpty()) {
                        timeColumns = Arrays.asList(this.rdbmsProviderConfig.getTimeColumns().split(","));
                    }
                    for (int i = 0; i < this.columnCount; ++i) {
                        boolean isTimeColumnFound = false;
                        if (timeColumns != null) {
                            for (String timeColumn : timeColumns) {
                                if (!timeColumn.equalsIgnoreCase(resultSetMetaData.getColumnName(i + 1))) continue;
                                this.metadata.put(i, resultSetMetaData.getColumnName(i + 1), DataSetMetadata.Types.TIME);
                                isTimeColumnFound = true;
                            }
                        }
                        if (isTimeColumnFound) continue;
                        this.metadata.put(i, resultSetMetaData.getColumnName(i + 1), this.getMetadataTypes(resultSetMetaData.getColumnTypeName(i + 1)));
                    }
                }
                catch (SQLException e) {
                    throw new DataProviderException("SQL exception occurred " + e.getMessage(), e);
                }
            }
            catch (SQLException | DataSourceException e) {
                throw new DataProviderException("Failed to load purging template query: " + e.getMessage(), e);
            }
            catch (IOException | ConfigurationException | QueryMappingNotAvailableException e) {
                throw new DataProviderException("unable to load database query configuration: " + e.getMessage(), e);
            }
            finally {
                AbstractRDBMSDataProvider.cleanupConnection(resultSet, statement, connection);
            }
        }
        return this;
    }

    public static Connection getConnection(String dataSourceName) throws SQLException, DataSourceException {
        return ((DataSource)DataProviderValueHolder.getDataProviderHelper().getDataSourceService().getDataSource(dataSourceName)).getConnection();
    }

    public static void cleanupConnection(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error on closing resultSet " + e.getMessage(), (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error on closing statement " + e.getMessage(), (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error on closing connection " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public DataSetMetadata.Types getMetadataTypes(String dataType) {
        if (Arrays.asList(this.rdbmsDataProviderConfBean.getLinearTypes()).contains(dataType.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.LINEAR;
        }
        if (Arrays.asList(this.rdbmsDataProviderConfBean.getOrdinalTypes()).contains(dataType.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.ORDINAL;
        }
        if (Arrays.asList(this.rdbmsDataProviderConfBean.getTimeTypes()).contains(dataType.toUpperCase(Locale.ENGLISH))) {
            return DataSetMetadata.Types.TIME;
        }
        return DataSetMetadata.Types.OBJECT;
    }

    public boolean querySanitizingValidator(String query, String tableName) {
        boolean isValidQuery = true;
        if (query != null && tableName != null) {
            if (this.rdbmsDataProviderConfBean.getSqlSelectQuerySanitizingRegex() != null) {
                isValidQuery = query.matches(this.rdbmsDataProviderConfBean.getSqlSelectQuerySanitizingRegex());
            }
            if (this.rdbmsDataProviderConfBean.getSqlWhereQuerySanitizingRegex() != null) {
                isValidQuery = query.matches(this.rdbmsDataProviderConfBean.getSqlWhereQuerySanitizingRegex());
            }
            if (this.rdbmsDataProviderConfBean.getSqlTableNameSanitizingRegex() != null) {
                isValidQuery = tableName.matches(this.rdbmsDataProviderConfBean.getSqlTableNameSanitizingRegex());
            }
        } else {
            isValidQuery = false;
        }
        return isValidQuery;
    }

    public String getRecordLimitQuery() {
        return this.recordLimitQuery;
    }

    public String getPurgingQuery() {
        return this.purgingQuery;
    }

    public String getTotalRecordCountQuery() {
        return this.totalRecordCountQuery;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getGreaterThanWhereSQLQuery() {
        return this.greaterThanWhereSQLQuery;
    }

    public RDBMSDataProviderConf getRdbmsProviderConfig() {
        return this.rdbmsProviderConfig;
    }

    public RDBMSDataProviderConfBean getRdbmsDataProviderConfBean() {
        return this.rdbmsDataProviderConfBean;
    }

    @Override
    public void setProviderConfig(ProviderConfig providerConfig) {
        this.rdbmsProviderConfig = (RDBMSDataProviderConf)providerConfig;
    }

    @Override
    public DataSetMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean configValidator(ProviderConfig providerConfig) throws DataProviderException {
        RDBMSDataProviderConf rdbmsDataProviderConf = (RDBMSDataProviderConf)providerConfig;
        return this.querySanitizingValidator(rdbmsDataProviderConf.getQuery().getAsJsonObject().get("query").getAsString(), rdbmsDataProviderConf.getTableName());
    }

    @Override
    public String providerName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public DataSetMetadata dataSetMetadata() {
        return this.metadata;
    }

    @Override
    public String providerConfig() {
        HashMap<String, String> renderingTypes = new HashMap<String, String>();
        HashMap<String, String> renderingHints = new HashMap<String, String>();
        String providerDescription = "RDBMS provider supports retrieve data for widgets using any SQL database table. The Batch provider allows the user to get all the data in the table batch wise and Streaming data provider will allow the user retrieve data in a streaming manner using an incremental data column.";
        renderingTypes.put("publishingInterval", "NUMBER");
        renderingHints.put("publishingInterval", "Rate at which data should be sent to the widget");
        renderingTypes.put("purgingInterval", "NUMBER");
        renderingHints.put("purgingInterval", "Rate at which data deletion queries should run against the table");
        renderingTypes.put("isPurgingEnable", "SWITCH");
        renderingHints.put("isPurgingEnable", "Enable execution of data deletion queries against the table at regular intervals");
        renderingTypes.put("publishingLimit", "NUMBER");
        renderingHints.put("publishingLimit", "Limit of records that should be sent at a time");
        renderingTypes.put("purgingLimit", "NUMBER");
        renderingHints.put("purgingLimit", "Limit of data entries that should be deleted at a time");
        renderingTypes.put("datasourceName", "TEXT_FIELD");
        renderingHints.put("datasourceName", "Name of the datasource defined in the deployment.yaml");
        renderingTypes.put("queryData", "DYNAMIC_SQL_CODE");
        renderingTypes.put("tableName", "TEXT_FIELD");
        renderingHints.put("tableName", "Name of the table where data is retrieved from");
        renderingTypes.put("incrementalColumn", "TEXT_FIELD");
        renderingHints.put("incrementalColumn", "Column of the table that is used to identify the incremental data");
        renderingTypes.put("timeColumns", "TEXT_FIELD");
        renderingHints.put("timeColumns", "Columns of the table that contain timestamps");
        return new Gson().toJson((Object)new Object[]{renderingTypes, new RDBMSDataProviderConf(), renderingHints, providerDescription});
    }

    @Override
    public void publish(String topic, String sessionId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purging() {
        block9: {
            if (this.totalRecordCountQuery != null && this.purgingQuery != null) {
                try {
                    ResultSet resultSet;
                    PreparedStatement statement;
                    Connection connection;
                    block8: {
                        connection = AbstractRDBMSDataProvider.getConnection(this.rdbmsProviderConfig.getDatasourceName());
                        statement = null;
                        resultSet = null;
                        try {
                            int totalRecordCount = 0;
                            statement = connection.prepareStatement(this.totalRecordCountQuery);
                            resultSet = statement.executeQuery();
                            while (resultSet.next()) {
                                totalRecordCount = resultSet.getInt(1);
                            }
                            if ((long)totalRecordCount <= this.rdbmsProviderConfig.getPurgingLimit()) break block8;
                            String query = this.purgingQuery.replace("{{LIMIT_VALUE}}", Long.toString((long)totalRecordCount - this.rdbmsProviderConfig.getPurgingLimit()));
                            statement = connection.prepareStatement(query);
                            statement.executeUpdate();
                        }
                        catch (SQLException e) {
                            try {
                                LOGGER.error("SQL exception occurred " + e.getMessage(), (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                AbstractRDBMSDataProvider.cleanupConnection(resultSet, statement, connection);
                                throw throwable;
                            }
                            AbstractRDBMSDataProvider.cleanupConnection(resultSet, statement, connection);
                            break block9;
                        }
                    }
                    AbstractRDBMSDataProvider.cleanupConnection(resultSet, statement, connection);
                }
                catch (SQLException | DataSourceException e) {
                    LOGGER.error("Failed to create a connection to the database " + e.getMessage(), e);
                }
            }
        }
    }
}

