/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.endpoint;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.server.ServerEndpoint;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.AuthenticationException;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.data.provider.AbstractDataProvider;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.DataProviderAuthorizer;
import org.wso2.carbon.data.provider.bean.DataProviderConfigRoot;
import org.wso2.carbon.data.provider.rdbms.bean.RDBMSDataProviderConfBean;
import org.wso2.carbon.data.provider.siddhi.SiddhiProvider;
import org.wso2.carbon.data.provider.utils.DataProviderValueHolder;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.msf4j.websocket.WebSocketEndpoint;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

@ServerEndpoint(value="/data-provider")
@Component(service={WebSocketEndpoint.class}, immediate=true)
public class DataProviderEndPoint
implements WebSocketEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProviderEndPoint.class);
    private static final Map<String, WebSocketConnection> sessionMap = new ConcurrentHashMap<String, WebSocketConnection>();
    private static final String WEB_SOCKET_CONFIG_HEADER = "data.provider.configs";
    private static final String WEB_SOCKET_AUTHORIZING_CLASS_CONFIG_HEADER = "authorizingClass";
    private static final String DEFAULT_WEBSOCKET_AUTHORIZING_CLASS = "org.wso2.carbon.data.provider.DefaultDataProviderAuthorizer";
    private static final Map<String, String> usernameMap = new ConcurrentHashMap<String, String>();

    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceService")
    protected void registerDataSourceService(DataSourceService service) {
        DataProviderValueHolder.getDataProviderHelper().setDataSourceService(service);
    }

    protected void unregisterDataSourceService(DataSourceService service) {
        DataProviderValueHolder.getDataProviderHelper().setDataSourceService(null);
    }

    @Reference(service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigProvider")
    protected void setConfigProvider(ConfigProvider configProvider) {
        DataProviderValueHolder.getDataProviderHelper().setConfigProvider(configProvider);
    }

    protected void unsetConfigProvider(ConfigProvider configProvider) {
        DataProviderValueHolder.getDataProviderHelper().setConfigProvider(null);
    }

    @Reference(service=DataProviderAuthorizer.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetDataProviderAuthorizer")
    protected void setDataProviderAuthorizer(DataProviderAuthorizer dataProviderAuthorizer) {
        DataProviderValueHolder.getDataProviderHelper().setDataProviderAuthorizer(dataProviderAuthorizer.getClass().getName(), dataProviderAuthorizer);
        LOGGER.debug("Data Provider Authorizer '{}' registered.", (Object)dataProviderAuthorizer.getClass().getName());
    }

    protected void unsetDataProviderAuthorizer(DataProviderAuthorizer dataProviderAuthorizer) {
        DataProviderValueHolder.getDataProviderHelper().removeDataProviderAuthorizerClass(dataProviderAuthorizer.getClass().getName());
        LOGGER.debug("Data Provider Authorizer '{}' unregistered.", (Object)dataProviderAuthorizer.getClass().getName());
    }

    @Reference(name="org.wso2.carbon.analytics.idp.client.core.api.IdPClient", service=IdPClient.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdpClient")
    protected void setIdpClient(IdPClient idpClient) {
        DataProviderValueHolder.getDataProviderHelper().setIdpClient(idpClient);
    }

    protected void unsetIdpClient(IdPClient idpClient) {
        DataProviderValueHolder.getDataProviderHelper().setIdpClient(null);
    }

    @OnOpen
    public static void onOpen(WebSocketConnection webSocketConnection, HttpCarbonRequest request) {
        String username;
        if (request.getHeader("Cookie") == null || request.getHeader("Cookie").isEmpty()) {
            webSocketConnection.terminateConnection();
            LOGGER.error("Unauthorised access to data provider denied.");
            return;
        }
        String[] cookies = request.getHeader("Cookie").split(";");
        String accessTokenPart1 = "";
        String accessTokenPart2 = "";
        for (String cookie : cookies) {
            String[] cookieParts = cookie.trim().split("=");
            if ("DID".equals(cookieParts[0])) {
                accessTokenPart2 = cookieParts[1];
                continue;
            }
            if (!"DATA_PROVIDER_USER".equals(cookieParts[0])) continue;
            accessTokenPart1 = ((Map)new Gson().fromJson(cookieParts[1], Map.class)).get("SDID").toString();
        }
        String accessToken = accessTokenPart1 + accessTokenPart2;
        try {
            username = DataProviderValueHolder.getDataProviderHelper().getIdpClient().authenticate(accessToken);
        }
        catch (AuthenticationException | IdPClientException e) {
            webSocketConnection.terminateConnection();
            LOGGER.error("Unauthorised access to data provider denied.", e);
            return;
        }
        sessionMap.put(webSocketConnection.getChannelId(), webSocketConnection);
        usernameMap.put(webSocketConnection.getChannelId(), username);
    }

    @OnMessage
    public void onMessage(String message, WebSocketConnection webSocketConnection) {
        block24: {
            DataProviderConfigRoot dataProviderConfigRoot = (DataProviderConfigRoot)new Gson().fromJson(message, DataProviderConfigRoot.class);
            try {
                String authoringClassName;
                Map webSocketConfiguration = null;
                if (!(DataProviderValueHolder.getDataProviderHelper().getConfigProvider().getConfigurationObject(WEB_SOCKET_CONFIG_HEADER) instanceof RDBMSDataProviderConfBean)) {
                    webSocketConfiguration = (Map)DataProviderValueHolder.getDataProviderHelper().getConfigProvider().getConfigurationObject(WEB_SOCKET_CONFIG_HEADER);
                }
                if (webSocketConfiguration != null) {
                    JSONObject webSocketConfigJSON = new JSONObject(new Gson().toJson((Object)webSocketConfiguration));
                    if (!webSocketConfigJSON.has(WEB_SOCKET_AUTHORIZING_CLASS_CONFIG_HEADER)) {
                        throw new Exception("Web socket authorizing class cannot be found in the deployment.yaml file.");
                    }
                    authoringClassName = (String)webSocketConfigJSON.get(WEB_SOCKET_AUTHORIZING_CLASS_CONFIG_HEADER);
                } else {
                    authoringClassName = DEFAULT_WEBSOCKET_AUTHORIZING_CLASS;
                }
                if (DataProviderValueHolder.getDataProviderHelper() == null || DataProviderValueHolder.getDataProviderHelper().getDataProviderAuthorizer(authoringClassName) == null) {
                    throw new Exception("Cannot find the Data Provider Authorizer class for the given class name: " + authoringClassName + ".");
                }
                DataProviderAuthorizer dataProviderAuthorizer = DataProviderValueHolder.getDataProviderHelper().getDataProviderAuthorizer(authoringClassName);
                boolean authorizerResult = dataProviderAuthorizer.authorize(dataProviderConfigRoot, usernameMap.get(webSocketConnection.getChannelId()));
                if (!authorizerResult) {
                    throw new Exception("Access denied to data provider.");
                }
            }
            catch (Exception e) {
                try {
                    DataProviderEndPoint.sendText(webSocketConnection.getChannelId(), e.getMessage());
                }
                catch (IOException dataProviderAuthorizer) {
                    // empty catch block
                }
                LOGGER.error("Error occurred while authorizing the access to data provider. " + dataProviderConfigRoot.getProviderName() + ". " + e.getMessage(), (Throwable)e);
                this.onError(e);
                return;
            }
            try {
                if (dataProviderConfigRoot.getAction().equalsIgnoreCase(DataProviderConfigRoot.Types.SUBSCRIBE.toString())) {
                    SiddhiProvider siddhiProvider;
                    DataProviderValueHolder.getDataProviderHelper().removeTopicIfExist(webSocketConnection.getChannelId(), dataProviderConfigRoot.getTopic());
                    DataProvider dataProvider = DataProviderValueHolder.getDataProviderHelper().getDataProvider(dataProviderConfigRoot.getProviderName());
                    dataProvider.init(dataProviderConfigRoot.getTopic(), webSocketConnection.getChannelId(), dataProviderConfigRoot.getDataProviderConfiguration()).start();
                    DataProviderValueHolder.getDataProviderHelper().addDataProviderToSessionMap(webSocketConnection.getChannelId(), dataProviderConfigRoot.getTopic(), dataProvider);
                    if (dataProvider instanceof SiddhiProvider && (siddhiProvider = (SiddhiProvider)dataProvider).getSiddhiDataProviderConfig().isPaginationEnabled()) {
                        siddhiProvider.publishWithPagination(dataProviderConfigRoot.getDataProviderConfiguration(), dataProviderConfigRoot.getTopic(), webSocketConnection.getChannelId());
                    }
                    break block24;
                }
                if (dataProviderConfigRoot.getAction().equalsIgnoreCase(DataProviderConfigRoot.Types.UNSUBSCRIBE.toString())) {
                    DataProviderValueHolder.getDataProviderHelper().removeTopicIfExist(webSocketConnection.getChannelId(), dataProviderConfigRoot.getTopic());
                    break block24;
                }
                if (dataProviderConfigRoot.getAction().equalsIgnoreCase(DataProviderConfigRoot.Types.POLLING.toString())) {
                    Map<String, DataProvider> topicDataProviderMap = DataProviderValueHolder.getDataProviderHelper().getTopicDataProviderMap(webSocketConnection.getChannelId());
                    if (topicDataProviderMap != null) {
                        DataProvider dataProvider = topicDataProviderMap.get(dataProviderConfigRoot.getTopic());
                        if (dataProvider == null) {
                            throw new Exception("Error while performing action: " + dataProviderConfigRoot.getAction() + ", data provider for session id: " + webSocketConnection.getChannelId() + " not found.");
                        }
                        if (dataProvider instanceof SiddhiProvider) {
                            SiddhiProvider siddhiProvider = (SiddhiProvider)dataProvider;
                            if (siddhiProvider.getSiddhiDataProviderConfig().isPaginationEnabled()) {
                                siddhiProvider.publishWithPagination(dataProviderConfigRoot.getDataProviderConfiguration(), dataProviderConfigRoot.getTopic(), webSocketConnection.getChannelId());
                            } else {
                                siddhiProvider.publish(dataProviderConfigRoot.getTopic(), webSocketConnection.getChannelId());
                            }
                        } else {
                            AbstractDataProvider abstractDataProvider = (AbstractDataProvider)dataProvider;
                            abstractDataProvider.publish(dataProviderConfigRoot.getTopic(), webSocketConnection.getChannelId());
                        }
                        break block24;
                    }
                    throw new Exception("Error while performing action: " + dataProviderConfigRoot.getAction() + ", data provider map for session id: " + webSocketConnection.getChannelId() + " not initialized.");
                }
                throw new Exception("Invalid action " + dataProviderConfigRoot.getAction() + " given in the message.Valid actions are : " + Arrays.toString((Object[])DataProviderConfigRoot.Types.values()));
            }
            catch (Exception e) {
                try {
                    DataProviderEndPoint.sendText(webSocketConnection.getChannelId(), e.getMessage());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOGGER.error("Error initializing the data provider endpoint for source type " + dataProviderConfigRoot.getProviderName() + ". " + e.getMessage(), (Throwable)e);
                this.onError(e);
            }
        }
    }

    @OnClose
    public void onClose(WebSocketConnection webSocketConnection) {
        Map<String, DataProvider> dataProviderMap = DataProviderValueHolder.getDataProviderHelper().getTopicDataProviderMap(webSocketConnection.getChannelId());
        if (dataProviderMap != null) {
            for (String topic : dataProviderMap.keySet()) {
                DataProviderValueHolder.getDataProviderHelper().removeTopicIfExist(webSocketConnection.getChannelId(), topic);
            }
        }
        DataProviderValueHolder.getDataProviderHelper().removeSessionData(webSocketConnection.getChannelId());
        usernameMap.remove(webSocketConnection.getChannelId());
    }

    @OnError
    public void onError(Throwable throwable) {
        LOGGER.error("Error found in method : " + throwable.toString());
    }

    public static void sendText(String sessionId, String text) throws IOException {
        if (sessionMap.containsKey(sessionId) && sessionMap.get(sessionId) != null) {
            sessionMap.get(sessionId).pushText(text);
        }
    }
}

