/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.ProviderConfig;
import org.wso2.carbon.data.provider.bean.DataModel;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.endpoint.DataProviderEndPoint;
import org.wso2.carbon.data.provider.exception.DataProviderException;

public abstract class AbstractDataProvider
implements DataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataProvider.class);
    private String topic;
    private String sessionId;
    private ScheduledExecutorService dataPublishingExecutorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService dataPurgingExecutorService = Executors.newSingleThreadScheduledExecutor();
    private long publishingInterval;
    private long purgingInterval;
    private boolean isPurgingEnable;
    private boolean isPaginationEnabled;

    public DataProvider init(String topic, String sessionId, ProviderConfig providerConfig) throws DataProviderException {
        if (this.configValidator(providerConfig)) {
            this.topic = topic;
            this.sessionId = sessionId;
            this.publishingInterval = providerConfig.getPublishingInterval();
            this.purgingInterval = providerConfig.getPurgingInterval();
            this.isPurgingEnable = providerConfig.isPurgingEnable();
            this.isPaginationEnabled = providerConfig.isPaginationEnabled();
            this.setProviderConfig(providerConfig);
            return this;
        }
        throw new DataProviderException("Invalid configuration provided. Unable to complete initialization of data provider.");
    }

    @Override
    public void stop() {
        this.dataPublishingExecutorService.shutdown();
        this.dataPurgingExecutorService.shutdown();
    }

    @Override
    public void start() {
        if (!this.isPaginationEnabled) {
            this.dataPublishingExecutorService.scheduleAtFixedRate(() -> this.publish(this.topic, this.sessionId), 0L, this.publishingInterval, TimeUnit.SECONDS);
        }
        if (this.isPurgingEnable) {
            this.dataPublishingExecutorService.scheduleAtFixedRate(() -> this.purging(), 0L, this.purgingInterval, TimeUnit.SECONDS);
        }
    }

    public void publishToEndPoint(ArrayList<Object[]> data, String sessionId, String topic) {
        DataModel dataModel = new DataModel(this.getMetadata(), (Object[][])data.toArray((T[])new Object[0][0]), -1, topic);
        try {
            DataProviderEndPoint.sendText(sessionId, new Gson().toJson((Object)dataModel));
        }
        catch (IOException e) {
            LOGGER.error("Failed to deliver message to client " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public abstract boolean configValidator(ProviderConfig var1) throws DataProviderException;

    public abstract void publish(String var1, String var2);

    public abstract void purging();

    public abstract void setProviderConfig(ProviderConfig var1);

    public abstract DataSetMetadata getMetadata();
}

