/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.auth.rest.api.impl;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.auth.rest.api.LogoutApiService;
import org.wso2.carbon.analytics.auth.rest.api.NotFoundException;
import org.wso2.carbon.analytics.auth.rest.api.dto.ErrorDTO;
import org.wso2.carbon.analytics.auth.rest.api.internal.DataHolder;
import org.wso2.carbon.analytics.auth.rest.api.internal.ServiceComponent;
import org.wso2.carbon.analytics.auth.rest.api.util.AuthUtil;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.msf4j.Request;

public class LogoutApiServiceImpl
extends LogoutApiService {
    private static final Logger LOG = LoggerFactory.getLogger(LogoutApiServiceImpl.class);

    @Reference(service=ServiceComponent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterServiceComponet")
    public void registerServiceComponet(ServiceComponent serviceComponent) {
        LOG.debug("@Reference(bind) ServiceComponent which sets IdP Client");
    }

    public void unRegisterServiceComponet(ServiceComponent serviceComponent) {
        LOG.debug("@Reference(bind) ServiceComponent which sets IdP Client was removed");
    }

    @Activate
    protected void start(BundleContext bundleContext) {
        LOG.debug("Logout API started");
    }

    @Deactivate
    protected void stop() {
        LOG.debug("Logout API stopped");
    }

    @Override
    public Response logoutAppNamePost(String appName, Request request) throws NotFoundException {
        String trimmedAppName = appName.split("/\\|?")[0];
        String appContext = "/" + trimmedAppName;
        String accessToken = AuthUtil.extractTokenFromHeaders(request.getHeaders(), "JID");
        if (accessToken != null) {
            try {
                HashMap<String, String> logoutProperties = new HashMap<String, String>();
                logoutProperties.put("App_Name", trimmedAppName);
                logoutProperties.put("Access_Token", accessToken);
                logoutProperties.put("Domain", AuthUtil.getDomainFromHeader(request));
                DataHolder.getInstance().getIdPClient().logout(logoutProperties);
                NewCookie appContextCookie = AuthUtil.cookieBuilder("HID", "", appContext, true, true, 0);
                NewCookie logoutContextAccessToken = AuthUtil.cookieBuilder("JID", "", "/logout" + appContext, true, true, 0);
                NewCookie loginContextRefreshToken = AuthUtil.cookieBuilder("ASID", "", "/login" + appContext, true, true, 0);
                return Response.ok().cookie(new NewCookie[]{appContextCookie, logoutContextAccessToken, loginContextRefreshToken}).build();
            }
            catch (IdPClientException e) {
                LOG.debug("Error in logout for uri '{}', with token, '{}'.", new Object[]{appName, accessToken, e});
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Internal_Server_Error");
                errorDTO.setDescription("Error in logout for uri '" + appName + "', with token, '" + accessToken + "'. Error : '" + e.getMessage() + "'");
                return Response.serverError().entity((Object)errorDTO).build();
            }
        }
        LOG.debug("Unable to extract the access token from the request uri '{}'.", (Object)appName);
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setError("Internal_Server_Error");
        errorDTO.setDescription("Invalid Authorization header. Please provide the Authorization header to proceed.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
    }

    @Override
    public Response ssoLogout(String appName, Request request) throws NotFoundException {
        String accessToken = AuthUtil.extractTokenFromHeaders(request.getHeaders(), "JID");
        String idToken = AuthUtil.extractIdTokenFromHeaders(request.getHeaders(), "FID");
        if (idToken != null || accessToken != null) {
            try {
                HashMap<String, String> logoutProperties = new HashMap<String, String>();
                logoutProperties.put("App_Name", appName);
                logoutProperties.put("Access_Token", accessToken);
                logoutProperties.put("ID_Token", idToken);
                logoutProperties.put("Domain", AuthUtil.getDomainFromHeader(request));
                Map returnProperties = DataHolder.getInstance().getIdPClient().logout(logoutProperties);
                boolean doReturnProperties = Boolean.parseBoolean((String)returnProperties.get("returnLogoutProperties"));
                if (!doReturnProperties) {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                returnProperties.remove("returnLogoutProperties");
                return Response.status((Response.Status)Response.Status.OK).entity((Object)returnProperties).build();
            }
            catch (IdPClientException e) {
                LOG.debug("Error in logout for uri '{}', with access token, '{}', id_token, '{}'.", new Object[]{"/slo", accessToken, idToken, e});
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Internal_Server_Error");
                errorDTO.setDescription("Error in logout for uri 'sso', with token, '" + accessToken + "'. Error : '" + e.getMessage() + "'");
                return Response.serverError().entity((Object)errorDTO).build();
            }
        }
        LOG.debug("Unable to extract the id/access token from the request uri '{}'.", (Object)request.getUri());
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setError("Internal_Server_Error");
        errorDTO.setDescription("Invalid Authorization header. Please provide the Authorization header to proceed.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
    }
}

