/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.database.query.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.database.query.manager.config.Queries;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;

public class QueryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryProvider.class);
    private static final String DEFAULT_TYPE = "default";

    public static Map<String, String> mergeMapping(String databaseType, String databaseVersion, List<Queries> componentQueries, List<Queries> deploymentQueries) throws QueryMappingNotAvailableException {
        String queriesVersion;
        String queriesType;
        Set<Object> defaultConfigSet = new HashSet();
        Map<Object, Object> deploymentConfigMap = new HashMap();
        Map<Object, Object> componentConfigMap = new HashMap();
        HashMap<String, String> result = new HashMap<String, String>();
        if (deploymentQueries != null) {
            for (Queries queries : deploymentQueries) {
                queriesType = queries.getType();
                queriesVersion = queries.getVersion();
                if (!queriesType.equalsIgnoreCase(databaseType) && !queriesType.equalsIgnoreCase(DEFAULT_TYPE) || !queriesVersion.equalsIgnoreCase(databaseVersion) && !queriesVersion.equalsIgnoreCase(DEFAULT_TYPE)) continue;
                deploymentConfigMap = queries.getMappings();
                break;
            }
        }
        if (componentQueries != null) {
            for (Queries queries : componentQueries) {
                queriesType = queries.getType();
                queriesVersion = queries.getVersion();
                if (queriesType.equalsIgnoreCase(DEFAULT_TYPE)) {
                    defaultConfigSet = queries.getMappings().keySet();
                    continue;
                }
                if (!queriesType.equalsIgnoreCase(databaseType) || !queriesVersion.equalsIgnoreCase(databaseVersion) && !queriesVersion.equalsIgnoreCase(DEFAULT_TYPE)) continue;
                componentConfigMap = queries.getMappings();
                break;
            }
        } else {
            throw new QueryMappingNotAvailableException("Component configuration array list is null.");
        }
        if (!defaultConfigSet.isEmpty()) {
            for (String defaultEntry : defaultConfigSet) {
                String value;
                if (deploymentConfigMap != null && !deploymentConfigMap.isEmpty() && deploymentConfigMap.containsKey(defaultEntry)) {
                    value = (String)deploymentConfigMap.get(defaultEntry);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Override the query : '" + QueryProvider.removeCRLFCharacters(defaultEntry) + "' with deployment config value: '" + QueryProvider.removeCRLFCharacters(value) + "'  for database type: '" + QueryProvider.removeCRLFCharacters(databaseType) + "' and version '" + QueryProvider.removeCRLFCharacters(String.valueOf(databaseVersion)) + "'.");
                    }
                } else if (componentConfigMap != null && !componentConfigMap.isEmpty() && componentConfigMap.containsKey(defaultEntry)) {
                    value = (String)componentConfigMap.get(defaultEntry);
                } else {
                    throw new QueryMappingNotAvailableException("Mapping value for query: '" + defaultEntry + "' not found in Deployment config Map and Component config Map for database type: '" + databaseType + "' and version '" + databaseVersion + "'.");
                }
                result.put(defaultEntry, value);
            }
            return result;
        }
        throw new QueryMappingNotAvailableException("Default configuration map is null or empty.");
    }

    private static String removeCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }
}

