/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.local;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.AuthenticationException;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.models.Role;
import org.wso2.carbon.analytics.idp.client.core.models.User;
import org.wso2.carbon.analytics.idp.client.local.models.LocalSession;
import org.wso2.carbon.analytics.idp.client.local.models.LocalUser;

public class LocalIdPClient
implements IdPClient {
    private static final Logger LOG = LoggerFactory.getLogger(LocalIdPClient.class);
    private Map<Integer, LocalSession> usersToSessionMap;
    private Map<String, LocalSession> sessionIdSessionMap;
    private Map<String, LocalSession> refreshIdSessionMap;
    private int sessionTimeout;
    private int refreshTimeout;
    private List<LocalUser> usersList;
    private Role adminRole;
    private List<Role> rolesList;

    public LocalIdPClient(int sessionTimeOut, int refreshTimeout, List<LocalUser> users, List<Role> roles, Role adminRole) {
        this.sessionTimeout = sessionTimeOut;
        this.refreshTimeout = refreshTimeout;
        this.adminRole = adminRole;
        this.rolesList = roles;
        this.usersList = users;
        this.usersToSessionMap = new HashMap<Integer, LocalSession>();
        this.sessionIdSessionMap = new HashMap<String, LocalSession>();
        this.refreshIdSessionMap = new HashMap<String, LocalSession>();
    }

    @Override
    public List<Role> getAllRoles() {
        return this.rolesList;
    }

    @Override
    public List<Role> getAllRolesOfTenant(String username) throws IdPClientException {
        return this.getAllRoles();
    }

    @Override
    public Role getAdminRole() {
        return this.adminRole;
    }

    @Override
    public User getUser(String name) {
        LocalUser user = this.getUserFromUsersList(name);
        if (user != null) {
            return new User(user.getUsername(), user.getProperties(), user.getRoles());
        }
        return null;
    }

    @Override
    public List<Role> getUserRoles(String name) {
        LocalUser user = this.getUserFromUsersList(name);
        if (user != null) {
            return user.getRoles();
        }
        LOG.debug("User with username '{}' is not present when retrieving user roles.", (Object)name);
        return new ArrayList<Role>();
    }

    @Override
    public Map<String, String> login(Map<String, String> properties) {
        String grantType;
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        switch (grantType = properties.getOrDefault("Grant_Type", "password")) {
            case "password": {
                String userName = properties.get("Username");
                String password = properties.get("Password");
                String appId = properties.getOrDefault("App_Id", "");
                int userValue = (userName + ":" + password + ":" + appId).hashCode();
                if (userName != null & password != null) {
                    LocalSession oldSession = this.usersToSessionMap.get(userValue);
                    if (oldSession != null) {
                        ZonedDateTime createdAt = ZonedDateTime.now();
                        oldSession.setExpiryTime(createdAt.plusSeconds(this.sessionTimeout));
                        oldSession.setRefreshExpiryTime(createdAt.plusSeconds(this.refreshTimeout));
                        this.usersToSessionMap.replace(userValue, oldSession);
                        this.sessionIdSessionMap.replace(oldSession.getSessionId().toString(), oldSession);
                        this.refreshIdSessionMap.replace(oldSession.getRefreshId().toString(), oldSession);
                        LOG.debug("User '{}' session is extended.", (Object)userName);
                        returnProperties.put("Status", "success");
                        returnProperties.put("Username", userName);
                        returnProperties.put("Access_Token", oldSession.getSessionId().toString());
                        returnProperties.put("Refresh_Token", oldSession.getRefreshId().toString());
                        returnProperties.put("Validity_Period", String.valueOf(this.sessionTimeout));
                        returnProperties.put("Refresh_Validity_Period", String.valueOf(this.refreshTimeout));
                        return returnProperties;
                    }
                } else {
                    String errorMessage = "The login credential used for login are invalid, username : '" + userName + "'.";
                    LOG.debug(errorMessage);
                    returnProperties.put("Status", "failure");
                    returnProperties.put("Error", "Invalid_Credentials");
                    returnProperties.put("Error_Description", errorMessage);
                    return returnProperties;
                }
                LocalUser user = this.getUserFromUsersList(userName);
                if (user != null) {
                    CharBuffer charBuffer = CharBuffer.wrap(user.getPassword());
                    ByteBuffer byteBuffer = Base64.getDecoder().decode(Charset.forName("UTF-8").encode(charBuffer));
                    byte[] plainUserPassword = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                    Arrays.fill(charBuffer.array(), '\u0000');
                    Arrays.fill(byteBuffer.array(), (byte)0);
                    if (!Arrays.equals(plainUserPassword, password.getBytes(Charset.forName("UTF-8")))) {
                        LOG.debug("Password did not match with the configured user, userName: '{}', Failing the authentication.", (Object)userName);
                        returnProperties.put("Status", "failure");
                        returnProperties.put("Error", "Invalid_Credentials");
                        returnProperties.put("Error_Description", "The login credential used for login are invalid, username : '" + userName + "'.");
                        return returnProperties;
                    }
                    ZonedDateTime createdAt = ZonedDateTime.now();
                    LocalSession session = new LocalSession(userValue, userName, createdAt.plusSeconds(this.sessionTimeout), createdAt.plusSeconds(this.refreshTimeout));
                    returnProperties.put("Validity_Period", String.valueOf(this.sessionTimeout));
                    returnProperties.put("Refresh_Validity_Period", String.valueOf(this.refreshTimeout));
                    this.usersToSessionMap.put(userValue, session);
                    this.sessionIdSessionMap.put(session.getSessionId().toString(), session);
                    this.refreshIdSessionMap.put(session.getRefreshId().toString(), session);
                    LOG.debug("User '{}' is logged in.", (Object)userName);
                    returnProperties.put("Status", "success");
                    returnProperties.put("Username", userName);
                    returnProperties.put("Access_Token", session.getSessionId().toString());
                    returnProperties.put("Refresh_Token", session.getRefreshId().toString());
                    returnProperties.put("Validity_Period", String.valueOf(this.sessionTimeout));
                    return returnProperties;
                }
                LOG.debug("User not found for userName: '{}'. Failing the authentication.", (Object)userName);
                returnProperties.put("Status", "failure");
                returnProperties.put("Error", "Invalid_Credentials");
                returnProperties.put("Error_Description", "The login credential used for login are invalid, username : '" + userName + "'.");
                return returnProperties;
            }
            case "refresh_token": {
                String refreshId = properties.get("Refresh_Token");
                LocalSession refreshSession = this.refreshIdSessionMap.remove(refreshId);
                if (refreshSession != null) {
                    this.usersToSessionMap.remove(refreshSession.getUserHash());
                    this.sessionIdSessionMap.remove(refreshSession.getSessionId().toString());
                    if (refreshSession.getRefreshExpiryTime().isAfter(ZonedDateTime.now())) {
                        ZonedDateTime refreshedAt = ZonedDateTime.now();
                        refreshSession.setSessionId(UUID.randomUUID());
                        refreshSession.setExpiryTime(refreshedAt.plusSeconds(this.sessionTimeout));
                        refreshSession.setRefreshId(UUID.randomUUID());
                        refreshSession.setRefreshExpiryTime(refreshedAt.plusSeconds(this.refreshTimeout));
                        this.usersToSessionMap.put(refreshSession.getUserHash(), refreshSession);
                        this.sessionIdSessionMap.put(refreshSession.getSessionId().toString(), refreshSession);
                        this.refreshIdSessionMap.put(refreshSession.getRefreshId().toString(), refreshSession);
                        LOG.debug("User '{}' session is refreshed.", (Object)refreshSession.getUsername());
                        returnProperties.put("Status", "success");
                        returnProperties.put("Username", refreshSession.getUsername());
                        returnProperties.put("Access_Token", refreshSession.getSessionId().toString());
                        returnProperties.put("Refresh_Token", refreshSession.getRefreshId().toString());
                        returnProperties.put("Validity_Period", String.valueOf(this.sessionTimeout));
                        return returnProperties;
                    }
                    String errorMessage = "The refresh token used for login is expired, Refresh token : '" + refreshId + "'.";
                    LOG.debug(errorMessage);
                    returnProperties.put("Status", "failure");
                    returnProperties.put("Error", "Invalid_Credentials");
                    returnProperties.put("Error_Description", errorMessage);
                    return returnProperties;
                }
                String errorMessage = "The refresh token used for login are invalid, Refresh token : '" + refreshId + "'.";
                LOG.debug(errorMessage);
                returnProperties.put("Status", "failure");
                returnProperties.put("Error", "Invalid_Credentials");
                returnProperties.put("Error_Description", errorMessage);
                return returnProperties;
            }
        }
        String errorMessage = "The Grant Type '" + grantType + "' is notsupported by the IdPClient '" + LocalIdPClient.class.getName();
        LOG.debug(errorMessage);
        returnProperties.put("Status", "failure");
        returnProperties.put("Error", "Grant_Type_Not_Supported");
        returnProperties.put("Error_Description", errorMessage);
        return returnProperties;
    }

    @Override
    public Map<String, String> logout(Map<String, String> properties) {
        String token = properties.get("Access_Token");
        LocalSession session = this.sessionIdSessionMap.get(token);
        if (session != null) {
            this.usersToSessionMap.remove(session.getUserHash());
            this.sessionIdSessionMap.remove(token);
        }
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        returnProperties.put("returnLogoutProperties", "false");
        return returnProperties;
    }

    @Override
    public String authenticate(String token) throws AuthenticationException {
        LocalSession session = this.sessionIdSessionMap.get(token);
        if (session == null) {
            throw new AuthenticationException("The session with id '" + token + "' is not valid.");
        }
        ZonedDateTime now = ZonedDateTime.now();
        if (session.getExpiryTime().isAfter(now)) {
            return session.getUsername();
        }
        this.usersToSessionMap.remove(session.getUserHash());
        this.sessionIdSessionMap.remove(session.getSessionId().toString());
        if (session.getRefreshExpiryTime().isAfter(now)) {
            this.refreshIdSessionMap.remove(session.getRefreshId().toString());
        }
        throw new AuthenticationException("The session with id '" + token + "' has expired.");
    }

    private LocalUser getUserFromUsersList(String name) {
        return this.usersList.stream().filter(user -> user.getUsername().equals(name)).findFirst().orElse(null);
    }
}

