/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.external.util;

import feign.codec.EncodeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.analytics.idp.client.core.utils.config.IdPClientConfiguration;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.database.query.manager.QueryProvider;
import org.wso2.carbon.database.query.manager.config.Queries;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class ExternalIdPClientUtil {
    private static final Logger log = LogManager.getLogger(ExternalIdPClientUtil.class);
    private static final IdPClientConfiguration idPClientConfiguration = ExternalIdPClientUtil.getIdPClientConfiguration();

    public static Map<String, String> getQueries(String databaseType, String databaseVersion, List<Queries> deploymentQueries) throws QueryMappingNotAvailableException, IOException {
        try {
            URL url = ExternalIdPClientUtil.class.getClassLoader().getResource("queries.yaml");
            if (url == null) {
                throw new RuntimeException("Unable to load queries.yaml file.");
            }
            IdPClientConfiguration idPClientConfiguration = ExternalIdPClientUtil.readYamlContent(url.openStream());
            ArrayList<Queries> componentQueries = idPClientConfiguration.getQueries();
            return QueryProvider.mergeMapping(databaseType, databaseVersion, componentQueries, deploymentQueries);
        }
        catch (QueryMappingNotAvailableException e) {
            throw new QueryMappingNotAvailableException("Unable to load queries.", e);
        }
        catch (IOException e) {
            throw new IOException("Unable to load content from queries.yaml file.", e);
        }
    }

    private static IdPClientConfiguration readYamlContent(InputStream yamlContent) {
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(IdPClientConfiguration.class, IdPClientConfiguration.class.getClassLoader()));
        yaml.setBeanAccess(BeanAccess.FIELD);
        return (IdPClientConfiguration)yaml.loadAs(yamlContent, IdPClientConfiguration.class);
    }

    public static String getRequestBody(Map<String, String> params) {
        return params.entrySet().stream().map(ExternalIdPClientUtil::urlEncodeKeyValuePair).collect(Collectors.joining("&"));
    }

    public static String getClientConfigurationProperty(String key) {
        return idPClientConfiguration.getProperties().get(key);
    }

    private static IdPClientConfiguration getIdPClientConfiguration() {
        IdPClientConfiguration idPClientConfiguration;
        BundleContext bundleContext = FrameworkUtil.getBundle(ConfigProvider.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigProvider.class.getName());
        ConfigProvider configProvider = (ConfigProvider)bundleContext.getService(serviceReference);
        try {
            idPClientConfiguration = configProvider.getConfigurationObject("auth.configs") == null ? new IdPClientConfiguration() : (IdPClientConfiguration)configProvider.getConfigurationObject(IdPClientConfiguration.class);
        }
        catch (ConfigurationException e) {
            log.error("Error in reading 'auth.configs' from file.", (Throwable)e);
            return null;
        }
        return idPClientConfiguration;
    }

    private static String urlEncodeKeyValuePair(Map.Entry<String, String> entry) {
        try {
            return URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.toString()) + '=' + URLEncoder.encode(String.valueOf(entry.getValue()), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodeException("Error occurred while URL encoding message", ex);
        }
    }
}

