/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.external.impl;

import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.analytics.idp.client.core.api.AnalyticsHttpClientBuilderService;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.external.util.ExternalIdPClientUtil;

public class OAuth2ServiceStubs {
    private AnalyticsHttpClientBuilderService analyticsHttpClientBuilderService;
    private String tokenEndpoint;
    private String revokeEndpoint;
    private String introspectEndpoint;
    private String username;
    private String password;
    private int connectionTimeout;
    private int readTimeout;

    public OAuth2ServiceStubs(AnalyticsHttpClientBuilderService service, String tokenEndpoint, String revokeEndpoint, String introspectEndpoint, String username, String password, int connectionTimeout, int readTimeout) {
        this.analyticsHttpClientBuilderService = service;
        this.tokenEndpoint = tokenEndpoint;
        this.revokeEndpoint = revokeEndpoint;
        this.introspectEndpoint = introspectEndpoint;
        this.username = username;
        this.password = password;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public TokenServiceStub getTokenServiceStub() throws IdPClientException {
        return this.analyticsHttpClientBuilderService.buildWithoutInterceptor(this.connectionTimeout, this.readTimeout, TokenServiceStub.class, this.tokenEndpoint);
    }

    public RevokeServiceStub getRevokeServiceStub() throws IdPClientException {
        return this.analyticsHttpClientBuilderService.buildWithoutInterceptor(this.connectionTimeout, this.readTimeout, RevokeServiceStub.class, this.revokeEndpoint);
    }

    public IntrospectionServiceStub getIntrospectionServiceStub() throws IdPClientException {
        return this.analyticsHttpClientBuilderService.build(this.username, this.password, this.connectionTimeout, this.readTimeout, IntrospectionServiceStub.class, this.introspectEndpoint);
    }

    public boolean isIntrospectAvailable() {
        return this.introspectEndpoint != null;
    }

    @Headers(value={"Content-Type: application/x-www-form-urlencoded"})
    public static interface IntrospectionServiceStub {
        @RequestLine(value="POST")
        public Response introspectToken(String var1);

        default public Response introspectAccessToken(String token) {
            Map<String, String> requestParam = Collections.singletonMap("token", token);
            return this.introspectToken(ExternalIdPClientUtil.getRequestBody(requestParam));
        }
    }

    @Headers(value={"Content-Type: application/x-www-form-urlencoded"})
    public static interface RevokeServiceStub {
        @RequestLine(value="POST")
        @Headers(value={"Authorization: Basic {auth_token}"})
        public Response revokeToken(@Param(value="auth_token") String var1, String var2);

        default public Response revokeAccessToken(String token, String clientId, String clientSecret) {
            String credentials = clientId + ':' + clientSecret;
            String authToken = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            Map<String, String> requestParam = Collections.singletonMap("token", token);
            return this.revokeToken(authToken, ExternalIdPClientUtil.getRequestBody(requestParam));
        }
    }

    @Headers(value={"Content-Type: application/x-www-form-urlencoded"})
    public static interface TokenServiceStub {
        @Headers(value={"Authorization: Basic {auth_token}"})
        @RequestLine(value="POST")
        public Response generateAccessToken(@Param(value="auth_token") String var1, String var2);

        default public Response generatePasswordGrantAccessToken(String username, String password, String clientId, String clientSecret) {
            String credentials = clientId + ':' + clientSecret;
            String authToken = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("grant_type", "password");
            requestParam.put("username", username);
            requestParam.put("password", password);
            return this.generateAccessToken(authToken, ExternalIdPClientUtil.getRequestBody(requestParam));
        }

        default public Response generateAuthCodeGrantAccessToken(String code, String redirectUri, String scopes, String clientId, String clientSecret) {
            String credentials = clientId + ':' + clientSecret;
            String authToken = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            code = code.split("&")[0];
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("grant_type", "authorization_code");
            requestParam.put("code", code);
            requestParam.put("redirect_uri", redirectUri);
            requestParam.put("scope", scopes);
            return this.generateAccessToken(authToken, ExternalIdPClientUtil.getRequestBody(requestParam));
        }

        default public Response generateRefreshGrantAccessToken(String refreshToken, String clientId, String clientSecret) {
            String credentials = clientId + ':' + clientSecret;
            String authToken = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("grant_type", "refresh_token");
            requestParam.put("refresh_token", refreshToken);
            return this.generateAccessToken(authToken, ExternalIdPClientUtil.getRequestBody(requestParam));
        }
    }
}

