/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.external.dao;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.external.models.OAuthApplicationInfo;
import org.wso2.carbon.analytics.idp.client.external.util.ExternalIdPClientUtil;
import org.wso2.carbon.database.query.manager.config.Queries;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.secvault.SecretRepository;
import org.wso2.carbon.secvault.exception.SecureVaultException;

public class OAuthAppDAO {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAppDAO.class);
    private SecretRepository secretRepository;
    private DataSourceService dataSourceService;
    private DataSource dataSource;
    private String databaseName;
    private List<Queries> deploymentQueries;
    private Map<String, String> queries;

    public OAuthAppDAO(DataSourceService dataSourceService, String databaseName, List<Queries> deploymentQueries, SecretRepository secretRepository) {
        this.dataSourceService = dataSourceService;
        this.databaseName = databaseName;
        this.deploymentQueries = deploymentQueries;
        this.secretRepository = secretRepository;
    }

    private static void closeConnection(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOG.warn("Error closing database connection", (Throwable)e);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                LOG.warn("Error closing prepared statement.", (Throwable)e);
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOG.warn("Error closing result set.", (Throwable)e);
            }
        }
    }

    public void init() throws IdPClientException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData databaseMetaData = conn.getMetaData();
            this.queries = ExternalIdPClientUtil.getQueries(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), this.deploymentQueries);
        }
        catch (IOException | SQLException | QueryMappingNotAvailableException e) {
            throw new IdPClientException("Error initializing connection.", e);
        }
        finally {
            OAuthAppDAO.closeConnection(conn, null, null);
        }
    }

    public void createTable() throws IdPClientException {
        String createTableQuery = this.getQuery("CREATE_OAUTH_APP_TABLE");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(createTableQuery);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing query: " + createTableQuery);
            }
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                throw new IdPClientException("Unable to create table . [Query=" + createTableQuery + "]", e);
            }
            catch (Throwable throwable) {
                OAuthAppDAO.closeConnection(conn, ps, null);
                throw throwable;
            }
        }
        OAuthAppDAO.closeConnection(conn, ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists() {
        boolean bl;
        Connection conn = null;
        PreparedStatement stmt = null;
        String query = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            query = this.getQuery("OAUTH_APP_TABLE_CHECK");
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            bl = true;
        }
        catch (SQLException | IdPClientException e) {
            boolean bl2;
            try {
                LOG.debug("Table '{}' assumed to not exist since its existence check query {} resulted in exception {}.", new Object[]{"OAUTHAPP", query, e.getMessage()});
                bl2 = false;
            }
            catch (Throwable throwable) {
                OAuthAppDAO.closeConnection(conn, stmt, rs);
                throw throwable;
            }
            OAuthAppDAO.closeConnection(conn, stmt, rs);
            return bl2;
        }
        OAuthAppDAO.closeConnection(conn, stmt, rs);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOAuthApp(OAuthApplicationInfo oAuthApplicationInfo) throws IdPClientException {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = this.getQuery("ADD_OAUTH_APP");
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(query);
            ps.setString(1, oAuthApplicationInfo.getClientName());
            ps.setString(2, oAuthApplicationInfo.getClientId());
            byte[] encrypt = this.secretRepository.encrypt(oAuthApplicationInfo.getClientSecret().getBytes("UTF-8"));
            ps.setBytes(3, encrypt);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing query: " + query);
            }
            ps.executeUpdate();
            conn.commit();
        }
        catch (UnsupportedEncodingException | SecureVaultException e) {
            try {
                throw new IdPClientException("Unable to add OauthApp. [Query=" + query + "]. Encryption failed.", e);
                catch (SQLException e2) {
                    throw new IdPClientException("Unable to add OauthApp. [Query=" + query + "]", e2);
                }
            }
            catch (Throwable throwable) {
                OAuthAppDAO.closeConnection(conn, ps, null);
                throw throwable;
            }
        }
        OAuthAppDAO.closeConnection(conn, ps, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuthApplicationInfo getOAuthApp(String name) throws IdPClientException {
        ResultSet resultSet;
        PreparedStatement ps;
        Connection conn;
        block6: {
            OAuthApplicationInfo oAuthApplicationInfo;
            conn = null;
            ps = null;
            resultSet = null;
            String query = this.getQuery("RETRIEVE_OAUTH_APP");
            try {
                conn = this.getConnection();
                ps = conn.prepareStatement(query);
                ps.setString(1, name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing query: " + query);
                }
                if (!(resultSet = ps.executeQuery()).next()) break block6;
                byte[] clientSecret = resultSet.getBytes("CLIENTSECRET");
                String decrypted = new String(this.secretRepository.decrypt(clientSecret), "UTF-8");
                oAuthApplicationInfo = new OAuthApplicationInfo(name, resultSet.getString("CLIENTID"), decrypted);
            }
            catch (UnsupportedEncodingException | SecureVaultException e) {
                try {
                    throw new IdPClientException("Unable to retrieve OAuthApp. [Query=" + query + "]. Decryption failed.", e);
                    catch (SQLException e2) {
                        throw new IdPClientException("Unable to retrieve OAuthApp. [Query=" + query + "]", e2);
                    }
                }
                catch (Throwable throwable) {
                    OAuthAppDAO.closeConnection(conn, ps, resultSet);
                    throw throwable;
                }
            }
            OAuthAppDAO.closeConnection(conn, ps, resultSet);
            return oAuthApplicationInfo;
        }
        OAuthAppDAO.closeConnection(conn, ps, resultSet);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateOAuthApp(OAuthApplicationInfo oAuthApplicationInfo) throws IdPClientException {
        Connection conn = null;
        PreparedStatement ps = null;
        String query = this.getQuery("UPDATE_OAUTH_APP");
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(query);
            ps.setString(1, oAuthApplicationInfo.getClientId());
            byte[] encrypt = this.secretRepository.encrypt(oAuthApplicationInfo.getClientSecret().getBytes("UTF-8"));
            ps.setBytes(2, encrypt);
            ps.setString(3, oAuthApplicationInfo.getClientName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing query: " + query);
            }
            ps.executeUpdate();
            conn.commit();
        }
        catch (UnsupportedEncodingException | SecureVaultException e) {
            try {
                throw new IdPClientException("Unable to update OauthApp. [Query=" + query + "]. Encryption failed", e);
                catch (SQLException e2) {
                    throw new IdPClientException("Unable to update OauthApp. [Query=" + query + "]", e2);
                }
            }
            catch (Throwable throwable) {
                OAuthAppDAO.closeConnection(conn, ps, null);
                throw throwable;
            }
        }
        OAuthAppDAO.closeConnection(conn, ps, null);
    }

    private DataSource getDataSource() throws IdPClientException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.dataSourceService == null) {
            throw new IdPClientException("Datasource service is null. Cannot retrieve datasource '" + this.databaseName + "'.");
        }
        try {
            this.dataSource = (DataSource)this.dataSourceService.getDataSource(this.databaseName);
        }
        catch (DataSourceException e) {
            throw new IdPClientException("Unable to retrieve the datasource: '" + this.databaseName + "'.", e);
        }
        return this.dataSource;
    }

    private Connection getConnection() throws SQLException, IdPClientException {
        return this.getDataSource().getConnection();
    }

    private String getQuery(String key) {
        if (!this.queries.containsKey(key)) {
            throw new RuntimeException("Unable to find the configuration entry for the key: " + key);
        }
        return this.queries.get(key);
    }
}

