/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.external;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.AnalyticsHttpClientBuilderService;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.spi.IdPClientFactory;
import org.wso2.carbon.analytics.idp.client.core.utils.SSLConfig;
import org.wso2.carbon.analytics.idp.client.core.utils.config.IdPClientConfiguration;
import org.wso2.carbon.analytics.idp.client.core.utils.config.SSLConfiguration;
import org.wso2.carbon.analytics.idp.client.external.ExternalIdPClient;
import org.wso2.carbon.analytics.idp.client.external.dao.OAuthAppDAO;
import org.wso2.carbon.analytics.idp.client.external.impl.DCRMServiceStub;
import org.wso2.carbon.analytics.idp.client.external.impl.OAuth2ServiceStubs;
import org.wso2.carbon.analytics.idp.client.external.impl.SCIM2ServiceStub;
import org.wso2.carbon.analytics.idp.client.external.models.OAuthApplicationInfo;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.secvault.SecretRepository;

@Component(name="org.wso2.carbon.analytics.idp.client.external.ExternalIdPClientFactory", immediate=true)
public class ExternalIdPClientFactory
implements IdPClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIdPClientFactory.class);
    private DataSourceService dataSourceService;
    private SecretRepository secretRepository;
    private AnalyticsHttpClientBuilderService analyticsHttpClientBuilderService;
    private SSLConfig sslConfig;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOG.debug("External IDP client factory activated.");
        if (this.sslConfig != null && this.sslConfig.isSSLConfigsExistInConfigProvider()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Overriding keystore and truststore configurations in carbon.sh with configuration values included in deployment.yaml");
            }
            this.sslConfig.exportSSLConfigsExistInConfigProvider();
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOG.debug("External IDP client factory deactivated.");
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        try {
            SSLConfiguration sslConfiguration = (SSLConfiguration)configProvider.getConfigurationObject(SSLConfiguration.class);
            this.sslConfig = new SSLConfig(sslConfiguration);
        }
        catch (ConfigurationException e) {
            LOG.error("Error occurred while initializing External IDP client factory : " + e.getMessage(), (Throwable)e);
        }
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
    }

    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceService")
    protected void registerDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    protected void unregisterDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = null;
    }

    @Reference(name="org.wso2.carbon.secvault.repository.DefaultSecretRepository", service=SecretRepository.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterSecretRepository")
    protected void registerSecretRepository(SecretRepository secretRepository) {
        this.secretRepository = secretRepository;
    }

    protected void unregisterSecretRepository(SecretRepository secretRepository) {
        this.secretRepository = null;
    }

    @Reference(service=AnalyticsHttpClientBuilderService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterAnalyticsHttpClient")
    protected void registerAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        this.analyticsHttpClientBuilderService = service;
        LOG.debug("@Reference(bind) AnalyticsHttpClientBuilderService at '{}'", (Object)AnalyticsHttpClientBuilderService.class.getName());
    }

    protected void unregisterAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        LOG.debug("@Reference(unbind) AnalyticsHttpClientBuilderService at '{}'", (Object)AnalyticsHttpClientBuilderService.class.getName());
        this.analyticsHttpClientBuilderService = null;
    }

    @Override
    public String getType() {
        return "external";
    }

    @Override
    public IdPClient getIdPClient(IdPClientConfiguration idPClientConfiguration) throws IdPClientException {
        int readTimeout;
        int connectionTimeout;
        int cacheTimeout;
        Map<String, String> properties = idPClientConfiguration.getProperties();
        String dcrEndpoint = properties.getOrDefault("kmDcrUrl", "https://localhost:9443/identity/connect/register");
        String kmUsername = properties.getOrDefault("kmUsername", "admin");
        String kmPassword = properties.getOrDefault("kmPassword", "admin");
        String kmTokenUrl = properties.getOrDefault("kmTokenUrl", "https://localhost:9443/oauth2");
        String dcrAppOwner = properties.getOrDefault("dcrAppOwner", kmUsername);
        String introspectUrl = properties.getOrDefault("introspectionUrl", null);
        String idPBaseUrl = properties.getOrDefault("idpBaseUrl", "https://localhost:9443/scim2");
        String idPUserName = properties.getOrDefault("idpUsername", "admin");
        String idPPassword = properties.getOrDefault("idpPassword", "admin");
        String baseUrl = properties.getOrDefault("baseUrl", "https://localhost:9643");
        String grantType = properties.getOrDefault("grantType", "password");
        String signingAlgo = properties.getOrDefault("oidcUserInfoAlgo", "SHA256withRSA");
        boolean isFilteredGroupsEnabled = Boolean.parseBoolean(properties.getOrDefault("enableFilteredGroups", "false"));
        String portalAppContext = properties.getOrDefault("portalAppContext", "portal");
        String statusAppContext = properties.getOrDefault("statusDashboardAppContext", "monitoring");
        String businessAppContext = properties.getOrDefault("businessRulesAppContext", "business-rules");
        String defaultUserStore = properties.getOrDefault("defaultUserStore", "PRIMARY");
        String scope = properties.getOrDefault("Scope", "openid");
        OAuthApplicationInfo spOAuthApp = new OAuthApplicationInfo("sp", properties.get("spClientId"), properties.get("spClientSecret"));
        OAuthApplicationInfo portalOAuthApp = new OAuthApplicationInfo("sp_portal", properties.get("portalClientId"), properties.get("portalClientSecret"));
        OAuthApplicationInfo statusOAuthApp = new OAuthApplicationInfo("sp_status_dashboard", properties.get("statusDashboardClientId"), properties.get("statusDashboardClientSecret"));
        OAuthApplicationInfo businessOAuthApp = new OAuthApplicationInfo("sp_business_rules", properties.get("businessRulesClientId"), properties.get("businessRulesClientSecret"));
        HashMap<String, OAuthApplicationInfo> oAuthAppInfoMap = new HashMap<String, OAuthApplicationInfo>();
        oAuthAppInfoMap.put("sp", spOAuthApp);
        oAuthAppInfoMap.put(portalAppContext, portalOAuthApp);
        oAuthAppInfoMap.put(statusAppContext, statusOAuthApp);
        oAuthAppInfoMap.put(businessAppContext, businessOAuthApp);
        try {
            cacheTimeout = Integer.parseInt(properties.getOrDefault("cacheTimeout", "900"));
            connectionTimeout = Integer.parseInt(properties.getOrDefault("connectionTimeout", "10000"));
            readTimeout = Integer.parseInt(properties.getOrDefault("readTimeout", "60000"));
        }
        catch (NumberFormatException e) {
            throw new IdPClientException("Cache timeout overriding property '" + properties.get("cacheTimeout") + "' is invalid.");
        }
        String databaseName = properties.getOrDefault("databaseName", "WSO2_OAUTH_APP_DB");
        OAuthAppDAO oAuthAppDAO = new OAuthAppDAO(this.dataSourceService, databaseName, idPClientConfiguration.getQueries(), this.secretRepository);
        DCRMServiceStub dcrmServiceStub = this.analyticsHttpClientBuilderService.build(kmUsername, kmPassword, connectionTimeout, readTimeout, DCRMServiceStub.class, dcrEndpoint);
        OAuth2ServiceStubs keyManagerServiceStubs = new OAuth2ServiceStubs(this.analyticsHttpClientBuilderService, kmTokenUrl + "/token", kmTokenUrl + "/revoke", introspectUrl, kmUsername, kmPassword, connectionTimeout, readTimeout);
        SCIM2ServiceStub scimServiceStub = this.analyticsHttpClientBuilderService.build(idPUserName, idPPassword, connectionTimeout, readTimeout, SCIM2ServiceStub.class, idPBaseUrl);
        String jwksUrl = properties.getOrDefault("jwksUrl", "https://localhost:9443/oauth2/jwks");
        String adminRoleDisplayName = idPClientConfiguration.getUserManager().getAdminRole();
        String targetURIForRedirection = properties.getOrDefault("externalLogoutUrl", "https://localhost:9443/oidc/logout");
        ExternalIdPClient externalIdPClient = !isFilteredGroupsEnabled ? new ExternalIdPClient(baseUrl, kmTokenUrl + "/authorize", grantType, signingAlgo, adminRoleDisplayName, oAuthAppInfoMap, cacheTimeout, oAuthAppDAO, dcrmServiceStub, keyManagerServiceStubs, scimServiceStub, defaultUserStore, idPClientConfiguration.isSsoEnabled(), targetURIForRedirection, scope, jwksUrl) : new ExternalIdPClient(baseUrl, kmTokenUrl + "/authorize", grantType, signingAlgo, adminRoleDisplayName, oAuthAppInfoMap, cacheTimeout, oAuthAppDAO, dcrmServiceStub, keyManagerServiceStubs, scimServiceStub, defaultUserStore, idPClientConfiguration.isSsoEnabled(), targetURIForRedirection, scope, jwksUrl, isFilteredGroupsEnabled);
        externalIdPClient.init(dcrAppOwner);
        return externalIdPClient;
    }
}

