/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.text.TextUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.MapUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class HttpConnectionHelper {
    private static final String TAG = HttpConnectionHelper.class.getSimpleName();

    public static HttpURLConnection createDetectConnection(String url, int connectTimeout, String charset, String requestMethod, Map<String, String> headers) throws Exception {
        RequestParam requestParam = new RequestParam(url, connectTimeout, charset);
        requestParam.setRequestMethod(requestMethod);
        requestParam.setHeaders(headers);
        return HttpConnectionHelper.createHttpUrlConnection(requestParam);
    }

    public static HttpURLConnection createDownloadFileConnection(RequestParam requestParam) throws Exception {
        return HttpConnectionHelper.createHttpUrlConnection(requestParam);
    }

    private static void initTrustSSL(HttpsURLConnection conn) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HttpURLConnection createHttpUrlConnection(RequestParam requestParam) throws Exception {
        if (requestParam == null) {
            return null;
        }
        Log.d(TAG, "headBuffer\uff0ccreateHttpUrlConnection\uff0c\u53d1\u9001\u7684\u8bf7\u6c42\u53c2\u6570\uff1a" + requestParam.toString());
        String encodedUrl = UrlUtil.getASCIIEncodedUrl(requestParam.mUrl, requestParam.mCharset);
        if (TextUtils.isEmpty((CharSequence)encodedUrl)) {
            throw new IllegalAccessException("URL Illegal !");
        }
        HttpURLConnection conn = null;
        URL url = new URL(encodedUrl);
        if (encodedUrl.toLowerCase().startsWith("https")) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
            HttpConnectionHelper.initTrustSSL(httpsConn);
            conn = httpsConn;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setConnectTimeout(requestParam.mConnectTimeout);
        conn.setReadTimeout(requestParam.mConnectTimeout);
        conn.setRequestMethod(requestParam.mRequestMethod);
        conn.setInstanceFollowRedirects(false);
        if (!MapUtil.isEmpty(requestParam.mHeaders)) {
            Set keys = requestParam.mHeaders.keySet();
            Log.i(TAG, "\u81ea\u5b9a\u4e49\u5934\u4fe1\u606f\u5927\u5c0f\uff1a" + keys.size());
            for (String key : keys) {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                String value = (String)requestParam.mHeaders.get(key);
                conn.setRequestProperty(key, value);
                Log.i(TAG, "\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5934\u4fe1\u606f\uff0curl\uff1a" + url + "\uff0ckey\uff1a" + key + "\uff0cvalue\uff1a" + value);
            }
        }
        conn.setRequestProperty("Accept-Encoding", "identity");
        if (!TextUtils.isEmpty((CharSequence)requestParam.mCharset)) {
            conn.setRequestProperty("Charset", requestParam.mCharset);
        }
        if (requestParam.mRangeStartPos > 0L) {
            if (requestParam.mRangeEndPos > 0L && requestParam.mRangeEndPos > requestParam.mRangeStartPos) {
                conn.setRequestProperty("Range", "bytes=" + requestParam.mRangeStartPos + "-" + requestParam.mRangeEndPos);
            } else {
                conn.setRequestProperty("Range", "bytes=" + requestParam.mRangeStartPos + "-");
            }
            if (!TextUtils.isEmpty((CharSequence)requestParam.mETag)) {
                conn.setRequestProperty("If-Range", requestParam.mETag);
            } else if (!TextUtils.isEmpty((CharSequence)requestParam.mLastModified)) {
                conn.setRequestProperty("If-Range", requestParam.mLastModified);
            }
        }
        conn.connect();
        return conn;
    }

    public static long getFileSizeFromResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return -1L;
        }
        long fileSize = HttpConnectionHelper.getFileSizeFromCommonServerResponseHeader(responseHeaderMap);
        if (fileSize <= 0L) {
            fileSize = HttpConnectionHelper.getFileSizeFromPhpServerResponseHeader(responseHeaderMap);
        }
        return fileSize;
    }

    private static long getFileSizeFromCommonServerResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return -1L;
        }
        List<String> contentLengths = responseHeaderMap.get("Content-Length");
        if (CollectionUtil.isEmpty(contentLengths)) {
            return -1L;
        }
        String contentLengthStr = contentLengths.get(0);
        if (!TextUtils.isEmpty((CharSequence)contentLengthStr)) {
            long fileSize = -1L;
            try {
                fileSize = Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return fileSize;
        }
        return -1L;
    }

    private static long getFileSizeFromPhpServerResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return -1L;
        }
        List<String> contentLengths = responseHeaderMap.get("Accept-Length");
        if (CollectionUtil.isEmpty(contentLengths)) {
            return -1L;
        }
        String contentLengthStr = contentLengths.get(0);
        if (!TextUtils.isEmpty((CharSequence)contentLengthStr)) {
            long fileSize = -1L;
            try {
                fileSize = Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return fileSize;
        }
        return -1L;
    }

    public static String getFileNameFromResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return null;
        }
        String fileName = HttpConnectionHelper.getFileNameFromCommonServerResponseHeader(responseHeaderMap);
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            return fileName;
        }
        fileName = HttpConnectionHelper.getFileNameFromPhpServerResponseHeader(responseHeaderMap);
        return fileName;
    }

    private static String getFileNameFromCommonServerResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return null;
        }
        return null;
    }

    private static String getFileNameFromPhpServerResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return null;
        }
        List<String> contentDispositions = responseHeaderMap.get("Content-Disposition");
        if (CollectionUtil.isEmpty(contentDispositions)) {
            return null;
        }
        for (String contentDisposition : contentDispositions) {
            int start;
            if (TextUtils.isEmpty((CharSequence)contentDisposition) || !contentDisposition.contains("filename=") || (start = contentDisposition.lastIndexOf("=")) == -1) continue;
            String fileName = contentDisposition.substring(start + 1, contentDisposition.length());
            return fileName;
        }
        return null;
    }

    public static String getLastModifiedFromResponseHeader(Map<String, List<String>> responseHeaderMap) {
        if (MapUtil.isEmpty(responseHeaderMap)) {
            return null;
        }
        List<String> contentLengths = responseHeaderMap.get("Last-Modified");
        if (CollectionUtil.isEmpty(contentLengths)) {
            return null;
        }
        String lastModified = contentLengths.get(0);
        return lastModified;
    }

    public static String getStringHeaders(Map<String, List<String>> headers) {
        try {
            if (MapUtil.isEmpty(headers)) {
                return null;
            }
            Map<String, ArrayList<String>> copyMap = HttpConnectionHelper.getWritableMap(headers);
            JSONObject jsonObject = new JSONObject(copyMap);
            return jsonObject.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, ArrayList<String>> getWritableMap(Map<String, ? extends List<String>> readOnlyMap) {
        TreeMap<String, ArrayList<String>> readAndWriteMap = new TreeMap<String, ArrayList<String>>();
        Set<String> keys = readOnlyMap.keySet();
        for (String key : keys) {
            if (key == null) continue;
            ArrayList<String> readAndWriteList = new ArrayList<String>();
            List<String> readOnlyValues = readOnlyMap.get(key);
            for (String value : readOnlyValues) {
                readAndWriteList.add(value);
            }
            readAndWriteMap.put(key, readAndWriteList);
        }
        return readAndWriteMap;
    }

    public static class RequestParam {
        private String mUrl;
        private int mConnectTimeout = 15000;
        private String mCharset;
        private long mRangeStartPos = -1L;
        private long mRangeEndPos = -1L;
        private String mETag;
        private String mLastModified;
        private String mRequestMethod = "GET";
        private Map<String, String> mHeaders;

        public RequestParam(String url, int connectTimeout, String charset) {
            this.mUrl = url;
            this.mConnectTimeout = connectTimeout;
            this.mCharset = charset;
        }

        public RequestParam(String url, int connectTimeout, String charset, long rangeStartPos, long rangeEndPos, String ETag, String lastModified) {
            this.mUrl = url;
            this.mConnectTimeout = connectTimeout;
            this.mCharset = charset;
            this.mRangeStartPos = rangeStartPos;
            this.mRangeEndPos = rangeEndPos;
            this.mETag = ETag;
            this.mLastModified = lastModified;
        }

        public void setUrl(String url) {
            this.mUrl = url;
        }

        public void setRequestMethod(String requestMethod) {
            if (TextUtils.isEmpty((CharSequence)requestMethod)) {
                return;
            }
            this.mRequestMethod = requestMethod;
        }

        public void setHeaders(Map<String, String> headers) {
            if (headers == null) {
                return;
            }
            this.mHeaders = headers;
        }

        public String toString() {
            return "RequestParam{mUrl='" + this.mUrl + '\'' + ", mConnectTimeout=" + this.mConnectTimeout + ", mCharset='" + this.mCharset + '\'' + ", mRangeStartPos=" + this.mRangeStartPos + ", mRangeEndPos=" + this.mRangeEndPos + ", mETag='" + this.mETag + '\'' + ", mLastModified='" + this.mLastModified + '\'' + ", mRequestMethod='" + this.mRequestMethod + '\'' + ", mHeaders=" + this.mHeaders + '}';
        }
    }
}

