/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_delete;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.file_delete.DeleteDownloadFileTask;
import org.wlf.filedownloader.file_delete.DownloadFileDeleter;
import org.wlf.filedownloader.file_download.base.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.util.UrlUtil;

class DeleteDownloadFilesTask
implements Runnable,
Stoppable {
    private static final String TAG = DeleteDownloadFilesTask.class.getSimpleName();
    private List<String> mUrls;
    private boolean mDeleteDownloadedFile;
    private ExecutorService mTaskEngine;
    private DownloadFileDeleter mDownloadFileDeleter;
    private Pauseable mDownloadTaskPauseable;
    private OnDeleteDownloadFilesListener mOnDeleteDownloadFilesListener;
    private boolean mIsStop = false;
    private AtomicBoolean mIsNotifyFinish = new AtomicBoolean(false);
    private Object mLock = new Object();
    private final List<DownloadFileInfo> mDownloadFilesNeedDelete = new ArrayList<DownloadFileInfo>();
    private final List<DownloadFileInfo> mDownloadFilesDeleted = new ArrayList<DownloadFileInfo>();
    private final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

    public DeleteDownloadFilesTask(List<String> urls, boolean deleteDownloadedFile, ExecutorService taskEngine, DownloadFileDeleter downloadFileDeleter, Pauseable downloadTaskPauseable) {
        this.mUrls = urls;
        this.mTaskEngine = taskEngine;
        this.mDeleteDownloadedFile = deleteDownloadedFile;
        this.mDownloadFileDeleter = downloadFileDeleter;
        this.mDownloadTaskPauseable = downloadTaskPauseable;
    }

    public void setOnDeleteDownloadFilesListener(OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        this.mOnDeleteDownloadFilesListener = onDeleteDownloadFilesListener;
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileDeleter.getDownloadFile(url);
    }

    @Override
    public void stop() {
        this.mIsStop = true;
    }

    @Override
    public boolean isStopped() {
        return this.mIsStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DownloadFileInfo downloadFileInfo;
            this.mDownloadFilesNeedDelete.clear();
            this.mDownloadFilesDeleted.clear();
            this.mDownloadFilesSkip.clear();
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedDelete.add(downloadFileInfo);
            }
            this.notifyDeleteDownloadFilesPrepared();
            final OnDeleteSingleDownloadFileListener onDeleteEverySingleDownloadFileListener = new OnDeleteSingleDownloadFileListener();
            for (int i = 0; i < this.mDownloadFilesNeedDelete.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedDelete.get(i);
                if (downloadFileInfo == null) {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mDownloadFilesSkip.add(downloadFileInfo);
                        continue;
                    }
                }
                final String finalUrl = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d(TAG, TAG + ".run \u6279\u91cf\u5220\u9664\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5220\u9664\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                    return;
                }
                if (this.mDownloadTaskPauseable.isDownloading(finalUrl)) {
                    Log.d(TAG, TAG + ".run \u9700\u8981\u5148\u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u540e\u5220\u9664\uff0curl:" + finalUrl);
                    this.mDownloadTaskPauseable.pause(finalUrl, new OnStopFileDownloadTaskListener(){

                        @Override
                        public void onStopFileDownloadTaskSucceed(String url) {
                            Log.d(TAG, TAG + ".run \u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u6210\u529f\uff0c\u5f00\u59cb\u5220\u9664\uff0curl:" + finalUrl);
                            if (DeleteDownloadFilesTask.this.isStopped()) {
                                Log.d(TAG, TAG + ".run \u6279\u91cf\u5220\u9664\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5220\u9664\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                                DeleteDownloadFilesTask.this.notifyDeleteDownloadFilesCompleted();
                                return;
                            }
                            DeleteDownloadFilesTask.this.runSingleDeleteTask(finalUrl, onDeleteEverySingleDownloadFileListener, false);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                            if (DeleteDownloadFilesTask.this.isStopped()) {
                                Log.d(TAG, TAG + ".run \u6279\u91cf\u5220\u9664\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5220\u9664\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                                DeleteDownloadFilesTask.this.notifyDeleteDownloadFilesCompleted();
                                return;
                            }
                            if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                                DeleteDownloadFilesTask.this.runSingleDeleteTask(finalUrl, onDeleteEverySingleDownloadFileListener, false);
                                return;
                            }
                            Log.d(TAG, TAG + ".run \u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u5220\u9664\uff0curl:" + finalUrl);
                            Object object = DeleteDownloadFilesTask.this.mLock;
                            synchronized (object) {
                                DeleteDownloadFilesTask.this.mDownloadFilesSkip.add(DeleteDownloadFilesTask.this.getDownloadFile(finalUrl));
                            }
                        }
                    });
                    continue;
                }
                this.runSingleDeleteTask(finalUrl, onDeleteEverySingleDownloadFileListener, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.isStopped()) {
                this.notifyDeleteDownloadFilesCompleted();
            }
            Log.d(TAG, TAG + ".run \u6279\u91cf\u5220\u9664\u6587\u4ef6\u4e3b\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u4f46\u662f\u901a\u8fc7\u6682\u505c\u4e0b\u8f7d\u4e2d\u7684\u6587\u4ef6\u5220\u9664\u4efb\u52a1\u53ef\u80fd\u8fd8\u6ca1\u6709\u7ed3\u675f");
        }
    }

    private void runSingleDeleteTask(String url, OnDeleteDownloadFileListener onDeleteEverySingleDownloadFileListener, boolean sync) {
        DeleteDownloadFileTask deleteSingleDownloadFileTask = new DeleteDownloadFileTask(url, this.mDeleteDownloadedFile, this.mDownloadFileDeleter);
        deleteSingleDownloadFileTask.enableSyncCallback();
        deleteSingleDownloadFileTask.setOnDeleteDownloadFileListener(onDeleteEverySingleDownloadFileListener);
        if (sync) {
            deleteSingleDownloadFileTask.run();
        } else {
            this.mTaskEngine.execute(deleteSingleDownloadFileTask);
        }
    }

    private void notifyDeleteDownloadFilesPrepared() {
        Log.d(TAG, TAG + ".run \u51c6\u5907\u6279\u91cf\u5220\u9664\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedDelete.size());
        OnDeleteDownloadFilesListener.MainThreadHelper.onDeleteDownloadFilesPrepared(this.mDownloadFilesNeedDelete, this.mOnDeleteDownloadFilesListener);
    }

    private void notifyDeletingDownloadFiles(DownloadFileInfo downloadFileInfo) {
        String url = null;
        if (downloadFileInfo != null) {
            url = downloadFileInfo.getUrl();
        }
        Log.d(TAG, TAG + ".run \u51c6\u5907\u5220\u9664\u5355\u4e2a\uff0curl\uff1a" + url);
        OnDeleteDownloadFilesListener.MainThreadHelper.onDeletingDownloadFiles(this.mDownloadFilesNeedDelete, this.mDownloadFilesDeleted, this.mDownloadFilesSkip, downloadFileInfo, this.mOnDeleteDownloadFilesListener);
    }

    private void notifyDeleteDownloadFilesCompleted() {
        if (this.mIsNotifyFinish.get()) {
            return;
        }
        if (this.mIsNotifyFinish.compareAndSet(false, true)) {
            OnDeleteDownloadFilesListener.MainThreadHelper.onDeleteDownloadFilesCompleted(this.mDownloadFilesNeedDelete, this.mDownloadFilesDeleted, this.mOnDeleteDownloadFilesListener);
            this.mIsStop = true;
            int failedSize = this.mDownloadFilesNeedDelete.size() - this.mDownloadFilesDeleted.size();
            Log.d(TAG, TAG + ".run \u6279\u91cf\u5220\u9664\u6587\u4ef6\u4e3b\u4efb\u52a1\u548c\u5176\u5b83\u76f8\u5173\u4efb\u52a1\u5168\u90e8\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u603b\u5171\u9700\u8981\u5220\u9664\uff1a" + this.mDownloadFilesNeedDelete.size() + "\uff0c\u5df2\u5220\u9664\uff1a" + this.mDownloadFilesDeleted.size() + "\uff0c\u5931\u8d25\uff1a" + failedSize + "\uff0c\u8df3\u8fc7\uff1a" + this.mDownloadFilesSkip.size() + "\uff0c\u8df3\u8fc7\u6570\u91cf\u662f\u5426\u7b49\u4e8e\u5931\u8d25\u6570\u91cf\uff1a" + (failedSize == this.mDownloadFilesSkip.size()));
        }
    }

    private class OnDeleteSingleDownloadFileListener
    implements OnDeleteDownloadFileListener {
        private OnDeleteSingleDownloadFileListener() {
        }

        @Override
        public void onDeleteDownloadFilePrepared(DownloadFileInfo downloadFileNeedDelete) {
            DeleteDownloadFilesTask.this.notifyDeletingDownloadFiles(downloadFileNeedDelete);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeleteDownloadFileSuccess(DownloadFileInfo downloadFileDeleted) {
            String url = null;
            if (downloadFileDeleted != null) {
                url = downloadFileDeleted.getUrl();
            }
            Object object = DeleteDownloadFilesTask.this.mLock;
            synchronized (object) {
                DeleteDownloadFilesTask.this.mDownloadFilesDeleted.add(downloadFileDeleted);
            }
            Log.d(TAG, TAG + ".run \u5220\u9664\u5355\u4e2a\u6210\u529f\uff0c\u5df2\u5220\u9664\u6570\u91cf\uff1a" + DeleteDownloadFilesTask.this.mDownloadFilesDeleted.size() + "\uff0c\u603b\u5171\u9700\u8981\u5220\u9664\u6570\u91cf" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0curl\uff1a" + url);
            if (DeleteDownloadFilesTask.this.mDownloadFilesDeleted.size() + DeleteDownloadFilesTask.this.mDownloadFilesSkip.size() == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size()) {
                DeleteDownloadFilesTask.this.notifyDeleteDownloadFilesCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeleteDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnDeleteDownloadFileListener.DeleteDownloadFileFailReason failReason) {
            String url = null;
            if (downloadFileInfo != null) {
                url = downloadFileInfo.getUrl();
            }
            String msg = null;
            if (failReason != null) {
                msg = failReason.getMessage();
            }
            Log.d(TAG, TAG + ".run \u5220\u9664\u5355\u4e2a\u6210\u529f\uff0c\u5df2\u5220\u9664\u6570\u91cf\uff1a" + DeleteDownloadFilesTask.this.mDownloadFilesDeleted.size() + "\uff0c\u603b\u5171\u9700\u8981\u5220\u9664\u6570\u91cf" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + msg + "\uff0curl\uff1a" + url);
            Object object = DeleteDownloadFilesTask.this.mLock;
            synchronized (object) {
                DeleteDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
            }
            if (DeleteDownloadFilesTask.this.mDownloadFilesDeleted.size() + DeleteDownloadFilesTask.this.mDownloadFilesSkip.size() == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size()) {
                DeleteDownloadFilesTask.this.notifyDeleteDownloadFilesCompleted();
            }
        }
    }
}

