/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_delete;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_delete.DownloadFileDeleter;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.util.DownloadFileUtil;

class DeleteDownloadFileTask
implements Runnable {
    private static final String TAG = DeleteDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private boolean mDeleteDownloadedFileInPath;
    private DownloadFileDeleter mDownloadFileDeleter;
    private boolean mIsSyncCallback = false;
    private AtomicBoolean mIsNotifyFinish = new AtomicBoolean(false);
    private OnDeleteDownloadFileListener mOnDeleteDownloadFileListener;

    public DeleteDownloadFileTask(String url, boolean deleteDownloadedFileInPath, DownloadFileDeleter downloadFileDeleter) {
        this.mUrl = url;
        this.mDeleteDownloadedFileInPath = deleteDownloadedFileInPath;
        this.mDownloadFileDeleter = downloadFileDeleter;
    }

    public void setOnDeleteDownloadFileListener(OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        this.mOnDeleteDownloadFileListener = onDeleteDownloadFileListener;
    }

    public void enableSyncCallback() {
        this.mIsSyncCallback = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason failReason;
        block31: {
            DownloadFileInfo downloadFileInfo;
            block24: {
                block22: {
                    block30: {
                        block23: {
                            boolean deleteResult;
                            block20: {
                                block29: {
                                    block21: {
                                        block18: {
                                            block28: {
                                                block19: {
                                                    block16: {
                                                        block27: {
                                                            block17: {
                                                                downloadFileInfo = null;
                                                                failReason = null;
                                                                downloadFileInfo = this.mDownloadFileDeleter.getDownloadFile(this.mUrl);
                                                                if (DownloadFileUtil.isLegal(downloadFileInfo)) break block16;
                                                                failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(this.mUrl, "the download file not exist !", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST);
                                                                if (failReason != null) break block17;
                                                                this.notifySuccess(downloadFileInfo);
                                                                Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                                break block27;
                                                            }
                                                            this.notifyFailed(downloadFileInfo, failReason);
                                                            Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                                                        }
                                                        Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                        return;
                                                    }
                                                    this.notifyPrepared(downloadFileInfo);
                                                    if (DownloadFileUtil.canDelete(downloadFileInfo)) break block18;
                                                    failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(this.mUrl, "the download file status error !", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_FILE_STATUS_ERROR);
                                                    if (failReason != null) break block19;
                                                    this.notifySuccess(downloadFileInfo);
                                                    Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                    break block28;
                                                }
                                                this.notifyFailed(downloadFileInfo, failReason);
                                                Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                                            }
                                            Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                            return;
                                        }
                                        deleteResult = false;
                                        try {
                                            this.mDownloadFileDeleter.deleteDownloadFile(this.mUrl);
                                            deleteResult = true;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        if (deleteResult) break block20;
                                        failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(this.mUrl, "delete file in record failed !", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_UNKNOWN);
                                        if (failReason != null) break block21;
                                        this.notifySuccess(downloadFileInfo);
                                        Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                        break block29;
                                    }
                                    this.notifyFailed(downloadFileInfo, failReason);
                                    Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                                }
                                Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                return;
                            }
                            Log.d(TAG, TAG + ".run \u6570\u636e\u5e93\u5220\u9664\u6210\u529furl\uff1a" + this.mUrl);
                            if (this.mDeleteDownloadedFileInPath) {
                                File file = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getFileName());
                                if (file != null && file.exists()) {
                                    deleteResult = file.delete();
                                } else {
                                    file = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                                    if (file.exists()) {
                                        deleteResult = file.delete();
                                    }
                                }
                            }
                            if (deleteResult) break block22;
                            failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(this.mUrl, "delete file in path failed !", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_UNKNOWN);
                            if (failReason != null) break block23;
                            this.notifySuccess(downloadFileInfo);
                            Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                            break block30;
                        }
                        this.notifyFailed(downloadFileInfo, failReason);
                        Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                    }
                    Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                    return;
                }
                try {
                    Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u6210\u529furl\uff1a" + this.mUrl);
                    if (failReason != null) break block24;
                    this.notifySuccess(downloadFileInfo);
                }
                catch (Exception e) {
                    block32: {
                        block25: {
                            try {
                                e.printStackTrace();
                                failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(this.mUrl, e);
                                if (failReason != null) break block25;
                                this.notifySuccess(downloadFileInfo);
                            }
                            catch (Throwable throwable) {
                                if (failReason == null) {
                                    this.notifySuccess(downloadFileInfo);
                                    Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                } else {
                                    this.notifyFailed(downloadFileInfo, failReason);
                                    Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                                }
                                Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                throw throwable;
                            }
                            Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                            break block32;
                        }
                        this.notifyFailed(downloadFileInfo, failReason);
                        Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
                    }
                    Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                }
                Log.d(TAG, TAG + ".run \u5220\u9664\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                break block31;
            }
            this.notifyFailed(downloadFileInfo, failReason);
            Log.d(TAG, TAG + ".run \u5220\u9664\u5931\u8d25\uff0curl\uff1a" + this.mUrl + "\uff0cfailReason:" + failReason.getType());
        }
        Log.d(TAG, TAG + ".run \u6587\u4ef6\u5220\u9664\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
    }

    private void notifyPrepared(DownloadFileInfo downloadFileInfo) {
        if (this.mOnDeleteDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnDeleteDownloadFileListener.onDeleteDownloadFilePrepared(downloadFileInfo);
        } else {
            OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFilePrepared(downloadFileInfo, this.mOnDeleteDownloadFileListener);
        }
    }

    private void notifySuccess(DownloadFileInfo downloadFileInfo) {
        if (this.mIsNotifyFinish.get()) {
            return;
        }
        if (this.mIsNotifyFinish.compareAndSet(false, true) && this.mOnDeleteDownloadFileListener != null) {
            if (this.mIsSyncCallback) {
                this.mOnDeleteDownloadFileListener.onDeleteDownloadFileSuccess(downloadFileInfo);
            } else {
                OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileSuccess(downloadFileInfo, this.mOnDeleteDownloadFileListener);
            }
        }
    }

    private void notifyFailed(DownloadFileInfo downloadFileInfo, OnDeleteDownloadFileListener.DeleteDownloadFileFailReason failReason) {
        if (this.mIsNotifyFinish.get()) {
            return;
        }
        if (this.mIsNotifyFinish.compareAndSet(false, true) && this.mOnDeleteDownloadFileListener != null) {
            if (this.mIsSyncCallback) {
                this.mOnDeleteDownloadFileListener.onDeleteDownloadFileFailed(downloadFileInfo, failReason);
            } else {
                OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileFailed(downloadFileInfo, failReason, this.mOnDeleteDownloadFileListener);
            }
        }
    }
}

