/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.Context;
import android.text.TextUtils;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.wlf.filedownloader.base.BaseDownloadConfigBuilder;
import org.wlf.filedownloader.base.Log;

public class FileDownloadConfiguration {
    private static final String TAG = FileDownloadConfiguration.class.getSimpleName();
    private Builder mBuilder;
    private ExecutorService mFileDownloadEngine;
    private ExecutorService mFileDetectEngine;
    private ExecutorService mFileOperationEngine;

    public static FileDownloadConfiguration createDefault(Context context) {
        return new Builder(context).build();
    }

    private FileDownloadConfiguration(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder can not be empty!");
        }
        this.mBuilder = builder;
        this.mFileDownloadEngine = Executors.newFixedThreadPool(builder.mDownloadTaskSize);
        this.mFileDetectEngine = Executors.newCachedThreadPool();
        this.mFileOperationEngine = Executors.newCachedThreadPool();
    }

    public Context getContext() {
        return this.mBuilder.mContext;
    }

    public String getFileDownloadDir() {
        return this.mBuilder.mFileDownloadDir;
    }

    public boolean isDebugMode() {
        return this.mBuilder.mIsDebugMode;
    }

    public int getRetryDownloadTimes() {
        return this.mBuilder.getRetryDownloadTimes();
    }

    public int getConnectTimeout() {
        return this.mBuilder.getConnectTimeout();
    }

    public ExecutorService getFileDownloadEngine() {
        return this.mFileDownloadEngine;
    }

    public ExecutorService getFileDetectEngine() {
        return this.mFileDetectEngine;
    }

    public ExecutorService getFileOperationEngine() {
        return this.mFileOperationEngine;
    }

    public static class Builder
    extends BaseDownloadConfigBuilder {
        public static final int MAX_DOWNLOAD_TASK_SIZE = 10;
        public static final int DEFAULT_DOWNLOAD_TASK_SIZE = 2;
        private Context mContext;
        private String mFileDownloadDir;
        private int mDownloadTaskSize;
        private boolean mIsDebugMode = false;

        public Builder(Context context) {
            this.mContext = context.getApplicationContext();
            try {
                this.mFileDownloadDir = this.mContext.getExternalFilesDir(null).getAbsolutePath() + File.separator + "file_downloader";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFileDownloadDir = this.mContext.getFilesDir().getAbsolutePath() + File.separator + "file_downloader";
            }
            this.mDownloadTaskSize = 2;
            Log.setDebugMode(this.mIsDebugMode);
        }

        public Builder configFileDownloadDir(String fileDownloadDir) {
            if (!TextUtils.isEmpty((CharSequence)fileDownloadDir)) {
                File file = new File(fileDownloadDir);
                if (!file.exists()) {
                    Log.i(TAG, "configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u8fd8\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa\uff01");
                    boolean isCreateSuccess = file.mkdirs();
                    if (isCreateSuccess) {
                        Log.i(TAG, "configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u521b\u5efa\u6210\u529f\uff01");
                    } else {
                        Log.i(TAG, "configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u521b\u5efa\u5931\u8d25\uff01");
                    }
                } else {
                    Log.i(TAG, "configFileDownloadDir \u8981\u8bbe\u7f6e\u7684\u6587\u4ef6\u4e0b\u8f7d\u4fdd\u5b58\u76ee\u5f55\uff1a" + fileDownloadDir + " \u5df2\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u521b\u5efa\uff01");
                }
                this.mFileDownloadDir = fileDownloadDir;
            }
            return this;
        }

        public Builder configDownloadTaskSize(int downloadTaskSize) {
            if (downloadTaskSize >= 1 && downloadTaskSize <= 10) {
                this.mDownloadTaskSize = downloadTaskSize;
            } else if (downloadTaskSize > 10) {
                this.mDownloadTaskSize = 10;
            } else if (downloadTaskSize < 1) {
                this.mDownloadTaskSize = 1;
            } else {
                Log.i(TAG, "configDownloadTaskSize \u914d\u7f6e\u540c\u65f6\u4e0b\u8f7d\u4efb\u52a1\u7684\u6570\u91cf\u5931\u8d25\uff0cdownloadTaskSize\uff1a" + downloadTaskSize);
            }
            return this;
        }

        public Builder configDebugMode(boolean isDebugMode) {
            this.mIsDebugMode = isDebugMode;
            Log.setDebugMode(this.mIsDebugMode);
            return this;
        }

        @Override
        public Builder configRetryDownloadTimes(int retryDownloadTimes) {
            super.configRetryDownloadTimes(retryDownloadTimes);
            return this;
        }

        @Override
        public Builder configConnectTimeout(int connectTimeout) {
            super.configConnectTimeout(connectTimeout);
            return this;
        }

        private int getRetryDownloadTimes() {
            return this.mRetryDownloadTimes;
        }

        private int getConnectTimeout() {
            return this.mConnectTimeout;
        }

        public FileDownloadConfiguration build() {
            return new FileDownloadConfiguration(this);
        }
    }
}

