/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.base.BaseDownloadConfigBuilder;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.MapUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadConfiguration {
    private static final String TAG = FileDownloadConfiguration.class.getSimpleName();
    private static final String NULL_KEY_FOR_URL = DownloadConfiguration.class + "_temp_key_for_null";
    public static final String DEFAULT_REQUEST_METHOD = "GET";
    private InnerBuilder mBuilder;

    private DownloadConfiguration(InnerBuilder builder) {
        this.mBuilder = builder;
    }

    void initNullKeyForUrl(String url) {
        this.initNullKeyForUrlInternal(url, false);
    }

    private void initNullKeyForUrlInternal(String url, boolean replaceExistWithNullValue) {
        if (!UrlUtil.isUrl(url) || this.mBuilder == null) {
            return;
        }
        if (this.mBuilder.mUrlHeaders != null) {
            Map<String, String> nullHeaders = this.getHeaders(NULL_KEY_FOR_URL);
            Map<String, String> existUrlHeaders = this.getHeaders(url);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (!MapUtil.isEmpty(nullHeaders)) {
                if (replaceExistWithNullValue) {
                    this.mBuilder.mUrlHeaders.remove(url);
                    headers.putAll(nullHeaders);
                } else if (!MapUtil.isEmpty(existUrlHeaders)) {
                    this.mBuilder.mUrlHeaders.remove(url);
                    headers.putAll(nullHeaders);
                    headers.putAll(existUrlHeaders);
                } else {
                    headers.putAll(nullHeaders);
                }
                Log.e("wlf", "\u521d\u59cb\u5316headers\uff1a" + headers.size());
                this.mBuilder.mUrlHeaders.put(url, headers);
            }
        }
        if (this.mBuilder.mRetryDownloadTimes != null) {
            int existUrlRetryDownloadTimes = this.getRetryDownloadTimes(url);
            int retryDownloadTimes = this.getRetryDownloadTimes(NULL_KEY_FOR_URL);
            if (replaceExistWithNullValue) {
                if (existUrlRetryDownloadTimes != 0) {
                    this.mBuilder.mRetryDownloadTimes.remove(url);
                    this.mBuilder.mRetryDownloadTimes.put(url, retryDownloadTimes);
                } else if (!this.mBuilder.mRetryDownloadTimes.containsKey(url)) {
                    this.mBuilder.mRetryDownloadTimes.put(url, retryDownloadTimes);
                }
            } else if (!this.mBuilder.mRetryDownloadTimes.containsKey(url)) {
                this.mBuilder.mRetryDownloadTimes.put(url, retryDownloadTimes);
            }
        }
        if (this.mBuilder.mConnectTimeout != null) {
            int existUrlConnectTimeout = this.getConnectTimeout(url);
            int connectTimeout = this.getConnectTimeout(NULL_KEY_FOR_URL);
            if (replaceExistWithNullValue) {
                if (existUrlConnectTimeout != 15000) {
                    this.mBuilder.mConnectTimeout.remove(url);
                    this.mBuilder.mConnectTimeout.put(url, connectTimeout);
                } else if (!this.mBuilder.mConnectTimeout.containsKey(url)) {
                    this.mBuilder.mConnectTimeout.put(url, connectTimeout);
                }
            } else if (!this.mBuilder.mConnectTimeout.containsKey(url)) {
                this.mBuilder.mConnectTimeout.put(url, connectTimeout);
            }
        }
        if (this.mBuilder.mRequestMethod != null) {
            String existUrlRequestMethod = this.getRequestMethod(url);
            String requestMethod = this.getRequestMethod(NULL_KEY_FOR_URL);
            if (replaceExistWithNullValue) {
                if (!DEFAULT_REQUEST_METHOD.equalsIgnoreCase(existUrlRequestMethod)) {
                    this.mBuilder.mRequestMethod.remove(url);
                    this.mBuilder.mRequestMethod.put(url, requestMethod);
                } else if (!this.mBuilder.mRequestMethod.containsKey(url)) {
                    this.mBuilder.mRequestMethod.put(url, requestMethod);
                }
            } else if (!this.mBuilder.mRequestMethod.containsKey(url)) {
                this.mBuilder.mRequestMethod.put(url, requestMethod);
            }
        }
    }

    void initNullKeyForUrls(List<String> urls) {
        if (CollectionUtil.isEmpty(urls) || this.mBuilder == null) {
            return;
        }
        Log.e("wlf", "\u521d\u59cb\u5316urls\uff1a" + urls.size());
        for (String url : urls) {
            if (!UrlUtil.isUrl(url)) continue;
            this.initNullKeyForUrlInternal(url, false);
        }
    }

    public Map<String, String> getHeaders(String url) {
        if (!UrlUtil.isUrl(url) || this.mBuilder == null || this.mBuilder.mUrlHeaders == null) {
            return null;
        }
        return (Map)this.mBuilder.mUrlHeaders.get(url);
    }

    public int getRetryDownloadTimes(String url) {
        if (!UrlUtil.isUrl(url) || this.mBuilder == null || this.mBuilder.mRetryDownloadTimes == null) {
            return 0;
        }
        Integer retryDownloadTimes = (Integer)this.mBuilder.mRetryDownloadTimes.get(url);
        if (retryDownloadTimes == null) {
            return 0;
        }
        return retryDownloadTimes;
    }

    public int getConnectTimeout(String url) {
        if (!UrlUtil.isUrl(url) || this.mBuilder == null || this.mBuilder.mConnectTimeout == null) {
            return 15000;
        }
        Integer connectTimeout = (Integer)this.mBuilder.mConnectTimeout.get(url);
        if (connectTimeout == null) {
            return 15000;
        }
        return connectTimeout;
    }

    public String getRequestMethod(String url) {
        if (!UrlUtil.isUrl(url) || this.mBuilder == null || this.mBuilder.mRequestMethod == null) {
            return DEFAULT_REQUEST_METHOD;
        }
        String requestMethod = (String)this.mBuilder.mRequestMethod.get(url);
        if (TextUtils.isEmpty((CharSequence)requestMethod)) {
            return DEFAULT_REQUEST_METHOD;
        }
        return requestMethod;
    }

    private static class InnerBuilder
    extends BaseDownloadConfigBuilder {
        private Map<String, Map<String, String>> mUrlHeaders = new HashMap<String, Map<String, String>>();
        private Map<String, Integer> mRetryDownloadTimes = new HashMap<String, Integer>();
        private Map<String, Integer> mConnectTimeout = new HashMap<String, Integer>();
        private Map<String, String> mRequestMethod = new HashMap<String, String>();

        private InnerBuilder() {
        }

        protected InnerBuilder addHeader(String key, String value) {
            String url = NULL_KEY_FOR_URL;
            this.addOrReplaceWithUrl(url, key, value, false);
            return this;
        }

        protected InnerBuilder addHeaderWithUrl(String url, String key, String value) {
            this.addOrReplaceWithUrl(url, key, value, false);
            return this;
        }

        protected InnerBuilder replaceHeader(String key, String value) {
            String url = NULL_KEY_FOR_URL;
            this.addOrReplaceWithUrl(url, key, value, true);
            return this;
        }

        protected InnerBuilder replaceHeaderWithUrl(String url, String key, String value) {
            this.addOrReplaceWithUrl(url, key, value, true);
            return this;
        }

        private void addOrReplaceWithUrl(String url, String key, String value, boolean replace) {
            if (UrlUtil.isUrl(url) && !TextUtils.isEmpty((CharSequence)key)) {
                Map<String, String> existHeaders = this.mUrlHeaders.get(url);
                if (existHeaders == null) {
                    existHeaders = new HashMap<String, String>();
                    this.mUrlHeaders.put(url, existHeaders);
                }
                if (replace) {
                    if (existHeaders.containsKey(key)) {
                        existHeaders.remove(key);
                        existHeaders.put(key, value);
                    }
                } else if (!existHeaders.containsKey(key)) {
                    existHeaders.put(key, value);
                }
            }
        }

        protected InnerBuilder addHeaders(Map<String, String> headers) {
            String url = NULL_KEY_FOR_URL;
            this.addHeadersWithUrl(url, headers);
            return this;
        }

        protected InnerBuilder addHeadersWithUrl(String url, Map<String, String> headers) {
            if (UrlUtil.isUrl(url) && !MapUtil.isEmpty(headers)) {
                Map<String, String> existHeaders = this.mUrlHeaders.get(url);
                if (existHeaders == null) {
                    existHeaders = new HashMap<String, String>();
                    this.mUrlHeaders.put(url, existHeaders);
                }
                existHeaders.putAll(headers);
            }
            return this;
        }

        @Override
        public InnerBuilder configRetryDownloadTimes(int retryDownloadTimes) {
            String url = NULL_KEY_FOR_URL;
            this.configRetryDownloadTimesWithUrl(url, retryDownloadTimes);
            return this;
        }

        @Override
        public InnerBuilder configConnectTimeout(int connectTimeout) {
            String url = NULL_KEY_FOR_URL;
            this.configConnectTimeoutWithUrl(url, connectTimeout);
            return this;
        }

        protected InnerBuilder configRetryDownloadTimesWithUrl(String url, int retryDownloadTimes) {
            if (UrlUtil.isUrl(url)) {
                if (retryDownloadTimes >= 0 && retryDownloadTimes <= 10) {
                    this.mRetryDownloadTimes.put(url, retryDownloadTimes);
                } else if (retryDownloadTimes > 10) {
                    this.mRetryDownloadTimes.put(url, 10);
                } else if (retryDownloadTimes < 0) {
                    this.mRetryDownloadTimes.put(url, 0);
                } else {
                    Log.i(TAG, "configRetryDownloadTimes \u914d\u7f6e\u4e0b\u8f7d\u5931\u8d25\u91cd\u8bd5\u6b21\u6570\u5931\u8d25\uff0cretryDownloadTimes\uff1a" + retryDownloadTimes);
                }
            } else {
                Log.i(TAG, "configRetryDownloadTimes \u914d\u7f6e\u4e0b\u8f7d\u5931\u8d25\u91cd\u8bd5\u6b21\u6570\u5931\u8d25\uff0cretryDownloadTimes\uff1a" + retryDownloadTimes);
            }
            return this;
        }

        protected InnerBuilder configConnectTimeoutWithUrl(String url, int connectTimeout) {
            if (UrlUtil.isUrl(url)) {
                if (connectTimeout >= 5000 && connectTimeout <= 120000) {
                    this.mConnectTimeout.put(url, connectTimeout);
                } else if (connectTimeout > 120000) {
                    this.mConnectTimeout.put(url, 120000);
                } else if (connectTimeout < 5000) {
                    this.mConnectTimeout.put(url, 5000);
                } else {
                    Log.i(TAG, "configConnectTimeout \u914d\u7f6e\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u5931\u8d25\uff0cconnectTimeout\uff1a" + connectTimeout);
                }
            } else {
                Log.i(TAG, "configConnectTimeout \u914d\u7f6e\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u5931\u8d25\uff0cconnectTimeout\uff1a" + connectTimeout);
            }
            return this;
        }

        protected InnerBuilder configRequestMethod(String requestMethod) {
            String url = NULL_KEY_FOR_URL;
            this.configRequestMethodWithUrl(url, requestMethod);
            return this;
        }

        protected InnerBuilder configRequestMethodWithUrl(String url, String requestMethod) {
            if (!TextUtils.isEmpty((CharSequence)requestMethod)) {
                this.mRequestMethod.put(url, requestMethod);
            } else {
                Log.i(TAG, "configRequestMethodWithUrl \u914d\u7f6e\u8bf7\u6c42\u65b9\u6cd5\u5931\u8d25\uff0crequestMethod\uff1a" + requestMethod);
            }
            return this;
        }

        public DownloadConfiguration build() {
            return new DownloadConfiguration(this);
        }
    }

    public static class MultiBuilder
    extends InnerBuilder {
        @Override
        public MultiBuilder addHeader(String key, String value) {
            super.addHeader(key, value);
            return this;
        }

        @Override
        public MultiBuilder replaceHeader(String key, String value) {
            super.replaceHeader(key, value);
            return this;
        }

        @Override
        public MultiBuilder addHeaders(Map<String, String> headers) {
            super.addHeaders(headers);
            return this;
        }

        @Override
        public MultiBuilder configRetryDownloadTimes(int retryDownloadTimes) {
            super.configRetryDownloadTimes(retryDownloadTimes);
            return this;
        }

        @Override
        public MultiBuilder configConnectTimeout(int connectTimeout) {
            super.configConnectTimeout(connectTimeout);
            return this;
        }

        @Override
        public MultiBuilder configRequestMethod(String requestMethod) {
            super.configRequestMethod(requestMethod);
            return this;
        }

        @Override
        public MultiBuilder addHeaderWithUrl(String url, String key, String value) {
            super.addHeaderWithUrl(url, key, value);
            return this;
        }

        @Override
        public MultiBuilder replaceHeaderWithUrl(String url, String key, String value) {
            super.replaceHeaderWithUrl(url, key, value);
            return this;
        }

        @Override
        public MultiBuilder addHeadersWithUrl(String url, Map<String, String> headers) {
            super.addHeadersWithUrl(url, headers);
            return this;
        }

        @Override
        public MultiBuilder configRetryDownloadTimesWithUrl(String url, int retryDownloadTimes) {
            super.configRetryDownloadTimesWithUrl(url, retryDownloadTimes);
            return this;
        }

        @Override
        public MultiBuilder configConnectTimeoutWithUrl(String url, int connectTimeout) {
            super.configConnectTimeoutWithUrl(url, connectTimeout);
            return this;
        }

        @Override
        public MultiBuilder configRequestMethodWithUrl(String url, String requestMethod) {
            super.configRequestMethodWithUrl(url, requestMethod);
            return this;
        }
    }

    public static class Builder
    extends InnerBuilder {
        @Override
        public Builder addHeader(String key, String value) {
            super.addHeader(key, value);
            return this;
        }

        @Override
        public Builder replaceHeader(String key, String value) {
            super.replaceHeader(key, value);
            return this;
        }

        @Override
        public Builder addHeaders(Map<String, String> headers) {
            super.addHeaders(headers);
            return this;
        }

        @Override
        public Builder configRetryDownloadTimes(int retryDownloadTimes) {
            super.configRetryDownloadTimes(retryDownloadTimes);
            return this;
        }

        @Override
        public Builder configConnectTimeout(int connectTimeout) {
            super.configConnectTimeout(connectTimeout);
            return this;
        }

        @Override
        public Builder configRequestMethod(String requestMethod) {
            super.configRequestMethod(requestMethod);
            return this;
        }
    }
}

