/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wlf.filedownloader.DownloadFileChangeConfiguration;
import org.wlf.filedownloader.DownloadFileChangeObserver;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.db.ContentDbDao;
import org.wlf.filedownloader.file_delete.DownloadFileDeleter;
import org.wlf.filedownloader.file_download.DetectUrlFileInfo;
import org.wlf.filedownloader.file_download.base.DownloadRecorder;
import org.wlf.filedownloader.file_download.db_recorder.DownloadFileDbHelper;
import org.wlf.filedownloader.file_move.DownloadFileMover;
import org.wlf.filedownloader.file_rename.DownloadFileRenamer;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.ContentValuesUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.MapUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadCacher
implements DownloadRecorder,
DownloadFileMover,
DownloadFileDeleter,
DownloadFileRenamer {
    private static final String TAG = DownloadCacher.class.getSimpleName();
    private DownloadFileDbHelper mDownloadFileDbHelper;
    private Map<String, DownloadFileInfo> mDownloadFileInfoMap = new HashMap<String, DownloadFileInfo>();
    private Object mModifyLock = new Object();
    private DownloadFileChangeObserver mDownloadFileChangeObserver;

    DownloadCacher(Context context) {
        this.mDownloadFileDbHelper = new DownloadFileDbHelper(context);
        this.mDownloadFileChangeObserver = new DownloadFileChangeObserver();
        this.initDownloadFileInfoMapFromDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDownloadFileInfoMapFromDb() {
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return;
        }
        Cursor cursor = dao.query(null, null, null, null);
        List<DownloadFileInfo> downloadFileInfos = this.getDownloadFilesFromCursor(cursor);
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        if (CollectionUtil.isEmpty(downloadFileInfos)) {
            return;
        }
        for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
            if (!DownloadFileUtil.isLegal(downloadFileInfo)) continue;
            Object object = this.mModifyLock;
            synchronized (object) {
                this.mDownloadFileInfoMap.put(downloadFileInfo.getUrl(), downloadFileInfo);
            }
        }
    }

    private void checkDownloadFileStatus(DownloadFileInfo downloadFileInfo) {
        try {
            if (!DownloadFileUtil.isLegal(downloadFileInfo) || downloadFileInfo.getDownloadedSizeLong() <= 0L) {
                return;
            }
            String saveFilePath = downloadFileInfo.getFilePath();
            String tempFilePath = downloadFileInfo.getTempFilePath();
            File saveFile = null;
            File tempFile = null;
            if (FileUtil.isFilePath(saveFilePath)) {
                saveFile = new File(saveFilePath);
            }
            if (FileUtil.isFilePath(tempFilePath)) {
                tempFile = new File(tempFilePath);
            }
            if (downloadFileInfo.getStatus() == 8) {
                boolean handled = false;
                if (saveFile != null && saveFile.length() == downloadFileInfo.getDownloadedSizeLong() && downloadFileInfo.getDownloadedSizeLong() == downloadFileInfo.getFileSizeLong()) {
                    Log.d(TAG, "checkDownloadFileStatus\uff0c\u6587\u4ef6\u5df2\u4e0b\u8f7d\u5b8c\uff0c\u4f46\u5f53\u524d\u72b6\u6001\u4e3a\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u66f4\u6539\u72b6\u6001\u4e3a\u5df2\u4e0b\u8f7d\u5b8c\u6210\uff0curl:" + downloadFileInfo.getUrl());
                    handled = this.updateDownloadFileWithStatus(downloadFileInfo, 5);
                }
                if (!handled && (tempFile != null && tempFile.exists() && tempFile.length() > 0L || saveFile != null && saveFile.exists() && saveFile.length() > 0L)) {
                    Log.d(TAG, "checkDownloadFileStatus\uff0c\u6587\u4ef6\u672a\u4e0b\u8f7d\u5b8c/\u4e0b\u8f7d\u6587\u4ef6\u51fa\u73b0\u95ee\u9898\uff0c\u4f46\u5f53\u524d\u72b6\u6001\u4e3a\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u66f4\u6539\u72b6\u6001\u4e3a\u4e0b\u8f7d\u51fa\u9519\uff0curl:" + downloadFileInfo.getUrl());
                    handled = this.updateDownloadFileWithStatus(downloadFileInfo, 7);
                }
            } else {
                boolean fileExist = true;
                if (DownloadFileUtil.isCompleted(downloadFileInfo)) {
                    if (!(saveFile == null || saveFile.exists() || tempFile != null && tempFile.exists() && tempFile.length() == downloadFileInfo.getDownloadedSizeLong() && downloadFileInfo.getDownloadedSizeLong() == downloadFileInfo.getFileSizeLong())) {
                        Log.d(TAG, "checkDownloadFileStatus\uff0c\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4f46\u662f\u6587\u4ef6\u4e0d\u5b58\u5728\u4e86\uff0c\u9700\u8981\u66f4\u6539\u72b6\u6001\u4e3a\u6587\u4ef6\u4e0d\u5b58\u5728\uff0curl:" + downloadFileInfo.getUrl());
                        fileExist = false;
                    }
                } else if (tempFile == null || !tempFile.exists() || tempFile.length() <= 0L) {
                    Log.d(TAG, "checkDownloadFileStatus\uff0c\u6587\u4ef6\u6ca1\u6709\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4f46\u662f\u6587\u4ef6\u4e0d\u5b58\u5728\u4e86\uff0c\u9700\u8981\u66f4\u6539\u72b6\u6001\u4e3a\u6587\u4ef6\u4e0d\u5b58\u5728\uff0curl:" + downloadFileInfo.getUrl());
                    fileExist = false;
                }
                if (!fileExist) {
                    this.updateDownloadFileWithStatus(downloadFileInfo, 8);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mModifyLock;
        synchronized (object) {
            this.mDownloadFileInfoMap.clear();
            this.mDownloadFileChangeObserver.release();
            if (this.mDownloadFileDbHelper != null) {
                this.mDownloadFileDbHelper.close();
            }
        }
    }

    public void registerDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener, DownloadFileChangeConfiguration downloadFileChangeConfiguration) {
        this.mDownloadFileChangeObserver.addOnDownloadFileChangeListener(onDownloadFileChangeListener, downloadFileChangeConfiguration);
    }

    public void unregisterDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileChangeObserver.removeOnDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    private void notifyDownloadFileCreated(DownloadFileInfo downloadFileInfo) {
        if (this.mDownloadFileChangeObserver != null) {
            this.mDownloadFileChangeObserver.onDownloadFileCreated(downloadFileInfo);
        }
    }

    private void notifyDownloadFileUpdated(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener.Type type) {
        if (this.mDownloadFileChangeObserver != null) {
            this.mDownloadFileChangeObserver.onDownloadFileUpdated(downloadFileInfo, type);
        }
    }

    private void notifyDownloadFileDeleted(DownloadFileInfo downloadFileInfo) {
        if (this.mDownloadFileChangeObserver != null) {
            this.mDownloadFileChangeObserver.onDownloadFileDeleted(downloadFileInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDownloadFile(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        ContentValues values = downloadFileInfo.getContentValues();
        if (ContentValuesUtil.isEmpty(values)) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        DownloadFileInfo downloadFileInfoExist = this.getDownloadFile(url);
        if (DownloadFileUtil.isLegal(downloadFileInfoExist) && downloadFileInfoExist != downloadFileInfo) {
            OnDownloadFileChangeListener.Type type = OnDownloadFileChangeListener.Type.OTHER;
            int changeCount = 0;
            if (downloadFileInfoExist.getStatus() != downloadFileInfo.getStatus()) {
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.DOWNLOAD_STATUS;
            }
            if (downloadFileInfoExist.getDownloadedSizeLong() != downloadFileInfo.getDownloadedSizeLong()) {
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.DOWNLOADED_SIZE;
            }
            if (downloadFileInfoExist.getFileDir() != null && !downloadFileInfoExist.getFileDir().equals(downloadFileInfo.getFileDir())) {
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.SAVE_DIR;
            }
            if (downloadFileInfoExist.getFileName() != null && !downloadFileInfoExist.getFileName().equals(downloadFileInfo.getFileName())) {
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.SAVE_FILE_NAME;
            }
            if (changeCount > 1) {
                type = OnDownloadFileChangeListener.Type.OTHER;
            }
            Object object = this.mModifyLock;
            synchronized (object) {
                downloadFileInfoExist.update(downloadFileInfo);
                boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfoExist, false, type);
                if (!isSucceed) {
                    // empty if block
                }
                return true;
            }
        }
        Object object = this.mModifyLock;
        synchronized (object) {
            long id = dao.insert(values);
            if (id != -1L) {
                downloadFileInfo.setId(new Integer((int)id));
                this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                this.notifyDownloadFileCreated(downloadFileInfo);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDownloadFileInternal(DownloadFileInfo downloadFileInfo, boolean lockInternal, OnDownloadFileChangeListener.Type notifyType) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        ContentValues values = downloadFileInfo.getContentValues();
        if (ContentValuesUtil.isEmpty(values)) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        if (lockInternal) {
            Object object = this.mModifyLock;
            synchronized (object) {
                int result = dao.update(values, "_id= ?", new String[]{downloadFileInfo.getId() + ""});
                if (result == 1) {
                    if (this.mDownloadFileInfoMap.containsKey(url)) {
                        DownloadFileInfo downloadFileInfoInMap = this.mDownloadFileInfoMap.get(url);
                        downloadFileInfoInMap.update(downloadFileInfo);
                    } else {
                        this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                    }
                    this.notifyDownloadFileUpdated(downloadFileInfo, notifyType);
                    return true;
                }
            }
        } else {
            int result = dao.update(values, "_id= ?", new String[]{downloadFileInfo.getId() + ""});
            if (result == 1) {
                if (this.mDownloadFileInfoMap.containsKey(url)) {
                    DownloadFileInfo downloadFileInfoInMap = this.mDownloadFileInfoMap.get(url);
                    downloadFileInfoInMap.update(downloadFileInfo);
                } else {
                    this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                }
                this.notifyDownloadFileUpdated(downloadFileInfo, notifyType);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDownloadFileWithStatus(DownloadFileInfo downloadFileInfo, int newStatus) {
        Object object = this.mModifyLock;
        synchronized (object) {
            int oldStatus = downloadFileInfo.getStatus();
            downloadFileInfo.setStatus(newStatus);
            boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, OnDownloadFileChangeListener.Type.DOWNLOAD_STATUS);
            if (isSucceed) {
                return true;
            }
            downloadFileInfo.setStatus(oldStatus);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteDownloadFile(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        Object object = this.mModifyLock;
        synchronized (object) {
            int result = dao.delete("_id= ?", new String[]{downloadFileInfo.getId() + ""});
            if (result == 1) {
                this.mDownloadFileInfoMap.remove(url);
                this.notifyDownloadFileDeleted(downloadFileInfo);
                return true;
            }
            result = dao.delete("url= ?", new String[]{url + ""});
            if (result == 1) {
                this.mDownloadFileInfoMap.remove(url);
                this.notifyDownloadFileDeleted(downloadFileInfo);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadFileInfo getDownloadFileBySavePath(String savePath, boolean includeTempFilePath) {
        if (!FileUtil.isFilePath(savePath)) {
            return null;
        }
        DownloadFileInfo downloadFileInfo = null;
        Set<Map.Entry<String, DownloadFileInfo>> set = this.mDownloadFileInfoMap.entrySet();
        for (Map.Entry<String, DownloadFileInfo> entry : set) {
            String filePath;
            DownloadFileInfo info;
            if (entry == null || (info = entry.getValue()) == null || TextUtils.isEmpty((CharSequence)(filePath = info.getFilePath())) || !filePath.equals(savePath)) continue;
            downloadFileInfo = info;
            break;
        }
        if (downloadFileInfo == null) {
            String fileSaveName;
            ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
            if (dao == null) {
                return null;
            }
            int separatorIndex = savePath.lastIndexOf(File.separator);
            if (separatorIndex == -1) {
                return null;
            }
            String fileSaveDir = savePath.substring(0, separatorIndex);
            Cursor cursor = dao.query(null, "file_dir= ? AND file_name= ?", new String[]{fileSaveDir, fileSaveName = savePath.substring(separatorIndex + 1, savePath.length())}, null);
            if (cursor != null && cursor.moveToFirst()) {
                downloadFileInfo = new DownloadFileInfo(cursor);
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            if (downloadFileInfo == null && includeTempFilePath) {
                cursor = dao.query(null, "file_dir= ? AND temp_file_name= ?", new String[]{fileSaveDir, fileSaveName}, null);
                if (cursor != null && cursor.moveToFirst()) {
                    downloadFileInfo = new DownloadFileInfo(cursor);
                }
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
            if (downloadFileInfo == null) {
                return null;
            }
            String url = downloadFileInfo.getUrl();
            if (UrlUtil.isUrl(url)) {
                Object object = this.mModifyLock;
                synchronized (object) {
                    this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                    downloadFileInfo = this.mDownloadFileInfoMap.get(url);
                }
            }
        }
        this.checkDownloadFileStatus(downloadFileInfo);
        return downloadFileInfo;
    }

    private List<DownloadFileInfo> getDownloadFilesFromCursor(Cursor cursor) {
        ArrayList<DownloadFileInfo> downloadFileInfos = new ArrayList<DownloadFileInfo>();
        while (cursor != null && cursor.moveToNext()) {
            DownloadFileInfo downloadFileInfo = new DownloadFileInfo(cursor);
            if (downloadFileInfo == null) continue;
            downloadFileInfos.add(downloadFileInfo);
        }
        return downloadFileInfos;
    }

    @Override
    public DownloadFileInfo getDownloadFile(String url) {
        DownloadFileInfo downloadFileInfo = this.getDownloadFileInternal(url);
        if (downloadFileInfo == null && UrlUtil.isUrl(url)) {
            downloadFileInfo = this.getDownloadFileInternal(url.trim());
        }
        return downloadFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadFileInfo getDownloadFileInternal(String url) {
        DownloadFileInfo downloadFileInfo = null;
        if (this.mDownloadFileInfoMap.get(url) != null) {
            downloadFileInfo = this.mDownloadFileInfoMap.get(url);
        } else {
            ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
            if (dao == null) {
                return null;
            }
            Cursor cursor = dao.query(null, "url= ?", new String[]{url}, null);
            if (cursor != null && cursor.moveToFirst()) {
                downloadFileInfo = new DownloadFileInfo(cursor);
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            if (downloadFileInfo == null) {
                return null;
            }
            String downloadUrl = downloadFileInfo.getUrl();
            if (UrlUtil.isUrl(downloadUrl)) {
                Object object = this.mModifyLock;
                synchronized (object) {
                    this.mDownloadFileInfoMap.put(downloadUrl, downloadFileInfo);
                    downloadFileInfo = this.mDownloadFileInfoMap.get(url);
                }
            }
        }
        this.checkDownloadFileStatus(downloadFileInfo);
        return downloadFileInfo;
    }

    @Override
    public List<DownloadFileInfo> getDownloadFiles() {
        if (MapUtil.isEmpty(this.mDownloadFileInfoMap)) {
            this.initDownloadFileInfoMapFromDb();
        }
        if (!MapUtil.isEmpty(this.mDownloadFileInfoMap)) {
            ArrayList<DownloadFileInfo> downloadFileInfos = new ArrayList<DownloadFileInfo>(this.mDownloadFileInfoMap.values());
            if (!CollectionUtil.isEmpty(downloadFileInfos)) {
                for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
                    this.checkDownloadFileStatus(downloadFileInfo);
                }
            }
            return downloadFileInfos;
        }
        return new ArrayList<DownloadFileInfo>();
    }

    @Override
    public DownloadFileInfo createDownloadFileInfo(DetectUrlFileInfo detectUrlFileInfo) {
        if (!DownloadFileUtil.isLegal(detectUrlFileInfo)) {
            return null;
        }
        DownloadFileInfo downloadFileInfo = new DownloadFileInfo(detectUrlFileInfo);
        boolean isSucceed = this.addDownloadFile(downloadFileInfo);
        if (isSucceed) {
            return downloadFileInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordStatus(String url, int status, int increaseSize) throws Exception {
        Log.i(TAG, TAG + ".recordStatus \u8bb0\u5f55\u72b6\u6001\uff1astatus\uff1a" + status + "\uff0cincreaseSize\uff1a" + increaseSize + "\uff0curl\uff1a" + url);
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        Object object = this.mModifyLock;
        synchronized (object) {
            boolean isSucceed;
            boolean isStatusChange;
            int oldStatus = downloadFileInfo.getStatus();
            long oldDownloadedSize = downloadFileInfo.getDownloadedSizeLong();
            boolean bl = isStatusChange = status != downloadFileInfo.getStatus();
            if (!isStatusChange && increaseSize <= 0) {
                return;
            }
            OnDownloadFileChangeListener.Type type = OnDownloadFileChangeListener.Type.OTHER;
            int changeCount = 0;
            if (isStatusChange) {
                downloadFileInfo.setStatus(status);
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.DOWNLOAD_STATUS;
            }
            if (increaseSize > 0) {
                downloadFileInfo.setDownloadedSize(downloadFileInfo.getDownloadedSizeLong() + (long)increaseSize);
                ++changeCount;
                type = OnDownloadFileChangeListener.Type.DOWNLOADED_SIZE;
            }
            if (changeCount > 1) {
                type = OnDownloadFileChangeListener.Type.OTHER;
            }
            if (!(isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, type))) {
                downloadFileInfo.setStatus(oldStatus);
                downloadFileInfo.setDownloadedSize(oldDownloadedSize);
                throw new Exception("record failed !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDownloadFile(String url, boolean deleteMode) throws Exception {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        if (!deleteMode) {
            Object object = this.mModifyLock;
            synchronized (object) {
                long oldDownloadedSize = downloadFileInfo.getDownloadedSizeLong();
                downloadFileInfo.setDownloadedSize(0L);
                boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, OnDownloadFileChangeListener.Type.DOWNLOADED_SIZE);
                if (!isSucceed) {
                    downloadFileInfo.setDownloadedSize(oldDownloadedSize);
                    throw new Exception("reset failed !");
                }
            }
        } else {
            this.deleteDownloadFile(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDownloadSize(String url, long downloadSize) throws Exception {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        if (downloadSize < 0L || downloadSize > downloadFileInfo.getFileSizeLong()) {
            throw new Exception("the download size nee to set is illegal !");
        }
        Object object = this.mModifyLock;
        synchronized (object) {
            long oldDownloadedSize = downloadFileInfo.getDownloadedSizeLong();
            downloadFileInfo.setDownloadedSize(downloadSize);
            boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, OnDownloadFileChangeListener.Type.DOWNLOADED_SIZE);
            if (!isSucceed) {
                downloadFileInfo.setDownloadedSize(oldDownloadedSize);
                throw new Exception("reset downloadSize failed !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveDownloadFile(String url, String newDirPath) throws Exception {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            throw new Exception("download file doest not exist or illegal !");
        }
        Object object = this.mModifyLock;
        synchronized (object) {
            String oldFileDir = downloadFileInfo.getFileDir();
            downloadFileInfo.setFileDir(newDirPath);
            boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, OnDownloadFileChangeListener.Type.SAVE_DIR);
            if (!isSucceed) {
                downloadFileInfo.setFileDir(oldFileDir);
                throw new Exception("move failed !");
            }
        }
    }

    @Override
    public void deleteDownloadFile(String url) throws Exception {
        DownloadFileInfo DownloadFileInfoDeleted;
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            throw new Exception("download file doest not exist or illegal !");
        }
        boolean isSucceed = this.deleteDownloadFile(downloadFileInfo);
        if (!isSucceed && (DownloadFileInfoDeleted = this.getDownloadFileInternal(downloadFileInfo.getUrl())) != null) {
            throw new Exception("delete failed !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDownloadFile(String url, String newFileName) throws Exception {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            throw new Exception("download file doest not exist or illegal !");
        }
        Object object = this.mModifyLock;
        synchronized (object) {
            String oldFileName = downloadFileInfo.getFileName();
            downloadFileInfo.setFileName(newFileName);
            boolean isSucceed = this.updateDownloadFileInternal(downloadFileInfo, false, OnDownloadFileChangeListener.Type.SAVE_FILE_NAME);
            if (!isSucceed) {
                downloadFileInfo.setFileName(oldFileName);
                throw new Exception("rename failed !");
            }
        }
    }
}

