/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.UrlFailReason;

public interface OnDeleteDownloadFileListener {
    public void onDeleteDownloadFilePrepared(DownloadFileInfo var1);

    public void onDeleteDownloadFileSuccess(DownloadFileInfo var1);

    public void onDeleteDownloadFileFailed(DownloadFileInfo var1, DeleteDownloadFileFailReason var2);

    public static class DeleteDownloadFileFailReason
    extends UrlFailReason {
        public static final String TYPE_FILE_RECORD_IS_NOT_EXIST = DeleteDownloadFileFailReason.class.getName() + "_TYPE_FILE_RECORD_IS_NOT_EXIST";
        public static final String TYPE_FILE_STATUS_ERROR = DeleteDownloadFileFailReason.class.getName() + "_TYPE_RECORD_FILE_STATUS_ERROR";

        public DeleteDownloadFileFailReason(String url, String detailMessage, String type) {
            super(url, detailMessage, type);
        }

        public DeleteDownloadFileFailReason(String url, Throwable throwable) {
            super(url, throwable);
        }
    }

    @Deprecated
    public static class OnDeleteDownloadFileFailReason
    extends DeleteDownloadFileFailReason {
        public OnDeleteDownloadFileFailReason(String url, String detailMessage, String type) {
            super(url, detailMessage, type);
        }

        public OnDeleteDownloadFileFailReason(String url, Throwable throwable) {
            super(url, throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onDeleteDownloadFilePrepared(final DownloadFileInfo downloadFileNeedDelete, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDeleteDownloadFileListener == null) {
                        return;
                    }
                    onDeleteDownloadFileListener.onDeleteDownloadFilePrepared(downloadFileNeedDelete);
                }
            });
        }

        public static void onDeleteDownloadFileSuccess(final DownloadFileInfo downloadFileDeleted, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDeleteDownloadFileListener == null) {
                        return;
                    }
                    onDeleteDownloadFileListener.onDeleteDownloadFileSuccess(downloadFileDeleted);
                }
            });
        }

        public static void onDeleteDownloadFileFailed(final DownloadFileInfo downloadFileInfo, final DeleteDownloadFileFailReason failReason, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDeleteDownloadFileListener == null) {
                        return;
                    }
                    onDeleteDownloadFileListener.onDeleteDownloadFileFailed(downloadFileInfo, failReason);
                }
            });
        }
    }
}

