/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.text.TextUtils;
import java.net.URI;
import java.net.URLEncoder;

public class UrlUtil {
    private static final EncodeInfo[] ALL_ENCODER_MAP = new EncodeInfo[]{new EncodeInfo("%", URLEncoder.encode("%")), new EncodeInfo(" ", "%20"), new EncodeInfo("[", URLEncoder.encode("[")), new EncodeInfo("]", URLEncoder.encode("]")), new EncodeInfo("#", URLEncoder.encode("#"))};

    public static boolean isUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        String encodedUrl = UrlUtil.getASCIIEncodedUrl(url);
        return !TextUtils.isEmpty((CharSequence)encodedUrl);
    }

    public static String getASCIIEncodedUrl(String url) {
        if (url != null) {
            url = url.trim();
        }
        String encodedUrl = null;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String replacedUrl = UrlUtil.getReplacedUrl(url);
        try {
            URI uri = URI.create(replacedUrl);
            encodedUrl = uri.toASCIIString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)encodedUrl)) {
            encodedUrl = !TextUtils.isEmpty((CharSequence)replacedUrl) ? replacedUrl : url;
        }
        return encodedUrl;
    }

    public static String getFileNameByUrl(String url) {
        String fileName = null;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String replacedUrl = UrlUtil.getReplacedUrl(url);
        try {
            URI uri = URI.create(replacedUrl);
            String path = uri.getPath();
            if (TextUtils.isEmpty((CharSequence)path)) {
                path = uri.getRawPath();
            }
            if (!TextUtils.isEmpty((CharSequence)path)) {
                fileName = path.substring(path.lastIndexOf(47) + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(fileName)) {
            fileName = url;
        }
        return UrlUtil.getUndoReplacedUrl(fileName);
    }

    private static String getReplacedUrl(String originalUrl) {
        if (originalUrl == null) {
            return null;
        }
        String replacedUrl = originalUrl;
        for (EncodeInfo encodeInfo : ALL_ENCODER_MAP) {
            if (encodeInfo == null || !replacedUrl.contains(encodeInfo.unEncode)) continue;
            replacedUrl = replacedUrl.replace(encodeInfo.unEncode, encodeInfo.encoded);
        }
        if (TextUtils.isEmpty((CharSequence)replacedUrl)) {
            replacedUrl = originalUrl;
        }
        return replacedUrl;
    }

    private static String getUndoReplacedUrl(String replacedUrl) {
        if (replacedUrl == null) {
            return null;
        }
        String originalUrl = replacedUrl;
        for (int i = ALL_ENCODER_MAP.length - 1; i > 0; --i) {
            EncodeInfo encodeInfo = ALL_ENCODER_MAP[i];
            if (encodeInfo == null || !originalUrl.contains(encodeInfo.encoded)) continue;
            originalUrl = originalUrl.replace(encodeInfo.encoded, encodeInfo.unEncode);
        }
        if (TextUtils.isEmpty((CharSequence)originalUrl)) {
            originalUrl = replacedUrl;
        }
        return originalUrl;
    }

    private static class EncodeInfo {
        public final String unEncode;
        public final String encoded;

        public EncodeInfo(String unEncode, String encoded) {
            this.unEncode = unEncode;
            this.encoded = encoded;
        }
    }
}

