/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;

public interface OnRenameDownloadFileListener {
    public void onRenameDownloadFilePrepared(DownloadFileInfo var1);

    public void onRenameDownloadFileSuccess(DownloadFileInfo var1);

    public void onRenameDownloadFileFailed(DownloadFileInfo var1, OnRenameDownloadFileFailReason var2);

    public static class OnRenameDownloadFileFailReason
    extends FailReason {
        private static final long serialVersionUID = 4959079784745889291L;
        public static final String TYPE_FILE_RECORD_IS_NOT_EXIST = OnRenameDownloadFileFailReason.class.getName() + "_TYPE_FILE_RECORD_IS_NOT_EXIST";
        public static final String TYPE_ORIGINAL_FILE_NOT_EXIST = OnRenameDownloadFileFailReason.class.getName() + "_TYPE_ORIGINAL_FILE_NOT_EXIST";
        public static final String TYPE_NEW_FILE_NAME_IS_EMPTY = OnRenameDownloadFileFailReason.class.getName() + "_TYPE_NEW_FILE_NAME_IS_EMPTY";
        public static final String TYPE_FILE_STATUS_ERROR = OnRenameDownloadFileFailReason.class.getName() + "_TYPE_FILE_STATUS_ERROR";
        public static final String TYPE_NEW_FILE_HAS_BEEN_EXIST = OnRenameDownloadFileFailReason.class.getName() + "_TYPE_NEW_FILE_HAS_BEEN_EXIST";

        public OnRenameDownloadFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnRenameDownloadFileFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onRenameDownloadFilePrepared(final DownloadFileInfo downloadFileNeedRename, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
            if (onRenameDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onRenameDownloadFileListener.onRenameDownloadFilePrepared(downloadFileNeedRename);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onRenameDownloadFileSuccess(final DownloadFileInfo downloadFileRenamed, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
            if (onRenameDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onRenameDownloadFileListener.onRenameDownloadFileSuccess(downloadFileRenamed);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onRenameDownloadFileFailed(final DownloadFileInfo downloadFileInfo, final OnRenameDownloadFileFailReason failReason, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
            if (onRenameDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onRenameDownloadFileListener.onRenameDownloadFileFailed(downloadFileInfo, failReason);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }
}

