/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;

public interface OnMoveDownloadFileListener {
    public void onMoveDownloadFilePrepared(DownloadFileInfo var1);

    public void onMoveDownloadFileSuccess(DownloadFileInfo var1);

    public void onMoveDownloadFileFailed(DownloadFileInfo var1, OnMoveDownloadFileFailReason var2);

    public static class MainThreadHelper {
        public static void onMoveDownloadFilePrepared(final DownloadFileInfo downloadFileNeedToMove, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onMoveDownloadFileListener.onMoveDownloadFilePrepared(downloadFileNeedToMove);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onMoveDownloadFileSuccess(final DownloadFileInfo downloadFileMoved, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onMoveDownloadFileListener.onMoveDownloadFileSuccess(downloadFileMoved);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onMoveDownloadFileFailed(final DownloadFileInfo downloadFileInfo, final OnMoveDownloadFileFailReason failReason, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
            if (onMoveDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, failReason);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }

    public static class OnMoveDownloadFileFailReason
    extends FailReason {
        private static final long serialVersionUID = -5988401984979760118L;
        public static final String TYPE_TARGET_FILE_EXIST = OnMoveDownloadFileFailReason.class.getName() + "_TYPE_TARGET_FILE_EXIST";
        public static final String TYPE_ORIGINAL_FILE_NOT_EXIST = OnMoveDownloadFileFailReason.class.getName() + "_TYPE_ORIGINAL_FILE_NOT_EXIST";
        public static final String TYPE_UPDATE_RECORD_ERROR = OnMoveDownloadFileFailReason.class.getName() + "_TYPE_UPDATE_RECORD_ERROR";
        public static final String TYPE_FILE_STATUS_ERROR = OnMoveDownloadFileFailReason.class.getName() + "_TYPE_FILE_STATUS_ERROR";

        public OnMoveDownloadFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnMoveDownloadFileFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }
}

