/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import java.util.List;
import org.wlf.filedownloader.DownloadFileInfo;

public interface OnDeleteDownloadFilesListener {
    public void onDeleteDownloadFilesPrepared(List<DownloadFileInfo> var1);

    public void onDeletingDownloadFiles(List<DownloadFileInfo> var1, List<DownloadFileInfo> var2, List<DownloadFileInfo> var3, DownloadFileInfo var4);

    public void onDeleteDownloadFilesCompleted(List<DownloadFileInfo> var1, List<DownloadFileInfo> var2);

    public static class MainThreadHelper {
        public static void onDeleteDownloadFilePrepared(final List<DownloadFileInfo> downloadFilesNeedDelete, final OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
            if (onDeleteDownloadFilesListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFilesListener.onDeleteDownloadFilesPrepared(downloadFilesNeedDelete);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDeletingDownloadFiles(final List<DownloadFileInfo> downloadFilesNeedDelete, final List<DownloadFileInfo> downloadFilesDeleted, final List<DownloadFileInfo> downloadFilesSkip, final DownloadFileInfo downloadFileDeleting, final OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
            if (onDeleteDownloadFilesListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFilesListener.onDeletingDownloadFiles(downloadFilesNeedDelete, downloadFilesDeleted, downloadFilesSkip, downloadFileDeleting);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDeleteDownloadFilesCompleted(final List<DownloadFileInfo> downloadFilesNeedDelete, final List<DownloadFileInfo> downloadFilesDeleted, final OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
            if (onDeleteDownloadFilesListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFilesListener.onDeleteDownloadFilesCompleted(downloadFilesNeedDelete, downloadFilesDeleted);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }
}

