/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;

public interface OnDeleteDownloadFileListener {
    public void onDeleteDownloadFilePrepared(DownloadFileInfo var1);

    public void onDeleteDownloadFileSuccess(DownloadFileInfo var1);

    public void onDeleteDownloadFileFailed(DownloadFileInfo var1, OnDeleteDownloadFileFailReason var2);

    public static class OnDeleteDownloadFileFailReason
    extends FailReason {
        private static final long serialVersionUID = 6959079784746889291L;
        public static final String TYPE_FILE_RECORD_IS_NOT_EXIST = OnDeleteDownloadFileFailReason.class.getName() + "_TYPE_FILE_RECORD_IS_NOT_EXIST";

        public OnDeleteDownloadFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnDeleteDownloadFileFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onDeleteDownloadFilePrepared(final DownloadFileInfo downloadFileNeedDelete, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFileListener.onDeleteDownloadFilePrepared(downloadFileNeedDelete);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDeleteDownloadFileSuccess(final DownloadFileInfo downloadFileDeleted, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFileListener.onDeleteDownloadFileSuccess(downloadFileDeleted);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDeleteDownloadFileFailed(final DownloadFileInfo downloadFileInfo, final OnDeleteDownloadFileFailReason failReason, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
            if (onDeleteDownloadFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDeleteDownloadFileListener.onDeleteDownloadFileFailed(downloadFileInfo, failReason);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }
}

