/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.helper;

import android.text.TextUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import org.wlf.filedownloader.http_downlaoder.Range;
import org.wlf.filedownloader.util.UrlUtil;

public class HttpConnectionHelper {
    public static HttpURLConnection createDetectConnection(String url, int connectTimeout, String charset) throws Exception {
        return HttpConnectionHelper.createHttpUrlConnection(url, connectTimeout, charset, -1, -1);
    }

    public static HttpURLConnection createDownloadFileConnection(String url, int connectTimeout, String charset, Range range) throws Exception {
        int rangeStartPos = -1;
        int rangeEndPos = -1;
        if (Range.isLegal(range)) {
            rangeStartPos = range.startPos;
            rangeEndPos = range.endPos;
        }
        return HttpConnectionHelper.createHttpUrlConnection(url, connectTimeout, charset, rangeStartPos, rangeEndPos);
    }

    public static HttpURLConnection createHttpUrlConnection(String url, int connectTimeout, String charset, int rangeStartPos, int rangeEndPos) throws Exception {
        return HttpConnectionHelper.createHttpUrlConnectionInternal(url, connectTimeout, charset, rangeStartPos, rangeEndPos);
    }

    private static HttpURLConnection createHttpUrlConnectionInternal(String url, int connectTimeout, String charset, int rangeStartPos, int rangeEndPos) throws Exception {
        String encodedUrl = UrlUtil.getASCIIEncodedUrl(url);
        if (TextUtils.isEmpty((CharSequence)encodedUrl)) {
            throw new IllegalAccessException("URL Illegal");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(encodedUrl).openConnection();
        conn.setConnectTimeout(connectTimeout);
        conn.setRequestProperty("Charset", charset);
        conn.setRequestProperty("Accept-Encoding", "identity");
        if (rangeStartPos > 0 && rangeEndPos > 0 && rangeEndPos > rangeStartPos) {
            conn.setRequestProperty("Range", "bytes=" + rangeStartPos + "-" + rangeEndPos);
        }
        conn.connect();
        return conn;
    }
}

