/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.wlf.filedownloader.base.FailReason;
import org.wlf.filedownloader.http_downlaoder.HttpDownloader;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;

public class HttpFailReason
extends FailReason {
    private static final long serialVersionUID = 6959079784746888591L;
    public static final String TYPE_NETWORK_DENIED = HttpFailReason.class.getName() + "_TYPE_NETWORK_DENIED";
    public static final String TYPE_NETWORK_TIMEOUT = HttpFailReason.class.getName() + "_TYPE_NETWORK_TIMEOUT";
    public static final String TYPE_URL_ILLEGAL = HttpFailReason.class.getName() + "_TYPE_URL_ILLEGAL";
    public static final String TYPE_URL_OVER_REDIRECT_COUNT = HttpFailReason.class.getName() + "_TYPE_URL_OVER_REDIRECT_COUNT";
    public static final String TYPE_BAD_HTTP_RESPONSE_CODE = HttpFailReason.class.getName() + "_TYPE_BAD_HTTP_RESPONSE_CODE";
    public static final String TYPE_HTTP_FILE_NOT_EXIST = HttpFailReason.class.getName() + "_TYPE_HTTP_FILE_NOT_EXIST";

    public HttpFailReason(String detailMessage, String type) {
        super(detailMessage, type);
    }

    public HttpFailReason(Throwable throwable) {
        super(throwable);
    }

    @Override
    protected void onInitTypeWithThrowable(Throwable throwable) {
        super.onInitTypeWithThrowable(throwable);
        if (this.isTypeInit()) {
            return;
        }
        if (throwable instanceof FailReason) {
            FailReason failReason = (FailReason)throwable;
            this.setTypeByOriginalClassInstanceType(failReason.getOriginalCause());
            if (this.isTypeInit()) {
                return;
            }
            if (throwable instanceof HttpDownloader.HttpDownloadException) {
                HttpDownloader.HttpDownloadException httpDownloadException = (HttpDownloader.HttpDownloadException)throwable;
                String type = httpDownloadException.getType();
                if (HttpDownloader.HttpDownloadException.TYPE_NETWORK_TIMEOUT.equals(type)) {
                    this.setType(TYPE_NETWORK_TIMEOUT);
                } else if (HttpDownloader.HttpDownloadException.TYPE_NETWORK_DENIED.equals(type)) {
                    this.setType(TYPE_NETWORK_DENIED);
                }
            } else if (throwable instanceof OnDetectUrlFileListener.DetectUrlFileFailReason) {
                OnDetectUrlFileListener.DetectUrlFileFailReason detectUrlFileFailReason = (OnDetectUrlFileListener.DetectUrlFileFailReason)throwable;
                String type = detectUrlFileFailReason.getType();
                if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_NETWORK_DENIED.equals(type)) {
                    this.setType(TYPE_NETWORK_DENIED);
                } else if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_NETWORK_TIMEOUT.equals(type)) {
                    this.setType(TYPE_NETWORK_TIMEOUT);
                }
            }
        } else {
            this.setTypeByOriginalClassInstanceType(throwable);
        }
    }

    private void setTypeByOriginalClassInstanceType(Throwable throwable) {
        if (throwable instanceof SocketTimeoutException) {
            this.setType(TYPE_NETWORK_TIMEOUT);
        } else if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            this.setType(TYPE_NETWORK_DENIED);
        }
    }
}

