/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wlf.filedownloader.DetectUrlFileCacher;
import org.wlf.filedownloader.DetectUrlFileInfo;
import org.wlf.filedownloader.DetectUrlFileTask;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadFileStatusObserver;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloadTask;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;

class DownloadTaskManager {
    private static final String TAG = DownloadTaskManager.class.getSimpleName();
    private FileDownloadConfiguration mConfiguration;
    private DetectUrlFileCacher mDetectUrlFileCacher;
    private DownloadFileCacher mDownloadFileCacher;
    private DownloadFileStatusObserver mDownloadFileStatusObserver;
    private Map<String, FileDownloadTask> mFileDownloadTaskMap = new ConcurrentHashMap<String, FileDownloadTask>();

    DownloadTaskManager(FileDownloadConfiguration configuration, DownloadFileCacher downloadFileCacher) {
        this.mConfiguration = configuration;
        this.mDownloadFileCacher = downloadFileCacher;
        this.mDetectUrlFileCacher = new DetectUrlFileCacher();
        this.mDownloadFileStatusObserver = new DownloadFileStatusObserver();
    }

    boolean isInFileDownloadTaskMap(String url) {
        return this.getFileDownloadTask(url) != null;
    }

    private FileDownloadTask getFileDownloadTask(String url) {
        DownloadFileInfo downloadFileInfo = this.mDownloadFileCacher.getDownloadFile(url);
        if (downloadFileInfo == null) {
            return this.mFileDownloadTaskMap.get(url);
        }
        switch (downloadFileInfo.getStatus()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                FileDownloadTask task = this.mFileDownloadTaskMap.get(url);
                if (task == null || task.isStopped()) break;
                return task;
            }
        }
        if (this.mFileDownloadTaskMap.containsKey(url)) {
            this.mFileDownloadTaskMap.remove(url);
        }
        return null;
    }

    private DetectUrlFileInfo getDetectUrlFile(String url) {
        return this.mDetectUrlFileCacher.getDetectUrlFile(url);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mDownloadFileStatusObserver.addOnFileDownloadStatusListener(onFileDownloadStatusListener);
    }

    void unregisterDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mDownloadFileStatusObserver.removeOnFileDownloadStatusListener(onFileDownloadStatusListener);
    }

    private void addAndRunDetectUrlFileTask(Runnable task) {
        this.mConfiguration.getSupportEngine().execute(task);
    }

    private void addAndRunFileDownloadTask(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(FileDownloadTask.createByDownloadFile(downloadFileInfo), this.mDownloadFileCacher, onFileDownloadStatusListener);
        this.mFileDownloadTaskMap.put(fileDownloadTask.getUrl(), fileDownloadTask);
        this.mConfiguration.getFileDownloadEngine().execute(fileDownloadTask);
    }

    private void notifyFileDownloadStatusFailedWithCheck(String url, final OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason, final OnFileDownloadStatusListener onFileDownloadStatusListener, final boolean recordStatus) {
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            if (onFileDownloadStatusListener != null) {
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(url, downloadFileInfo, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), onFileDownloadStatusListener);
            }
            return;
        }
        final String downloadUrl = downloadFileInfo.getUrl();
        if (this.isInFileDownloadTaskMap(downloadUrl)) {
            FileDownloadTask fileDownloadTask = this.getFileDownloadTask(downloadUrl);
            if (fileDownloadTask != null) {
                fileDownloadTask.setOnStopFileDownloadTaskListener(new FileDownloadTask.OnStopFileDownloadTaskListener(){

                    @Override
                    public void onStopFileDownloadTaskSucceed(String url) {
                        DownloadTaskManager.this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
                    }

                    @Override
                    public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason2) {
                        DownloadTaskManager.this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason2), onFileDownloadStatusListener, recordStatus);
                    }
                });
                fileDownloadTask.stop();
            } else {
                this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
            }
        } else {
            this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
        }
    }

    private void notifyFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason, OnFileDownloadStatusListener onFileDownloadStatusListener, boolean recordStatus) {
        if (recordStatus) {
            try {
                this.mDownloadFileCacher.recordStatus(url, 7, 0);
            }
            catch (DownloadFileCacher.DownloadStatusRecordException e) {
                e.printStackTrace();
            }
        }
        if (onFileDownloadStatusListener != null) {
            OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(url, downloadFileInfo, failReason, onFileDownloadStatusListener);
        }
    }

    private void onFileDownloadTaskStopped(String url) {
        this.mFileDownloadTaskMap.remove(url);
    }

    void release(final OnReleaseListener onReleaseListener) {
        final Set<String> urls = this.mFileDownloadTaskMap.keySet();
        this.pause(new ArrayList<String>(urls), new FileDownloadTask.OnStopFileDownloadTaskListener(){
            private List<String> succeed = new ArrayList<String>();
            private List<String> failed = new ArrayList<String>();

            @Override
            public void onStopFileDownloadTaskSucceed(String url) {
                this.succeed.add(url);
                if (urls.size() == this.succeed.size() + this.failed.size()) {
                    DownloadTaskManager.this.clear();
                    if (onReleaseListener != null) {
                        onReleaseListener.onReleased();
                    }
                }
            }

            @Override
            public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                this.failed.add(url);
                if (urls.size() == this.succeed.size() + this.failed.size()) {
                    DownloadTaskManager.this.clear();
                    if (onReleaseListener != null) {
                        onReleaseListener.onReleased();
                    }
                }
            }
        });
    }

    private void clear() {
        this.mDetectUrlFileCacher.release();
        this.mDownloadFileCacher.release();
        this.mDownloadFileStatusObserver.release();
    }

    void detect(String url, OnDetectUrlFileListener onDetectUrlFileListener) {
        DetectUrlFileTask detectUrlFileTask = new DetectUrlFileTask(url, this.mConfiguration.getFileDownloadDir(), this.mDetectUrlFileCacher, this.mDownloadFileCacher);
        detectUrlFileTask.setOnDetectUrlFileListener(onDetectUrlFileListener);
        this.addAndRunDetectUrlFileTask(detectUrlFileTask);
    }

    void createAndStart(String url, String saveDir, String fileName) {
        DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
        if (detectUrlFileInfo == null) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT);
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, this.mDownloadFileStatusObserver, false);
            return;
        }
        detectUrlFileInfo.setFileDir(saveDir);
        detectUrlFileInfo.setFileName(fileName);
        this.createAndStartByDetectUrlFile(url, detectUrlFileInfo, this.mDownloadFileStatusObserver);
    }

    @Deprecated
    void createAndStart(String url, String saveDir, String fileName, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener);
        this.createAndStart(url, saveDir, fileName);
    }

    private void createAndStartByDetectUrlFile(String url, DetectUrlFileInfo detectUrlFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        if (detectUrlFileInfo == null) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT);
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, onFileDownloadStatusListener, false);
            return;
        }
        String downloadUrl = detectUrlFileInfo.getUrl();
        if (this.isInFileDownloadTaskMap(downloadUrl)) {
            return;
        }
        DownloadFileInfo downloadFileInfo = new DownloadFileInfo(detectUrlFileInfo);
        this.mDownloadFileCacher.addDownloadFile(downloadFileInfo);
        this.startInternal(downloadUrl, downloadFileInfo, onFileDownloadStatusListener);
    }

    private void startInternal(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (downloadFileInfo == null) {
            if (failReason == null) {
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the downloadFileInfo does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
            }
        } else {
            String downloadUrl = downloadFileInfo.getUrl();
            if (failReason == null && this.isInFileDownloadTaskMap(downloadUrl)) {
                return;
            }
        }
        if (failReason != null) {
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, onFileDownloadStatusListener, false);
            return;
        }
        this.addAndRunFileDownloadTask(downloadFileInfo, onFileDownloadStatusListener);
    }

    void start(String url) {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            this.startInternal(downloadFileInfo.getUrl(), downloadFileInfo, this.mDownloadFileStatusObserver);
        } else {
            DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
            if (detectUrlFileInfo != null) {
                this.createAndStartByDetectUrlFile(detectUrlFileInfo.getUrl(), detectUrlFileInfo, this.mDownloadFileStatusObserver);
            } else {
                this.detect(url, new OnDetectUrlFileListener(){

                    @Override
                    public void onDetectUrlFileFailed(String url, OnDetectUrlFileListener.DetectUrlFileFailReason failReason) {
                        DownloadTaskManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), DownloadTaskManager.this.mDownloadFileStatusObserver, false);
                    }

                    @Override
                    public void onDetectUrlFileExist(String url) {
                        DownloadTaskManager.this.startInternal(url, DownloadTaskManager.this.getDownloadFile(url), DownloadTaskManager.this.mDownloadFileStatusObserver);
                    }

                    @Override
                    public void onDetectNewDownloadFile(String url, String fileName, String savedDir, int fileSize) {
                        DownloadTaskManager.this.createAndStart(url, savedDir, fileName);
                    }
                });
            }
        }
    }

    @Deprecated
    void start(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener);
        this.start(url);
    }

    void start(List<String> urls) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.start(url);
        }
    }

    @Deprecated
    void start(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener);
        this.start(urls);
    }

    private boolean pauseInternal(String url, final FileDownloadTask.OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        FileDownloadTask fileDownloadTask = this.getFileDownloadTask(url);
        if (fileDownloadTask != null) {
            fileDownloadTask.setOnStopFileDownloadTaskListener(new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("pauseInternal \u6682\u505c\u6210\u529furl\uff1a" + url));
                    DownloadTaskManager.this.onFileDownloadTaskStopped(url);
                    if (onStopFileDownloadTaskListener != null) {
                        onStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(url);
                    }
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("pauseInternal \u6682\u505c\u5931\u8d25url\uff1a" + url + ",failReason:" + failReason));
                    if (onStopFileDownloadTaskListener != null) {
                        onStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(url, failReason);
                    }
                }
            });
            fileDownloadTask.stop();
            return true;
        }
        FileDownloadTask.OnStopDownloadFileTaskFailReason failReason = new FileDownloadTask.OnStopDownloadFileTaskFailReason("the task has been paused!", FileDownloadTask.OnStopDownloadFileTaskFailReason.TYPE_TASK_IS_STOPPED);
        Log.d((String)TAG, (String)("pauseInternal \u5df2\u7ecf\u6682\u505curl\uff1a" + url + ",failReason:" + failReason));
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            switch (downloadFileInfo.getStatus()) {
                case 1: 
                case 2: 
                case 3: {
                    downloadFileInfo.setStatus(6);
                    this.mDownloadFileCacher.updateDownloadFile(downloadFileInfo);
                }
            }
        }
        if (onStopFileDownloadTaskListener != null) {
            onStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(url, failReason);
        }
        return false;
    }

    void pause(String url, FileDownloadTask.OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.pauseInternal(url, onStopFileDownloadTaskListener);
    }

    void pause(List<String> urls, FileDownloadTask.OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.pause(url, onStopFileDownloadTaskListener);
        }
    }

    void pauseAll(List<String> urlsWillPause, FileDownloadTask.OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        Set<String> urls = this.mFileDownloadTaskMap.keySet();
        if (urlsWillPause != null) {
            urlsWillPause.addAll(urls);
            this.pause(urlsWillPause, onStopFileDownloadTaskListener);
        } else {
            this.pause(new ArrayList<String>(urls), onStopFileDownloadTaskListener);
        }
    }

    private void reStartInternal(String url) {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            downloadFileInfo.setDownloadedSize(0);
            downloadFileInfo.setFileDir(this.mConfiguration.getFileDownloadDir());
            this.mDownloadFileCacher.updateDownloadFile(downloadFileInfo);
        }
        this.start(url);
    }

    void reStart(String url) {
        if (this.isInFileDownloadTaskMap(url)) {
            this.pauseInternal(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    DownloadTaskManager.this.reStartInternal(url);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    if (failReason != null) {
                        if (FileDownloadTask.OnStopDownloadFileTaskFailReason.TYPE_TASK_IS_STOPPED.equals(failReason.getType())) {
                            DownloadTaskManager.this.reStartInternal(url);
                        } else {
                            DownloadTaskManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), DownloadTaskManager.this.mDownloadFileStatusObserver, false);
                        }
                    } else {
                        DownloadTaskManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), DownloadTaskManager.this.mDownloadFileStatusObserver, false);
                    }
                }
            });
        } else {
            this.reStartInternal(url);
        }
    }

    @Deprecated
    void reStart(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener);
        this.reStart(url);
    }

    void reStart(List<String> urls) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.reStart(url);
        }
    }

    @Deprecated
    void reStart(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener);
        this.reStart(urls);
    }

    static interface OnReleaseListener {
        public void onReleased();
    }
}

